/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import java.util.ArrayList;
import java.util.Arrays;
import proguard.classfile.ClassPool;
import proguard.classfile.visitor.ClassPoolVisitor;

public class MultiClassPoolVisitor
implements ClassPoolVisitor {
    private final ArrayList<ClassPoolVisitor> classPoolVisitors;

    public MultiClassPoolVisitor() {
        this.classPoolVisitors = new ArrayList();
    }

    public MultiClassPoolVisitor(ClassPoolVisitor ... classPoolVisitors) {
        this.classPoolVisitors = new ArrayList<ClassPoolVisitor>(Arrays.asList(classPoolVisitors));
    }

    public MultiClassPoolVisitor(ArrayList<ClassPoolVisitor> classPoolVisitors) {
        this.classPoolVisitors = classPoolVisitors;
    }

    public void addClassPoolVisitor(ClassPoolVisitor classPoolVisitor) {
        this.classPoolVisitors.add(classPoolVisitor);
    }

    @Override
    public void visitClassPool(ClassPool classPool) {
        for (ClassPoolVisitor classPoolVisitor : this.classPoolVisitors) {
            classPoolVisitor.visitClassPool(classPool);
        }
    }
}

