/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.defaults;

import java.time.Duration;
import java.time.Instant;
import proguard.analysis.cpa.defaults.CpaRun;
import proguard.analysis.cpa.interfaces.AbstractState;
import proguard.analysis.cpa.interfaces.ConfigurableProgramAnalysis;
import proguard.analysis.cpa.interfaces.ReachedSet;

public abstract class SequentialCpaRun<CpaT extends ConfigurableProgramAnalysis, AbstractStateT extends AbstractState, InputCpaRunT extends CpaRun>
extends CpaRun<CpaT, AbstractStateT> {
    protected final InputCpaRunT inputCpaRun;
    protected ReachedSet inputReachedSet;
    protected ReachedSet outputReachedSet;

    public SequentialCpaRun(InputCpaRunT inputCpaRun) {
        this.inputCpaRun = inputCpaRun;
    }

    @Override
    public ReachedSet execute() {
        Instant startTime = Instant.now();
        this.inputReachedSet = ((CpaRun)this.inputCpaRun).execute();
        Duration inputCpaDuration = Duration.between(startTime, Instant.now());
        if (this.abortOperator instanceof PreviousRunDurationReceiver) {
            ((PreviousRunDurationReceiver)((Object)this.abortOperator)).setPreviousCpaRunDuration(inputCpaDuration);
        }
        this.outputReachedSet = super.execute();
        return this.outputReachedSet;
    }

    public ReachedSet getOutputReachedSet() {
        return this.outputReachedSet == null ? (this.outputReachedSet = this.execute()) : this.outputReachedSet;
    }

    public InputCpaRunT getInputCpaRun() {
        return this.inputCpaRun;
    }

    public static interface PreviousRunDurationReceiver {
        public void setPreviousCpaRunDuration(Duration var1);
    }
}

