/*
 * Decompiled with CFR 0.152.
 */
package proguard.backport;

import java.util.HashSet;
import java.util.Set;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeToClassVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.InstructionToAttributeVisitor;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.ClassBuilder;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.ConstantPoolShrinker;
import proguard.classfile.editor.InstructionSequenceBuilder;
import proguard.classfile.editor.InstructionSequencesReplacer;
import proguard.classfile.editor.MemberAdder;
import proguard.classfile.editor.MemberRemover;
import proguard.classfile.editor.PeepholeEditor;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.ClassReferenceInitializer;
import proguard.classfile.util.ClassSuperHierarchyInitializer;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.InitializerMethodFilter;
import proguard.classfile.visitor.MemberAccessFilter;
import proguard.classfile.visitor.MemberCollector;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.classfile.visitor.MultiMemberVisitor;
import proguard.io.ExtraDataEntryNameMap;

public class StaticInterfaceMethodConverter
implements ClassVisitor {
    private final ClassPool programClassPool;
    private final ClassPool libraryClassPool;
    private final ExtraDataEntryNameMap extraDataEntryNameMap;
    private final ClassVisitor modifiedClassVisitor;
    private final MemberVisitor extraMemberVisitor;

    public StaticInterfaceMethodConverter(ClassPool programClassPool, ClassPool libraryClassPool, ExtraDataEntryNameMap extraDataEntryNameMap, ClassVisitor modifiedClassVisitor, MemberVisitor extraMemberVisitor) {
        this.programClassPool = programClassPool;
        this.libraryClassPool = libraryClassPool;
        this.extraDataEntryNameMap = extraDataEntryNameMap;
        this.modifiedClassVisitor = modifiedClassVisitor;
        this.extraMemberVisitor = extraMemberVisitor;
    }

    public void visitAnyClass(Clazz clazz) {
    }

    public void visitProgramClass(ProgramClass programClass) {
        HashSet<String> staticMethods = new HashSet<String>();
        programClass.accept((ClassVisitor)new AllMethodVisitor((MemberVisitor)new MemberAccessFilter(8, 0, (MemberVisitor)new InitializerMethodFilter(null, (MemberVisitor)new MemberCollector(false, true, true, staticMethods)))));
        if (!staticMethods.isEmpty()) {
            ProgramClass utilityClass = new ClassBuilder(0x2E0000, 4097, programClass.getName() + "$$Util", "java/lang/Object").addMethod(2, "<init>", "()V", 10, code -> code.aload_0().invokespecial("java/lang/Object", "<init>", "()V").return_()).getProgramClass();
            MemberAdder memberAdder = new MemberAdder(utilityClass);
            if (this.extraMemberVisitor != null) {
                memberAdder = new MultiMemberVisitor(new MemberVisitor[]{memberAdder, this.extraMemberVisitor});
            }
            MemberRemover memberRemover = new MemberRemover();
            programClass.accept((ClassVisitor)new AllMethodVisitor((MemberVisitor)new MemberAccessFilter(8, 0, (MemberVisitor)new InitializerMethodFilter(null, (MemberVisitor)new MultiMemberVisitor(new MemberVisitor[]{memberAdder, memberRemover})))));
            this.programClassPool.addClass((Clazz)utilityClass);
            this.extraDataEntryNameMap.addExtraClassToClass((Clazz)programClass, (Clazz)utilityClass);
            this.replaceInstructions(programClass, utilityClass, staticMethods);
            utilityClass.accept((ClassVisitor)new MultiClassVisitor(new ClassVisitor[]{new ClassSuperHierarchyInitializer(this.programClassPool, this.libraryClassPool), new ClassReferenceInitializer(this.programClassPool, this.libraryClassPool)}));
            programClass.accept((ClassVisitor)new MultiClassVisitor(new ClassVisitor[]{memberRemover, new ConstantPoolShrinker()}));
        }
    }

    private void replaceInstructions(ProgramClass interfaceClass, ProgramClass utilityClass, Set<String> staticMethods) {
        InstructionSequenceBuilder ____ = new InstructionSequenceBuilder(this.programClassPool, this.libraryClassPool);
        Instruction[][][] instructions = new Instruction[staticMethods.size()][][];
        int index = 0;
        for (String staticMethod : staticMethods) {
            String[] splitArray = staticMethod.split("\\.");
            String methodName = splitArray[0];
            String methodDesc = splitArray[1];
            Instruction[][] replacement = new Instruction[][]{____.invokestatic_interface(interfaceClass.getName(), methodName, methodDesc).__(), ____.invokestatic(utilityClass.getName(), methodName, methodDesc).__()};
            instructions[index++] = replacement;
        }
        CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor();
        InstructionToAttributeVisitor updatedClassVisitor = new InstructionToAttributeVisitor((AttributeVisitor)new AttributeToClassVisitor(this.modifiedClassVisitor));
        this.programClassPool.classesAccept((ClassVisitor)new MyReferencedClassFilter((Clazz)interfaceClass, (ClassVisitor)new AllMethodVisitor((MemberVisitor)new AllAttributeVisitor((AttributeVisitor)new PeepholeEditor(codeAttributeEditor, (InstructionVisitor)new InstructionSequencesReplacer(____.constants(), (Instruction[][][])instructions, null, codeAttributeEditor, (InstructionVisitor)updatedClassVisitor))))));
    }

    private static class MyReferencedClassFilter
    implements ClassVisitor,
    ConstantVisitor {
        private final Clazz referencedClass;
        private final ClassVisitor classVisitor;
        private boolean referenceClassFound;

        public MyReferencedClassFilter(Clazz referencedClass, ClassVisitor classVisitor) {
            this.referencedClass = referencedClass;
            this.classVisitor = classVisitor;
        }

        public void visitAnyClass(Clazz clazz) {
        }

        public void visitProgramClass(ProgramClass programClass) {
            this.referenceClassFound = false;
            programClass.constantPoolEntriesAccept((ConstantVisitor)this);
            if (this.referenceClassFound) {
                programClass.accept(this.classVisitor);
            }
        }

        public void visitAnyConstant(Clazz clazz, Constant constant) {
        }

        public void visitAnyRefConstant(Clazz clazz, RefConstant refConstant) {
            if (refConstant.referencedClass == this.referencedClass) {
                this.referenceClassFound = true;
            }
        }
    }
}

