/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.apidiff;

import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.apidiff.ApiDiff;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.Signatures;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.lang.annotation.Annotation;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

public abstract class ApiDiffChecker
extends BugChecker
implements BugChecker.IdentifierTreeMatcher,
BugChecker.MemberSelectTreeMatcher {
    private final ApiDiff apiDiff;
    private final Optional<Class<? extends Annotation>> alsoForbidApisAnnotated;

    protected ApiDiffChecker(ApiDiff apiDiff) {
        this.apiDiff = apiDiff;
        this.alsoForbidApisAnnotated = Optional.empty();
    }

    protected ApiDiffChecker(ApiDiff apiDiff, Class<? extends Annotation> alsoForbidApisAnnotated) {
        this.apiDiff = apiDiff;
        this.alsoForbidApisAnnotated = Optional.of(alsoForbidApisAnnotated);
    }

    public Description matchIdentifier(IdentifierTree tree, VisitorState state) {
        return this.check(tree, state);
    }

    public Description matchMemberSelect(MemberSelectTree tree, VisitorState state) {
        return this.check(tree, state);
    }

    protected Description check(ExpressionTree tree, VisitorState state) {
        if (state.findEnclosing(new Class[]{ImportTree.class}) != null) {
            return Description.NO_MATCH;
        }
        Symbol sym = ASTHelpers.getSymbol((Tree)tree);
        if (sym == null) {
            return Description.NO_MATCH;
        }
        Symbol.ClassSymbol receiver = ApiDiffChecker.getReceiver(tree, sym);
        if (receiver == null) {
            return Description.NO_MATCH;
        }
        if (this.apiDiff.isClassUnsupported(Signatures.classDescriptor((Type)receiver.type, (VisitorState)state)) || this.classOrEnclosingClassIsForbiddenByAnnotation(receiver, state)) {
            return this.buildDescription(tree).setMessage(String.format("%s is not available", receiver)).build();
        }
        if (!(sym instanceof Symbol.VarSymbol) && !(sym instanceof Symbol.MethodSymbol)) {
            return Description.NO_MATCH;
        }
        ApiDiff.ClassMemberKey memberKey = ApiDiff.ClassMemberKey.create(sym.getSimpleName().toString(), Signatures.descriptor((Type)sym.type, (VisitorState)state));
        Symbol.ClassSymbol owner = ASTHelpers.enclosingClass((Symbol)sym);
        if (this.apiDiff.isMemberUnsupported(Signatures.classDescriptor((Type)owner.type, (VisitorState)state), memberKey) || this.hasAnnotationForbiddingUse(sym, state)) {
            return this.buildDescription(tree).setMessage(String.format("%s#%s is not available in %s", owner, sym, receiver)).build();
        }
        return Description.NO_MATCH;
    }

    private boolean classOrEnclosingClassIsForbiddenByAnnotation(Symbol clazz, VisitorState state) {
        if (!this.alsoForbidApisAnnotated.isPresent()) {
            return false;
        }
        while (clazz instanceof Symbol.ClassSymbol) {
            if (this.hasAnnotationForbiddingUse(clazz, state)) {
                return true;
            }
            clazz = clazz.owner;
        }
        return false;
    }

    private boolean hasAnnotationForbiddingUse(Symbol sym, VisitorState state) {
        return this.alsoForbidApisAnnotated.isPresent() && ASTHelpers.hasAnnotation((Symbol)sym, (String)this.alsoForbidApisAnnotated.get().getName(), (VisitorState)state);
    }

    private static @Nullable Symbol.ClassSymbol getReceiver(ExpressionTree tree, Symbol sym) {
        if (ASTHelpers.isStatic((Symbol)sym) || sym instanceof Symbol.ClassSymbol) {
            return sym.enclClass();
        }
        switch (tree.getKind()) {
            case MEMBER_SELECT: 
            case METHOD_INVOCATION: {
                Type receiver = ASTHelpers.getType((Tree)ASTHelpers.getReceiver((ExpressionTree)tree));
                if (receiver == null) {
                    return null;
                }
                return receiver.tsym.enclClass();
            }
            case IDENTIFIER: {
                return null;
            }
        }
        return null;
    }
}

