/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.android;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import javax.lang.model.element.Modifier;

@BugPattern(summary="Static and default interface methods are not natively supported on older Android devices. ", severity=BugPattern.SeverityLevel.ERROR, documentSuppression=false)
public class StaticOrDefaultInterfaceMethod
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final Matcher<Tree> IS_STATIC_OR_DEFAULT_METHOD_ON_INTERFACE = Matchers.allOf((Matcher[])new Matcher[]{Matchers.enclosingClass((Matcher)Matchers.kindIs((Tree.Kind)Tree.Kind.INTERFACE)), Matchers.anyOf((Matcher[])new Matcher[]{Matchers.hasModifier((Modifier)Modifier.STATIC), Matchers.hasModifier((Modifier)Modifier.DEFAULT)})});

    public Description matchMethod(MethodTree tree, VisitorState state) {
        if (!state.isAndroidCompatible()) {
            return Description.NO_MATCH;
        }
        if (IS_STATIC_OR_DEFAULT_METHOD_ON_INTERFACE.matches((Tree)tree, state)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }
}

