/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.dataflow.nullnesspropagation.Nullness;
import com.google.errorprone.dataflow.nullnesspropagation.NullnessAnalysis;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.FieldMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Context;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;

@BugPattern(summary="The non-constant portion of a comparison generally comes first. For equality, prefer e.equals(CONSTANT) if e is non-null or Objects.equals(e, CONSTANT) if e may be null. For standard operators, prefer e <OPERATION> CONSTANT.", severity=BugPattern.SeverityLevel.WARNING)
public final class YodaCondition
extends BugChecker
implements BugChecker.BinaryTreeMatcher,
BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> IGNORELIST = FieldMatchers.staticField((String)"android.os.Build.VERSION", (String)"SDK_INT");
    private static final Pattern CONSTANT_CASE = Pattern.compile("[A-Z0-9_]+");

    public Description matchBinary(BinaryTree tree, VisitorState state) {
        return switch (tree.getKind()) {
            case Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO, Tree.Kind.LESS_THAN, Tree.Kind.GREATER_THAN, Tree.Kind.LESS_THAN_EQUAL, Tree.Kind.GREATER_THAN_EQUAL -> this.fix(tree, tree.getLeftOperand(), tree.getRightOperand(), false, state);
            default -> Description.NO_MATCH;
        };
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (Matchers.staticEqualsInvocation().matches((Tree)tree, state)) {
            return this.fix(tree, tree.getArguments().get(0), tree.getArguments().get(1), false, state);
        }
        if (Matchers.instanceEqualsInvocation().matches((Tree)tree, state)) {
            ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)tree);
            if (receiver == null) {
                return Description.NO_MATCH;
            }
            return this.fix(tree, receiver, tree.getArguments().get(0), true, state);
        }
        return Description.NO_MATCH;
    }

    private Description fix(Tree tree, ExpressionTree lhs, ExpressionTree rhs, boolean provideNullSafeFix, VisitorState state) {
        if (!YodaCondition.yodaCondition(lhs, rhs, state)) {
            return Description.NO_MATCH;
        }
        if (YodaCondition.isInequality(tree) && YodaCondition.hasAdjacentComparison(state)) {
            return Description.NO_MATCH;
        }
        Description.Builder description = this.buildDescription(lhs);
        if (provideNullSafeFix && !ASTHelpers.getNullnessValue((ExpressionTree)rhs, (VisitorState)state, (NullnessAnalysis)NullnessAnalysis.instance((Context)state.context)).equals((Object)Nullness.NONNULL)) {
            SuggestedFix.Builder fix = SuggestedFix.builder().setShortDescription("null-safe fix");
            description.addFix((Fix)fix.replace(tree, String.format("%s.equals(%s, %s)", SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)Objects.class.getName()), state.getSourceForNode((Tree)rhs), state.getSourceForNode((Tree)lhs))).build());
        }
        return description.addFix((Fix)(YodaCondition.isInequality(tree) ? SuggestedFix.replace((Tree)tree, (String)String.format("%s %s %s", state.getSourceForNode((Tree)rhs), YodaCondition.inverse(tree), state.getSourceForNode((Tree)lhs))) : SuggestedFix.swap((Tree)lhs, (Tree)rhs, (VisitorState)state))).build();
    }

    private static boolean hasAdjacentComparison(VisitorState state) {
        boolean putativeVariableOnRight;
        BinaryTree tree = (BinaryTree)state.getPath().getLeaf();
        ConstantKind l = YodaCondition.seemsConstant(tree.getLeftOperand(), state);
        ConstantKind r = YodaCondition.seemsConstant(tree.getRightOperand(), state);
        boolean bl = putativeVariableOnRight = l.constness > r.constness;
        if (putativeVariableOnRight) {
            ExpressionTree right = YodaCondition.expressionToRight(state);
            return right != null && right.toString().equals(tree.getRightOperand().toString());
        }
        return false;
    }

    private static @Nullable ExpressionTree expressionToRight(VisitorState state) {
        TreePath path = state.getPath();
        while (true) {
            Tree tree = path.getLeaf();
            TreePath parentPath = path.getParentPath();
            Tree parent = parentPath.getLeaf();
            if (!(parent instanceof BinaryTree)) break;
            BinaryTree binaryTree = (BinaryTree)parent;
            if (binaryTree.getLeftOperand() == tree) {
                ExpressionTree right = binaryTree.getRightOperand();
                return YodaCondition.isInequality(right) ? ((BinaryTree)right).getLeftOperand() : null;
            }
            path = path.getParentPath();
        }
        return null;
    }

    private static boolean isInequality(Tree tree) {
        return switch (tree.getKind()) {
            case Tree.Kind.LESS_THAN, Tree.Kind.GREATER_THAN, Tree.Kind.LESS_THAN_EQUAL, Tree.Kind.GREATER_THAN_EQUAL -> true;
            default -> false;
        };
    }

    private static String inverse(Tree tree) {
        return switch (tree.getKind()) {
            case Tree.Kind.LESS_THAN -> ">";
            case Tree.Kind.GREATER_THAN -> "<";
            case Tree.Kind.LESS_THAN_EQUAL -> ">=";
            case Tree.Kind.GREATER_THAN_EQUAL -> "<=";
            default -> throw new AssertionError();
        };
    }

    private static boolean yodaCondition(ExpressionTree lhs, ExpressionTree rhs, VisitorState state) {
        ConstantKind l = YodaCondition.seemsConstant(lhs, state);
        ConstantKind r = YodaCondition.seemsConstant(rhs, state);
        return l.constness > r.constness;
    }

    private static ConstantKind seemsConstant(ExpressionTree tree, VisitorState state) {
        if (IGNORELIST.matches((Tree)tree, state)) {
            return ConstantKind.NON_CONSTANT;
        }
        if (ASTHelpers.constValue((Tree)tree) != null) {
            return ConstantKind.CONSTANT;
        }
        if (tree.getKind().equals((Object)Tree.Kind.NULL_LITERAL)) {
            return ConstantKind.NULL;
        }
        Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
        if (symbol instanceof Symbol.VarSymbol && (symbol.isEnum() || ASTHelpers.isStatic((Symbol)symbol) && CONSTANT_CASE.matcher(symbol.getSimpleName().toString()).matches())) {
            return ConstantKind.CONSTANT_VARIABLE;
        }
        return ConstantKind.NON_CONSTANT;
    }

    static enum ConstantKind {
        NULL(3),
        CONSTANT(2),
        CONSTANT_VARIABLE(1),
        NON_CONSTANT(0);

        final int constness;

        private ConstantKind(int constness) {
            this.constness = constness;
        }
    }
}

