/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.ErrorProneTokens;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.util.Context;
import java.util.List;

@BugPattern(severity=BugPattern.SeverityLevel.WARNING, summary="This type parameter is unused and can be removed.")
public final class UnusedTypeParameter
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        final ImmutableMultiset<Symbol.TypeVariableSymbol> usedIdentifiers = UnusedTypeParameter.findUsedIdentifiers(tree);
        new BugChecker.SuppressibleTreePathScanner<Void, Void>(this, state){
            final /* synthetic */ UnusedTypeParameter this$0;
            {
                this.this$0 = this$0;
                super((BugChecker)this$0, state);
            }

            public Void visitClass(ClassTree node, Void unused) {
                if ((ASTHelpers.getSymbol((ClassTree)node).flags() & 0x10L) != 0L) {
                    this.handle(node, node.getTypeParameters());
                }
                return (Void)super.visitClass(node, null);
            }

            public Void visitMethod(MethodTree node, Void unused) {
                Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MethodTree)node);
                if (ASTHelpers.methodCanBeOverridden((Symbol.MethodSymbol)symbol) || !ASTHelpers.findSuperMethods((Symbol.MethodSymbol)symbol, (Types)this.state.getTypes()).isEmpty()) {
                    return null;
                }
                this.handle(node, node.getTypeParameters());
                return (Void)super.visitMethod(node, null);
            }

            private void handle(Tree tree, List<? extends TypeParameterTree> typeParameters) {
                for (TypeParameterTree typeParameterTree : typeParameters) {
                    if (usedIdentifiers.count((Object)ASTHelpers.getSymbol((Tree)typeParameterTree)) != 1) continue;
                    this.state.reportMatch(this.this$0.describeMatch(typeParameterTree, (Fix)UnusedTypeParameter.removeTypeParameter(tree, typeParameterTree, typeParameters, this.state)));
                }
            }
        }.scan(state.getPath(), null);
        return Description.NO_MATCH;
    }

    private static ImmutableMultiset<Symbol.TypeVariableSymbol> findUsedIdentifiers(CompilationUnitTree tree) {
        final ImmutableMultiset.Builder identifiers = ImmutableMultiset.builder();
        new TreeScanner<Void, Void>(){

            @Override
            public Void scan(Tree tree, Void unused) {
                Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
                if (symbol instanceof Symbol.TypeVariableSymbol) {
                    Symbol.TypeVariableSymbol typeVariableSymbol = (Symbol.TypeVariableSymbol)symbol;
                    identifiers.add((Object)typeVariableSymbol);
                }
                return (Void)super.scan(tree, null);
            }
        }.scan((Tree)tree, null);
        return identifiers.build();
    }

    private static SuggestedFix removeTypeParameter(Tree tree, TypeParameterTree typeParameter, List<? extends TypeParameterTree> typeParameters, VisitorState state) {
        if (typeParameters.size() > 1) {
            return SuggestedFixes.removeElement((Tree)typeParameter, typeParameters, (VisitorState)state);
        }
        ImmutableList tokens = ErrorProneTokens.getTokens((String)state.getSourceForNode(tree), (int)ASTHelpers.getStartPosition((Tree)tree), (Context)state.context);
        int startPos = tokens.reverse().stream().filter(t -> t.pos() <= ASTHelpers.getStartPosition((Tree)typeParameter) && t.kind().equals(Tokens.TokenKind.LT)).findFirst().get().pos();
        int endPos = tokens.stream().filter(t -> t.endPos() >= state.getEndPosition((Tree)Iterables.getLast((Iterable)typeParameters)) && (t.kind().equals(Tokens.TokenKind.GT) || t.kind().equals(Tokens.TokenKind.GTGT))).findFirst().get().endPos();
        return SuggestedFix.replace((int)startPos, (int)endPos, (String)"");
    }
}

