/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.io.Serializable;
import java.util.stream.Stream;

@BugPattern(summary="A qualifier annotation has no effect here.", severity=BugPattern.SeverityLevel.WARNING)
public final class UnnecessaryQualifier
extends BugChecker
implements BugChecker.MethodTreeMatcher,
BugChecker.VariableTreeMatcher {
    private static final ImmutableSet<String> QUALIFIERS = ImmutableSet.of((Object)"com.google.inject.BindingAnnotation", (Object)"javax.inject.Qualifier");
    private static final Supplier<ImmutableSet<Type>> SUPERTYPES_DENOTING_INJECTION_POINTS = VisitorState.memoize((Supplier & Serializable)s -> (ImmutableSet)Stream.of(s.getTypeFromString("com.google.apps.framework.producers.GraphWrapper")).filter(x -> x != null).collect(ImmutableSet.toImmutableSet()));
    private static final ImmutableSet<String> PROVIDER_METHODS = ImmutableSet.of((Object)"com.google.inject.throwingproviders.CheckedProvides", (Object)"dagger.Binds", (Object)"dagger.BindsInstance", (Object)"dagger.BindsOptionalOf", (Object)"dagger.Provides", (Object)"dagger.multibindings.Multibinds", (Object[])new String[]{"dagger.producers.Produces"});
    private static final String PROVIDES_PREFIX = "Provides";
    private static final ImmutableSet<String> INJECTION_METHODS = (ImmutableSet)Streams.concat((Stream[])new Stream[]{Stream.of("com.google.auto.factory.AutoFactory", "com.google.common.inject.components.OtherRequiredBindings", "com.google.inject.Inject", "dagger.assisted.AssistedInject", "jakarta.inject.Inject", "javax.inject.Inject"), PROVIDER_METHODS.stream()}).collect(ImmutableSet.toImmutableSet());
    private static final ImmutableSet<String> INJECTION_FIELDS = ImmutableSet.of((Object)"com.google.inject.Inject", (Object)"dagger.Binds", (Object)"dagger.BindsInstance", (Object)"dagger.hilt.android.testing.BindElementsIntoSet", (Object)"dagger.hilt.android.testing.BindValue", (Object)"dagger.hilt.android.testing.BindValueIntoMap", (Object[])new String[]{"dagger.hilt.android.testing.BindValueIntoSet", "jakarta.inject.Inject", "javax.inject.Inject"});
    private static final ImmutableSet<String> CLASS_ANNOTATIONS_EXEMPTING_METHODS = ImmutableSet.of((Object)"com.google.auto.factory.AutoFactory", (Object)"dagger.Component", (Object)"dagger.Component.Builder", (Object)"dagger.Component.Factory", (Object)"dagger.Subcomponent", (Object)"dagger.Subcomponent.Builder", (Object[])new String[]{"dagger.Subcomponent.Builder.Factory", "dagger.hilt.EntryPoint", "dagger.producers.ProductionComponent", "dagger.producers.ProductionComponent.Builder", "dagger.producers.ProductionComponent.Factory", "dagger.producers.ProductionSubcomponent", "dagger.producers.ProductionSubcomponent.Builder", "dagger.producers.ProductionSubcomponent.Factory"});
    private static final ImmutableSet<String> IGNORED_ANNOTATIONS = ImmutableSet.of((Object)"com.google.inject.assistedinject.Assisted");

    public Description matchMethod(MethodTree tree, VisitorState state) {
        ImmutableList<AnnotationTree> annotations = UnnecessaryQualifier.getQualifiers(tree.getModifiers(), state);
        if (annotations.isEmpty()) {
            return Description.NO_MATCH;
        }
        if (PROVIDER_METHODS.stream().anyMatch(ip -> ASTHelpers.hasAnnotation((Tree)tree, (String)ip, (VisitorState)state))) {
            return Description.NO_MATCH;
        }
        if (tree.getModifiers().getAnnotations().stream().anyMatch(anno -> ASTHelpers.getSymbol((Tree)anno).getSimpleName().toString().startsWith(PROVIDES_PREFIX))) {
            return Description.NO_MATCH;
        }
        ClassTree enclosingClass = (ClassTree)state.findEnclosing(new Class[]{ClassTree.class});
        if (ASTHelpers.getSymbol((ClassTree)enclosingClass).isInterface()) {
            return Description.NO_MATCH;
        }
        if (CLASS_ANNOTATIONS_EXEMPTING_METHODS.stream().anyMatch(anno -> ASTHelpers.hasAnnotation((Tree)enclosingClass, (String)anno, (VisitorState)state))) {
            return Description.NO_MATCH;
        }
        return this.deleteAnnotations(annotations);
    }

    public Description matchVariable(VariableTree tree, VisitorState state) {
        ImmutableList<AnnotationTree> annotations = UnnecessaryQualifier.getQualifiers(tree.getModifiers(), state);
        if (annotations.isEmpty()) {
            return Description.NO_MATCH;
        }
        Symbol.VarSymbol symbol = ASTHelpers.getSymbol((VariableTree)tree);
        switch (symbol.getKind()) {
            case FIELD: {
                if (!INJECTION_FIELDS.stream().anyMatch(ip -> ASTHelpers.hasAnnotation((Tree)tree, (String)ip, (VisitorState)state))) break;
                return Description.NO_MATCH;
            }
            case PARAMETER: {
                if (state.getPath().getParentPath().getLeaf() instanceof LambdaExpressionTree) {
                    return this.deleteAnnotations(annotations);
                }
                MethodTree method = (MethodTree)state.findEnclosing(new Class[]{MethodTree.class});
                if (method == null) {
                    return Description.NO_MATCH;
                }
                Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol((MethodTree)method);
                if (methodSymbol != symbol.owner) {
                    return Description.NO_MATCH;
                }
                if (INJECTION_METHODS.stream().anyMatch(ip -> ASTHelpers.hasAnnotation((Tree)method, (String)ip, (VisitorState)state))) {
                    return Description.NO_MATCH;
                }
                if (method.getModifiers().getAnnotations().stream().anyMatch(anno -> ASTHelpers.getSymbol((Tree)anno).getSimpleName().toString().startsWith(PROVIDES_PREFIX))) {
                    return Description.NO_MATCH;
                }
                if (((ImmutableSet)SUPERTYPES_DENOTING_INJECTION_POINTS.get(state)).stream().anyMatch(st -> ASTHelpers.isSubtype((Type)methodSymbol.owner.type, (Type)st, (VisitorState)state))) {
                    return Description.NO_MATCH;
                }
                ClassTree enclosingClass = (ClassTree)state.findEnclosing(new Class[]{ClassTree.class});
                if (!CLASS_ANNOTATIONS_EXEMPTING_METHODS.stream().anyMatch(anno -> ASTHelpers.hasAnnotation((Tree)enclosingClass, (String)anno, (VisitorState)state))) break;
                return Description.NO_MATCH;
            }
        }
        return this.deleteAnnotations(annotations);
    }

    private Description deleteAnnotations(ImmutableList<AnnotationTree> annotations) {
        return this.describeMatch((Tree)annotations.get(0), (Fix)annotations.stream().map(SuggestedFix::delete).collect(SuggestedFix.mergeFixes()));
    }

    private static ImmutableList<AnnotationTree> getQualifiers(ModifiersTree modifiers, VisitorState state) {
        return (ImmutableList)modifiers.getAnnotations().stream().filter(anno -> QUALIFIERS.stream().anyMatch(q -> ASTHelpers.hasAnnotation((Symbol)ASTHelpers.getSymbol((Tree)anno), (String)q, (VisitorState)state)) && !IGNORED_ANNOTATIONS.contains((Object)ASTHelpers.getSymbol((Tree)anno).getQualifiedName().toString())).collect(ImmutableList.toImmutableList());
    }
}

