/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.CaseFormat;
import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import org.jspecify.annotations.Nullable;

@BugPattern(summary="Returning a lambda from a helper method or saving it in a constant is unnecessary; prefer to implement the functional interface method directly and use a method reference instead.", severity=BugPattern.SeverityLevel.WARNING)
public class UnnecessaryLambda
extends BugChecker
implements BugChecker.MethodTreeMatcher,
BugChecker.VariableTreeMatcher {
    private static final CharMatcher UPPER_CASE = CharMatcher.inRange((char)'A', (char)'Z').or(CharMatcher.is((char)'_')).or(CharMatcher.inRange((char)'0', (char)'9'));
    private static final ImmutableSet<String> PACKAGES_TO_FIX = ImmutableSet.of((Object)"com.google.common.base", (Object)"com.google.errorprone.matchers", (Object)"java.util.function", (Object)"java.lang");
    private static final SimpleTreeVisitor<LambdaExpressionTree, Void> LAMBDA_VISITOR = new SimpleTreeVisitor<LambdaExpressionTree, Void>(){

        @Override
        public LambdaExpressionTree visitLambdaExpression(LambdaExpressionTree node, Void unused) {
            return node;
        }

        @Override
        public @Nullable LambdaExpressionTree visitBlock(BlockTree node, Void unused) {
            return node.getStatements().size() == 1 ? ((StatementTree)Iterables.getOnlyElement(node.getStatements())).accept(this, null) : null;
        }

        @Override
        public @Nullable LambdaExpressionTree visitReturn(ReturnTree node, Void unused) {
            return node.getExpression() != null ? node.getExpression().accept(this, null) : null;
        }

        @Override
        public LambdaExpressionTree visitTypeCast(TypeCastTree node, Void unused) {
            return node.getExpression().accept(this, null);
        }

        @Override
        public LambdaExpressionTree visitParenthesized(ParenthesizedTree node, Void unused) {
            return node.getExpression().accept(this, null);
        }
    };

    public Description matchMethod(MethodTree tree, final VisitorState state) {
        if (!tree.getParameters().isEmpty() || !tree.getThrows().isEmpty()) {
            return Description.NO_MATCH;
        }
        LambdaExpressionTree lambda = LAMBDA_VISITOR.visit(tree.getBody(), null);
        if (lambda == null) {
            return Description.NO_MATCH;
        }
        final Symbol.MethodSymbol sym = ASTHelpers.getSymbol((MethodTree)tree);
        if (!ASTHelpers.canBeRemoved((Symbol)sym, (VisitorState)state) || ASTHelpers.shouldKeep((Tree)tree)) {
            return Description.NO_MATCH;
        }
        final SuggestedFix.Builder fix = SuggestedFix.builder();
        final String name = tree.getName().toString();
        Tree type = tree.getReturnType();
        if (!this.canFix(type, sym, state)) {
            return Description.NO_MATCH;
        }
        if (state.isAndroidCompatible()) {
            return Description.NO_MATCH;
        }
        final boolean[] usedInEnhancedForLoop = new boolean[]{false};
        new TreePathScanner<Void, Void>(this){
            final /* synthetic */ UnnecessaryLambda this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Void visitMethodInvocation(MethodInvocationTree node, Void unused) {
                if (Objects.equals(ASTHelpers.getSymbol((MethodInvocationTree)node), sym)) {
                    EnhancedForLoopTree enhancedForLoopTree;
                    Tree parent = this.getCurrentPath().getParentPath().getLeaf();
                    if (parent instanceof EnhancedForLoopTree && (enhancedForLoopTree = (EnhancedForLoopTree)parent).getExpression().equals(node)) {
                        usedInEnhancedForLoop[0] = true;
                    } else {
                        UnnecessaryLambda.replaceUseWithMethodReference(fix, node, name, state.withPath(this.getCurrentPath()));
                    }
                }
                return (Void)super.visitMethodInvocation(node, null);
            }
        }.scan(state.getPath().getCompilationUnit(), null);
        if (usedInEnhancedForLoop[0]) {
            return Description.NO_MATCH;
        }
        this.lambdaToMethod(state, lambda, fix, name, type);
        return this.describeMatch(tree, (Fix)fix.build());
    }

    public Description matchVariable(VariableTree tree, final VisitorState state) {
        if (tree.getInitializer() == null) {
            return Description.NO_MATCH;
        }
        LambdaExpressionTree lambda = LAMBDA_VISITOR.visit(tree.getInitializer(), null);
        if (lambda == null) {
            return Description.NO_MATCH;
        }
        final Symbol.VarSymbol sym = ASTHelpers.getSymbol((VariableTree)tree);
        if (((Symbol)sym).getKind() != ElementKind.FIELD || !sym.isPrivate() || !sym.getModifiers().contains((Object)Modifier.FINAL)) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.hasAnnotation((Tree)tree, (String)"com.google.inject.testing.fieldbinder.Bind", (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        Tree type = tree.getType();
        if (!this.canFix(type, sym, state)) {
            return Description.NO_MATCH;
        }
        if (state.isAndroidCompatible()) {
            return Description.NO_MATCH;
        }
        final SuggestedFix.Builder fix = SuggestedFix.builder();
        String varName = tree.getName().toString();
        final String methodName = ASTHelpers.isStatic((Symbol)sym) && UPPER_CASE.matchesAllOf((CharSequence)varName) ? (String)CaseFormat.UPPER_UNDERSCORE.converterTo(CaseFormat.LOWER_CAMEL).convert((Object)varName) : varName;
        new TreePathScanner<Void, Void>(this){
            final /* synthetic */ UnnecessaryLambda this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Void visitMemberSelect(MemberSelectTree node, Void unused) {
                if (Objects.equals(ASTHelpers.getSymbol((Tree)node), sym)) {
                    UnnecessaryLambda.replaceUseWithMethodReference(fix, node, methodName, state.withPath(this.getCurrentPath()));
                }
                return (Void)super.visitMemberSelect(node, null);
            }

            @Override
            public Void visitIdentifier(IdentifierTree node, Void unused) {
                if (Objects.equals(ASTHelpers.getSymbol((Tree)node), sym)) {
                    UnnecessaryLambda.replaceUseWithMethodReference(fix, node, methodName, state.withPath(this.getCurrentPath()));
                }
                return (Void)super.visitIdentifier(node, null);
            }
        }.scan(state.getPath().getCompilationUnit(), null);
        SuggestedFixes.removeModifiers((Tree)tree, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.FINAL}).ifPresent(arg_0 -> ((SuggestedFix.Builder)fix).merge(arg_0));
        this.lambdaToMethod(state, lambda, fix, methodName, type);
        return this.describeMatch(tree, (Fix)fix.build());
    }

    private boolean canFix(Tree type, final Symbol sym, VisitorState state) {
        Symbol descriptor;
        try {
            descriptor = state.getTypes().findDescriptorSymbol(ASTHelpers.getType((Tree)type).asElement());
        }
        catch (Types.FunctionDescriptorLookupError e) {
            return false;
        }
        if (!PACKAGES_TO_FIX.contains((Object)ASTHelpers.enclosingPackage((Symbol)descriptor).getQualifiedName().toString())) {
            return false;
        }
        class Scanner
        extends TreePathScanner<Void, Void> {
            boolean fixable = true;
            boolean inInitializer = false;
            final /* synthetic */ UnnecessaryLambda this$0;

            Scanner() {
                this.this$0 = this$0;
            }

            @Override
            public Void visitMethodInvocation(MethodInvocationTree node, Void unused) {
                this.check(node);
                return (Void)super.visitMethodInvocation(node, null);
            }

            @Override
            public Void visitVariable(VariableTree node, Void unused) {
                boolean wasInInitializer = this.inInitializer;
                if (sym.equals(ASTHelpers.getSymbol((VariableTree)node))) {
                    this.inInitializer = true;
                }
                super.visitVariable(node, null);
                this.inInitializer = wasInInitializer;
                return null;
            }

            @Override
            public Void visitMemberSelect(MemberSelectTree node, Void unused) {
                if (this.inInitializer && sym.equals(ASTHelpers.getSymbol((Tree)node))) {
                    this.fixable = false;
                }
                return (Void)super.visitMemberSelect(node, null);
            }

            private void check(MethodInvocationTree node) {
                ExpressionTree lhs = node.getMethodSelect();
                if (!(lhs instanceof MemberSelectTree)) {
                    return;
                }
                MemberSelectTree memberSelectTree = (MemberSelectTree)lhs;
                ExpressionTree receiver = memberSelectTree.getExpression();
                if (!Objects.equals(sym, ASTHelpers.getSymbol((Tree)receiver))) {
                    return;
                }
                Symbol symbol = ASTHelpers.getSymbol((Tree)lhs);
                if (Objects.equals(descriptor, symbol)) {
                    return;
                }
                this.fixable = false;
            }
        }
        Scanner scanner = new Scanner();
        scanner.scan(state.getPath().getCompilationUnit(), null);
        return scanner.fixable;
    }

    private void lambdaToMethod(VisitorState state, LambdaExpressionTree lambda, SuggestedFix.Builder fix, String name, Tree type) {
        Type fi = state.getTypes().findDescriptorType(ASTHelpers.getType((Tree)type));
        Tree tree = state.getPath().getLeaf();
        ModifiersTree modifiers = ASTHelpers.getModifiers((Tree)tree);
        int endPosition = state.getEndPosition(tree);
        StringBuilder replacement = new StringBuilder();
        replacement.append(String.format(" %s %s(", SuggestedFixes.prettyType((VisitorState)state, (SuggestedFix.Builder)fix, (Type)fi.getReturnType()), name));
        replacement.append(Streams.zip(fi.getParameterTypes().stream(), lambda.getParameters().stream(), (t, p) -> String.format("%s %s", SuggestedFixes.prettyType((VisitorState)state, (SuggestedFix.Builder)fix, (Type)t), p.getName())).collect(Collectors.joining(", ")));
        replacement.append(")");
        if (lambda.getBody() instanceof BlockTree) {
            replacement.append(state.getSourceForNode(lambda.getBody()));
        } else {
            replacement.append("{");
            if (!fi.getReturnType().hasTag(TypeTag.VOID)) {
                replacement.append("return ");
            }
            replacement.append(state.getSourceForNode(lambda.getBody()));
            replacement.append(";");
            replacement.append("}");
        }
        int modifiedEndPos = state.getEndPosition((Tree)modifiers);
        fix.replace(modifiedEndPos == -1 ? ASTHelpers.getStartPosition((Tree)tree) : modifiedEndPos + 1, endPosition, replacement.toString());
    }

    private static void replaceUseWithMethodReference(SuggestedFix.Builder fix, ExpressionTree node, String newName, VisitorState state) {
        MemberSelectTree memberSelectTree;
        Tree parent = state.getPath().getParentPath().getLeaf();
        if (parent instanceof MemberSelectTree && (memberSelectTree = (MemberSelectTree)parent).getExpression().equals(node)) {
            ExpressionTree receiver = node instanceof IdentifierTree ? null : ASTHelpers.getReceiver((ExpressionTree)node);
            fix.replace(receiver != null ? state.getEndPosition((Tree)receiver) : ASTHelpers.getStartPosition((Tree)node), state.getEndPosition(parent), (receiver != null ? "." : "") + newName);
        } else {
            Symbol sym = ASTHelpers.getSymbol((Tree)node);
            String receiverCode = node instanceof MethodInvocationTree && ASTHelpers.getReceiver((ExpressionTree)node) != null ? state.getSourceForNode((Tree)ASTHelpers.getReceiver((ExpressionTree)node)) : (ASTHelpers.isStatic((Symbol)sym) ? ASTHelpers.enclosingClass((Symbol)sym).getSimpleName().toString() : "this");
            fix.replace((Tree)node, String.format("%s::%s", receiverCode, newName));
        }
    }
}

