/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.SourceCodeEscapers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.util.List;
import java.util.regex.Pattern;

@BugPattern(summary="There is no need to use String.format() when all the arguments are literals.", severity=BugPattern.SeverityLevel.WARNING)
public final class StringFormatWithLiteral
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> STRING_FORMAT_METHOD_MATCHER = Matchers.staticMethod().onClass("java.lang.String").named("format");
    private static final Matcher<ExpressionTree> FORMATTED = Matchers.instanceMethod().onExactClass("java.lang.String").named("formatted");
    private static final Pattern SPECIFIER_ALLOW_LIST_REGEX = Pattern.compile("%(d|s|S|c|b|B)");

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (STRING_FORMAT_METHOD_MATCHER.matches((Tree)tree, state)) {
            ImmutableList arguments = (ImmutableList)tree.getArguments().stream().skip(1L).collect(ImmutableList.toImmutableList());
            if (StringFormatWithLiteral.shouldRefactorStringFormat(tree.getArguments().get(0), (List<? extends ExpressionTree>)arguments)) {
                return this.describeMatch(tree, (Fix)SuggestedFix.replace((Tree)tree, (String)StringFormatWithLiteral.getFormattedUnifiedString(tree.getArguments().get(0), (List<? extends ExpressionTree>)arguments)));
            }
        }
        if (FORMATTED.matches((Tree)tree, state) && StringFormatWithLiteral.shouldRefactorStringFormat(ASTHelpers.getReceiver((ExpressionTree)tree), tree.getArguments())) {
            return this.describeMatch(tree, (Fix)SuggestedFix.replace((Tree)tree, (String)StringFormatWithLiteral.getFormattedUnifiedString(ASTHelpers.getReceiver((ExpressionTree)tree), tree.getArguments())));
        }
        return Description.NO_MATCH;
    }

    private static boolean shouldRefactorStringFormat(ExpressionTree formatString, List<? extends ExpressionTree> arguments) {
        LiteralTree literalTree;
        block3: {
            block2: {
                if (!(formatString instanceof LiteralTree)) break block2;
                literalTree = (LiteralTree)formatString;
                if (arguments.stream().allMatch(argumentTree -> argumentTree instanceof LiteralTree)) break block3;
            }
            return false;
        }
        return StringFormatWithLiteral.onlyContainsSpecifiersInAllowList((String)literalTree.getValue());
    }

    private static boolean onlyContainsSpecifiersInAllowList(String formatString) {
        String noSpecifierFormatBase = SPECIFIER_ALLOW_LIST_REGEX.matcher(formatString).replaceAll("");
        return !noSpecifierFormatBase.contains("%");
    }

    private static String getFormattedUnifiedString(ExpressionTree formatString, List<? extends ExpressionTree> arguments) {
        String unescapedFormatString = String.format((String)((LiteralTree)formatString).getValue(), arguments.stream().map(literalTree -> ((LiteralTree)literalTree).getValue()).toArray(Object[]::new));
        return "\"" + SourceCodeEscapers.javaCharEscaper().escape(unescapedFormatString) + "\"";
    }
}

