/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.common.escape.CharEscaper;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.ErrorProneTokens;
import com.google.errorprone.util.SourceCodeEscapers;
import com.google.errorprone.util.SourceVersion;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LineMap;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.util.Context;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@BugPattern(summary="This string literal can be written more clearly as a text block", severity=BugPattern.SeverityLevel.WARNING)
public class StringConcatToTextBlock
extends BugChecker
implements BugChecker.LiteralTreeMatcher,
BugChecker.MethodInvocationTreeMatcher {
    public static final String DELIMITER = "\"\"\"";
    private static final Matcher<ExpressionTree> JOINER_JOIN = MethodMatchers.instanceMethod().onExactClass("com.google.common.base.Joiner").named("join");
    private static final Matcher<ExpressionTree> JOINER_ON = MethodMatchers.staticMethod().onClass("com.google.common.base.Joiner").named("on");
    private static final Matcher<ExpressionTree> STRING_JOINER_TO_STRING = MethodMatchers.instanceMethod().onExactClass("java.util.StringJoiner").named("toString");
    private static final Matcher<ExpressionTree> STRING_JOINER_ADD = MethodMatchers.instanceMethod().onExactClass("java.util.StringJoiner").named("add");
    private static final Matcher<ExpressionTree> STRING_JOINER_CONSTRUCTOR = MethodMatchers.constructor().forClass("java.util.StringJoiner").withParameters("java.lang.CharSequence", new String[0]);
    private static final Matcher<ExpressionTree> STRING_JOIN = MethodMatchers.staticMethod().onClass("java.lang.String").named("join");
    private static final Matcher<ExpressionTree> FOR_SOURCE_LINES = MethodMatchers.staticMethod().onClass("com.google.testing.compile.JavaFileObjects").named("forSourceLines");
    private static final CharMatcher SPACE = CharMatcher.is((char)' ');

    public Description matchLiteral(LiteralTree tree, VisitorState state) {
        int thresholdToMigrate;
        BinaryTree parent;
        if (!SourceVersion.supportsTextBlocks((Context)state.context)) {
            return Description.NO_MATCH;
        }
        if (!tree.getKind().equals((Object)Tree.Kind.STRING_LITERAL)) {
            return Description.NO_MATCH;
        }
        Tree tree2 = state.getPath().getParentPath().getLeaf();
        if (tree2 instanceof BinaryTree && (parent = (BinaryTree)tree2).getKind().equals((Object)Tree.Kind.PLUS) && ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)parent), (Type)state.getSymtab().stringType, (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        if (!ASTHelpers.hasExplicitSource((Tree)tree, (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        ImmutableList tokens = state.getTokensForNode((Tree)tree);
        ImmutableList strings = (ImmutableList)tokens.stream().filter(t -> t.kind().equals(Tokens.TokenKind.STRINGLITERAL)).map(t -> t.stringVal()).collect(ImmutableList.toImmutableList());
        boolean trailingNewline = ((String)Iterables.getLast((Iterable)strings)).endsWith("\n");
        int n = thresholdToMigrate = trailingNewline ? 2 : 3;
        if (strings.size() < thresholdToMigrate) {
            return Description.NO_MATCH;
        }
        if (!strings.stream().limit(strings.size() - 1).allMatch(s -> s.endsWith("\n"))) {
            return Description.NO_MATCH;
        }
        strings = (ImmutableList)Streams.concat((Stream[])new Stream[]{strings.stream().limit(strings.size() - 1).map(s -> s.substring(0, s.length() - 1)), Stream.of((String)Iterables.getLast((Iterable)strings))}).collect(ImmutableList.toImmutableList());
        return this.match(tree, (ImmutableList<String>)strings, state);
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!SourceVersion.supportsTextBlocks((Context)state.context)) {
            return Description.NO_MATCH;
        }
        if (JOINER_JOIN.matches((Tree)tree, state)) {
            return this.joiner(tree, state);
        }
        if (STRING_JOINER_TO_STRING.matches((Tree)tree, state)) {
            return this.stringJoiner(tree, state);
        }
        if (STRING_JOIN.matches((Tree)tree, state)) {
            return this.stringJoin(tree, state);
        }
        if (FOR_SOURCE_LINES.matches((Tree)tree, state)) {
            return this.forSourceLines(tree, state);
        }
        return Description.NO_MATCH;
    }

    private Description match(Tree replace, ImmutableList<String> lines, VisitorState state) {
        return this.match(replace, ASTHelpers.getStartPosition((Tree)replace), state.getEndPosition(replace), lines, state);
    }

    private Description match(Tree tree, int replaceFrom, int replaceTo, ImmutableList<String> strings, VisitorState state) {
        if (strings.isEmpty()) {
            return Description.NO_MATCH;
        }
        ImmutableList tokens = ErrorProneTokens.getTokens((String)state.getSourceCode().subSequence(replaceFrom, replaceTo).toString(), (Context)state.context);
        if (!tokens.stream().flatMap(t -> t.comments().stream()).map(c -> c.getText()).allMatch(x -> x.isEmpty())) {
            return Description.NO_MATCH;
        }
        if (strings.stream().anyMatch(s -> s.contains(DELIMITER))) {
            return Description.NO_MATCH;
        }
        boolean trailingNewline = ((String)Iterables.getLast(strings)).endsWith("\n");
        String joined = String.join((CharSequence)"\n", strings);
        ImmutableList outdentedStrings = (ImmutableList)Streams.zip(joined.stripIndent().lines(), joined.lines(), (s, orig) -> s + " ".repeat(orig.length() - SPACE.trimTrailingFrom((CharSequence)orig).length())).collect(ImmutableList.toImmutableList());
        LineMap lineMap = state.getPath().getCompilationUnit().getLineMap();
        if (lineMap == null) {
            return Description.NO_MATCH;
        }
        String indent = " ".repeat((int)lineMap.getColumnNumber(replaceFrom) - 1);
        String suffix = trailingNewline ? "" : "\\";
        String replacement = outdentedStrings.stream().map(line -> line.isEmpty() ? line : indent + line).map(arg_0 -> ((CharEscaper)SourceCodeEscapers.getJavaTextBlockEscaper()).escape(arg_0)).map(s -> s.endsWith(" ") ? s.substring(0, s.length() - 1) + "\\s" : s).collect(Collectors.joining("\n", "\"\"\"\n", suffix + "\n" + indent + DELIMITER));
        if (state.getSourceCode().subSequence(replaceFrom, replaceTo).toString().equals(replacement)) {
            return Description.NO_MATCH;
        }
        SuggestedFix fix = SuggestedFix.replace((int)replaceFrom, (int)replaceTo, (String)replacement);
        return this.describeMatch(tree, (Fix)fix);
    }

    private Description joiner(MethodInvocationTree tree, VisitorState state) {
        ImmutableList<String> strings = StringConcatToTextBlock.stringLiteralArguments(tree.getArguments());
        if (strings.isEmpty()) {
            return Description.NO_MATCH;
        }
        ExpressionTree expressionTree = ASTHelpers.getReceiver((ExpressionTree)tree);
        if (!(expressionTree instanceof MethodInvocationTree)) {
            return Description.NO_MATCH;
        }
        MethodInvocationTree receiver = (MethodInvocationTree)expressionTree;
        if (!JOINER_ON.matches((Tree)receiver, state)) {
            return Description.NO_MATCH;
        }
        if (!StringConcatToTextBlock.newlineLiteral((ExpressionTree)Iterables.getOnlyElement(receiver.getArguments()))) {
            return Description.NO_MATCH;
        }
        return this.match(tree, strings, state);
    }

    private Description stringJoiner(MethodInvocationTree tree, VisitorState state) {
        NewClassTree constructor;
        MethodInvocationTree receiver;
        ExpressionTree expressionTree;
        ArrayDeque<String> strings = new ArrayDeque<String>();
        MethodInvocationTree current = tree;
        while ((expressionTree = ASTHelpers.getReceiver((ExpressionTree)current)) instanceof MethodInvocationTree && STRING_JOINER_ADD.matches((Tree)(receiver = (MethodInvocationTree)expressionTree), state)) {
            Optional<String> string = StringConcatToTextBlock.stringLiteral((ExpressionTree)Iterables.getOnlyElement(receiver.getArguments()));
            if (string.isEmpty()) {
                return Description.NO_MATCH;
            }
            strings.addFirst(string.get());
            current = receiver;
        }
        expressionTree = ASTHelpers.getReceiver((ExpressionTree)current);
        if (!(expressionTree instanceof NewClassTree) || !STRING_JOINER_CONSTRUCTOR.matches((Tree)(constructor = (NewClassTree)expressionTree), state)) {
            return Description.NO_MATCH;
        }
        if (!StringConcatToTextBlock.newlineLiteral((ExpressionTree)Iterables.getOnlyElement(constructor.getArguments()))) {
            return Description.NO_MATCH;
        }
        return this.match(tree, (ImmutableList<String>)ImmutableList.copyOf(strings), state);
    }

    private Description stringJoin(MethodInvocationTree tree, VisitorState state) {
        ImmutableList<String> strings = StringConcatToTextBlock.stringLiteralArguments(tree.getArguments().subList(1, tree.getArguments().size()));
        if (!StringConcatToTextBlock.newlineLiteral(tree.getArguments().get(0))) {
            return Description.NO_MATCH;
        }
        return this.match(tree, strings, state);
    }

    private Description forSourceLines(MethodInvocationTree tree, VisitorState state) {
        ImmutableList<String> strings = StringConcatToTextBlock.stringLiteralArguments(tree.getArguments().subList(1, tree.getArguments().size()));
        return this.match(tree.getArguments().get(1), ASTHelpers.getStartPosition((Tree)tree.getArguments().get(1)), state.getEndPosition((Tree)Iterables.getLast(tree.getArguments())), strings, state);
    }

    private static boolean newlineLiteral(ExpressionTree expressionTree) {
        Object value = ASTHelpers.constValue((Tree)expressionTree);
        if (value == null) {
            return false;
        }
        return value.equals("\n") || value.equals(Character.valueOf('\n'));
    }

    static ImmutableList<String> stringLiteralArguments(List<? extends ExpressionTree> arguments) {
        ImmutableList strings = (ImmutableList)arguments.stream().filter(a -> a.getKind().equals((Object)Tree.Kind.STRING_LITERAL)).map(x -> (String)((LiteralTree)x).getValue()).collect(ImmutableList.toImmutableList());
        if (strings.size() != arguments.size()) {
            return ImmutableList.of();
        }
        return strings;
    }

    static Optional<String> stringLiteral(ExpressionTree tree) {
        return tree.getKind().equals((Object)Tree.Kind.STRING_LITERAL) ? Optional.of((String)((LiteralTree)tree).getValue()) : Optional.empty();
    }
}

