/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.threadsafety.ConstantExpressions;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Name;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@BugPattern(summary="This assertion will always fail or succeed.", altNames={"TruthSelfEquals"}, severity=BugPattern.SeverityLevel.ERROR)
public final class SelfAssertion
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private final Matcher<MethodInvocationTree> equalsMatcher = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.allOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().anyClass().namedAnyOf(new String[]{"isEqualTo", "isSameInstanceAs", "containsExactlyElementsIn", "containsAtLeastElementsIn", "areEqualTo"}), this::truthSameArguments}), Matchers.allOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onClassAny(new String[]{"org.junit.Assert", "junit.framework.Assert", "junit.framework.TestCase"}).namedAnyOf(new String[]{"assertEquals", "assertArrayEquals"}), this::junitSameArguments})});
    private final Matcher<MethodInvocationTree> notEqualsMatcher = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.allOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().anyClass().namedAnyOf(new String[]{"isNotEqualTo", "isNotSameInstanceAs"}), this::truthSameArguments}), Matchers.allOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onClassAny(new String[]{"org.junit.Assert", "junit.framework.Assert", "junit.framework.TestCase"}).namedAnyOf(new String[]{"assertNotEquals"}), this::junitSameArguments})});
    private static final Matcher<ExpressionTree> ASSERT_THAT = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().anyClass().named("assertThat"), MethodMatchers.instanceMethod().onDescendantOf("com.google.common.truth.TestVerb").named("that"), MethodMatchers.instanceMethod().onDescendantOf("com.google.common.truth.StandardSubjectBuilder").named("that")});
    private final ConstantExpressions constantExpressions;

    @Inject
    SelfAssertion(ConstantExpressions constantExpressions) {
        this.constantExpressions = constantExpressions;
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (tree.getArguments().isEmpty()) {
            return Description.NO_MATCH;
        }
        if (this.equalsMatcher.matches((Tree)tree, state)) {
            return this.buildDescription(tree).setMessage(SelfAssertion.generateSummary(((Name)ASTHelpers.getSymbol((MethodInvocationTree)tree).getSimpleName()).toString(), "passes")).build();
        }
        if (this.notEqualsMatcher.matches((Tree)tree, state)) {
            return this.buildDescription(tree).setMessage(SelfAssertion.generateSummary(((Name)ASTHelpers.getSymbol((MethodInvocationTree)tree).getSimpleName()).toString(), "fails")).build();
        }
        return Description.NO_MATCH;
    }

    private static String generateSummary(String methodName, String constantOutput) {
        return String.format("You are passing identical arguments to the %s method, so this assertion always %s. THIS IS LIKELY A BUG! If you are trying to test the correctness of an equals() implementation, use EqualsTester instead.", methodName, constantOutput);
    }

    private boolean junitSameArguments(MethodInvocationTree tree, VisitorState state) {
        ExpressionTree actual;
        ExpressionTree expected;
        List<? extends ExpressionTree> arguments = tree.getArguments();
        if (arguments.isEmpty()) {
            return false;
        }
        ExpressionTree firstArgument = tree.getArguments().get(0);
        if (tree.getArguments().size() > 2 && ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)firstArgument), (Type)state.getSymtab().stringType, (VisitorState)state)) {
            expected = arguments.get(1);
            actual = arguments.get(2);
        } else {
            expected = arguments.get(0);
            actual = arguments.get(1);
        }
        return this.sameExpression(state, expected, actual);
    }

    private boolean truthSameArguments(MethodInvocationTree tree, VisitorState state) {
        ExpressionTree rec = ASTHelpers.getReceiver((ExpressionTree)tree);
        if (rec == null) {
            return false;
        }
        if (!ASSERT_THAT.matches((Tree)rec, state)) {
            return false;
        }
        if (((MethodInvocationTree)rec).getArguments().size() != 1 || tree.getArguments().size() != 1) {
            return false;
        }
        ExpressionTree receiverExpression = (ExpressionTree)Iterables.getOnlyElement(((MethodInvocationTree)rec).getArguments());
        ExpressionTree invocationExpression = (ExpressionTree)Iterables.getOnlyElement(tree.getArguments());
        return this.sameExpression(state, receiverExpression, invocationExpression);
    }

    private boolean sameExpression(VisitorState state, ExpressionTree receiverExpression, ExpressionTree invocationExpression) {
        if (ASTHelpers.sameVariable((ExpressionTree)receiverExpression, (ExpressionTree)invocationExpression)) {
            return true;
        }
        Optional<ConstantExpressions.ConstantExpression> receiverConstant = this.constantExpressions.constantExpression(receiverExpression, state);
        Optional<ConstantExpressions.ConstantExpression> invocationConstant = this.constantExpressions.constantExpression(invocationExpression, state);
        return receiverConstant.isPresent() && receiverConstant.equals(invocationConstant);
    }
}

