/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.MoreObjects;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

@BugPattern(summary="Non-abstract instance methods named 'self()' or 'getThis()' that return the enclosing class must always 'return this'", severity=BugPattern.SeverityLevel.WARNING)
public final class SelfAlwaysReturnsThis
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    public Description matchMethod(MethodTree methodTree, VisitorState state) {
        Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol((MethodTree)methodTree);
        if (methodSymbol.isConstructor() || !((Name)methodSymbol.getSimpleName()).contentEquals("self") && !((Name)methodSymbol.getSimpleName()).contentEquals("getThis") || !((List)methodSymbol.getParameters()).isEmpty() || methodSymbol.isStatic() || methodTree.getBody() == null) {
            return Description.NO_MATCH;
        }
        Tree returnType = methodTree.getReturnType();
        if (ASTHelpers.isVoidType((Type)ASTHelpers.getType((Tree)returnType), (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        if (!ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)returnType), (Type)ASTHelpers.enclosingClass((Symbol)methodSymbol).type, (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        final AtomicBoolean allReturnThis = new AtomicBoolean(true);
        final AtomicBoolean atLeastOneReturn = new AtomicBoolean(false);
        new TreePathScanner<Void, Void>(this){
            private final Set<Symbol.VarSymbol> thises = new HashSet<Symbol.VarSymbol>();
            final /* synthetic */ SelfAlwaysReturnsThis this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Void visitVariable(VariableTree variableTree, Void unused) {
                Symbol.VarSymbol symbol = ASTHelpers.getSymbol((VariableTree)variableTree);
                if (ASTHelpers.isConsideredFinal((Symbol)symbol) && SelfAlwaysReturnsThis.maybeCastThis(variableTree.getInitializer())) {
                    this.thises.add(symbol);
                }
                return (Void)super.visitVariable(variableTree, null);
            }

            @Override
            public Void visitReturn(ReturnTree returnTree, Void unused) {
                atLeastOneReturn.set(true);
                if (!this.isThis(returnTree.getExpression())) {
                    allReturnThis.set(false);
                    return null;
                }
                return (Void)super.visitReturn(returnTree, null);
            }

            private boolean isThis(ExpressionTree returnExpression) {
                return SelfAlwaysReturnsThis.maybeCastThis(returnExpression) || this.thises.contains(ASTHelpers.getSymbol((Tree)returnExpression));
            }

            @Override
            public Void visitLambdaExpression(LambdaExpressionTree node, Void unused) {
                return null;
            }

            @Override
            public Void visitNewClass(NewClassTree node, Void unused) {
                return null;
            }
        }.scan(state.getPath(), (Void)null);
        if (atLeastOneReturn.get() && allReturnThis.get()) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(methodTree, (Fix)SuggestedFix.replace((Tree)methodTree.getBody(), (String)"{ return this; }"));
    }

    private static boolean maybeCastThis(Tree tree) {
        return (Boolean)MoreObjects.firstNonNull((Object)((Boolean)new SimpleTreeVisitor<Boolean, Void>(){

            @Override
            public Boolean visitParenthesized(ParenthesizedTree tree, Void unused) {
                return (Boolean)this.visit(tree.getExpression(), null);
            }

            @Override
            public Boolean visitTypeCast(TypeCastTree tree, Void unused) {
                return (Boolean)this.visit(tree.getExpression(), null);
            }

            @Override
            public Boolean visitIdentifier(IdentifierTree tree, Void unused) {
                return tree.getName().contentEquals("this");
            }
        }.visit(tree, null)), (Object)false);
    }
}

