/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import javax.lang.model.element.Modifier;

@BugPattern(summary="Classes which are not intended to be instantiated should be made non-instantiable with a private constructor. This includes utility classes (classes with only static members), and the main class.", severity=BugPattern.SeverityLevel.SUGGESTION)
public final class PrivateConstructorForUtilityClass
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final ImmutableSet<String> ANNOTATIONS_TO_IGNORE = ImmutableSet.of((Object)"org.junit.runner.RunWith", (Object)"org.robolectric.annotation.Implements", (Object)"com.google.auto.value.AutoValue");

    public Description matchClass(ClassTree classTree, VisitorState state) {
        if (!classTree.getKind().equals((Object)Tree.Kind.CLASS) || classTree.getModifiers().getFlags().contains((Object)Modifier.ABSTRACT) || classTree.getExtendsClause() != null || !classTree.getImplementsClause().isEmpty() || PrivateConstructorForUtilityClass.isInPrivateScope(state)) {
            return Description.NO_MATCH;
        }
        Symbol.ClassSymbol sym = ASTHelpers.getSymbol((ClassTree)classTree);
        for (String annotation : ANNOTATIONS_TO_IGNORE) {
            if (!ASTHelpers.hasAnnotation((Symbol)sym, (String)annotation, (VisitorState)state)) continue;
            return Description.NO_MATCH;
        }
        ImmutableList nonSyntheticMembers = (ImmutableList)classTree.getMembers().stream().filter(tree -> {
            MethodTree methodTree;
            return !(tree instanceof MethodTree && ASTHelpers.isGeneratedConstructor((MethodTree)(methodTree = (MethodTree)tree)));
        }).collect(ImmutableList.toImmutableList());
        if (nonSyntheticMembers.isEmpty() || nonSyntheticMembers.stream().anyMatch(PrivateConstructorForUtilityClass::isInstance)) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fix = SuggestedFixes.addMembers((ClassTree)classTree, (VisitorState)state, (String)ASTHelpers.createPrivateConstructor((ClassTree)classTree), (String[])new String[0]).toBuilder();
        SuggestedFixes.addModifiers((Tree)classTree, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.FINAL}).ifPresent(arg_0 -> ((SuggestedFix.Builder)fix).merge(arg_0));
        return this.describeMatch(classTree, (Fix)fix.build());
    }

    private static boolean isInPrivateScope(VisitorState state) {
        return Streams.stream((Iterable)state.getPath()).anyMatch(currentLeaf -> {
            ClassTree classTree;
            return currentLeaf instanceof ClassTree && (classTree = (ClassTree)currentLeaf).getModifiers().getFlags().contains((Object)Modifier.PRIVATE);
        });
    }

    private static boolean isInstance(Tree tree) {
        return switch (tree.getKind()) {
            case Tree.Kind.CLASS -> {
                if (!((ClassTree)tree).getModifiers().getFlags().contains((Object)Modifier.STATIC)) {
                    yield true;
                }
                yield false;
            }
            case Tree.Kind.METHOD -> {
                if (!((MethodTree)tree).getModifiers().getFlags().contains((Object)Modifier.STATIC)) {
                    yield true;
                }
                yield false;
            }
            case Tree.Kind.VARIABLE -> {
                if (!((VariableTree)tree).getModifiers().getFlags().contains((Object)Modifier.STATIC)) {
                    yield true;
                }
                yield false;
            }
            case Tree.Kind.BLOCK -> {
                if (!((BlockTree)tree).isStatic()) {
                    yield true;
                }
                yield false;
            }
            case Tree.Kind.ENUM, Tree.Kind.ANNOTATION_TYPE, Tree.Kind.INTERFACE, Tree.Kind.RECORD -> false;
            default -> throw new AssertionError((Object)("unknown member type:" + String.valueOf((Object)tree.getKind())));
        };
    }
}

