/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Name;
import java.io.Serializable;
import java.util.Set;
import java.util.stream.Stream;
import javax.inject.Inject;

@BugPattern(summary="Do not extend an @AutoValue-like classes in non-generated code.", severity=BugPattern.SeverityLevel.ERROR)
public final class ExtendsAutoValue
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final Supplier<ImmutableSet<Name>> AUTOS = VisitorState.memoize((Supplier & Serializable)s -> ImmutableSet.of((Object)s.getName("com.google.auto.value.AutoOneOf"), (Object)s.getName("com.google.auto.value.AutoValue")));
    private static final Supplier<ImmutableSet<Name>> AUTOS_AND_BUILDERS = VisitorState.memoize((Supplier & Serializable)s -> ImmutableSet.of((Object)s.getName("com.google.auto.value.AutoBuilder"), (Object)s.getName("com.google.auto.value.AutoOneOf"), (Object)s.getName("com.google.auto.value.AutoValue"), (Object)s.getName("com.google.auto.value.AutoValue$Builder")));
    private final boolean testBuilders;
    private final Supplier<ImmutableSet<Name>> autos;

    @Inject
    ExtendsAutoValue(ErrorProneFlags flags) {
        this.testBuilders = flags.getBoolean("ExtendsAutoValue:builders").orElse(true);
        this.autos = this.testBuilders ? AUTOS_AND_BUILDERS : AUTOS;
    }

    public Description matchClass(ClassTree tree, VisitorState state) {
        if (tree.getExtendsClause() == null && (!this.testBuilders || tree.getImplementsClause().isEmpty())) {
            return Description.NO_MATCH;
        }
        Stream<Tree> parents = Stream.concat(Stream.ofNullable(tree.getExtendsClause()), this.testBuilders ? tree.getImplementsClause().stream() : Stream.empty());
        return parents.map(parent -> ASTHelpers.annotationsAmong((Symbol)ASTHelpers.getSymbol((Tree)parent), (Set)((Set)this.autos.get(state)), (VisitorState)state)).filter(annotations -> !annotations.isEmpty()).findFirst().filter(unused -> !ExtendsAutoValue.isInGeneratedCode(state)).map(annotations -> {
            String name = ((Name)annotations.iterator().next()).toString();
            name = name.substring(name.lastIndexOf(46) + 1);
            name = name.replace('$', '.');
            return this.buildDescription(tree).setMessage(String.format("Do not extend an @%s class in non-generated code.", name)).build();
        }).orElse(Description.NO_MATCH);
    }

    private static boolean isInGeneratedCode(VisitorState state) {
        return !ASTHelpers.getGeneratedBy((VisitorState)state).isEmpty();
    }
}

