/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.WellKnownKeep;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Types;
import java.util.Collections;
import java.util.Optional;
import javax.inject.Inject;
import javax.lang.model.element.Modifier;

@BugPattern(summary="This declaration has public or protected modifiers, but is effectively private.", severity=BugPattern.SeverityLevel.WARNING)
public final class EffectivelyPrivate
extends BugChecker
implements BugChecker.MethodTreeMatcher,
BugChecker.VariableTreeMatcher,
BugChecker.ClassTreeMatcher {
    private final WellKnownKeep wellKnownKeep;
    private static final ImmutableSet<Modifier> MODIFIER_TO_REMOVE = ImmutableSet.of((Object)((Object)Modifier.PUBLIC), (Object)((Object)Modifier.PROTECTED));

    @Inject
    EffectivelyPrivate(WellKnownKeep wellKnownKeep) {
        this.wellKnownKeep = wellKnownKeep;
    }

    public Description matchVariable(VariableTree tree, VisitorState state) {
        Symbol.VarSymbol sym = ASTHelpers.getSymbol((VariableTree)tree);
        if (!sym.getKind().isField()) {
            return Description.NO_MATCH;
        }
        return this.match(tree, tree.getModifiers(), state);
    }

    public Description matchClass(ClassTree tree, VisitorState state) {
        return this.match(tree, tree.getModifiers(), state);
    }

    public Description matchMethod(MethodTree tree, VisitorState state) {
        return this.match(tree, tree.getModifiers(), state);
    }

    private Description match(Tree tree, ModifiersTree modifiers, VisitorState state) {
        Symbol sym = ASTHelpers.getSymbol((Tree)tree);
        if (!ASTHelpers.isEffectivelyPrivate((Symbol)sym)) {
            return Description.NO_MATCH;
        }
        if (this.wellKnownKeep.shouldKeep(tree)) {
            return Description.NO_MATCH;
        }
        if (sym instanceof Symbol.MethodSymbol) {
            Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)sym;
            if (ASTHelpers.hasAnnotation((Symbol)methodSymbol, (String)"java.lang.Override", (VisitorState)state)) {
                return Description.NO_MATCH;
            }
            if (ASTHelpers.streamSuperMethods((Symbol.MethodSymbol)methodSymbol, (Types)state.getTypes()).findAny().isPresent()) {
                return Description.NO_MATCH;
            }
        }
        if (Collections.disjoint(modifiers.getFlags(), MODIFIER_TO_REMOVE)) {
            return Description.NO_MATCH;
        }
        Optional fix = SuggestedFixes.removeModifiers((ModifiersTree)modifiers, (VisitorState)state, MODIFIER_TO_REMOVE);
        if (fix.isEmpty()) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree, (Fix)fix.get());
    }
}

