/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.MethodVisibility;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TreeVisitor;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import java.util.EnumSet;

@BugPattern(summary="This comparison method violates the contract", severity=BugPattern.SeverityLevel.ERROR)
public class ComparisonContractViolated
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final Matcher<ClassTree> COMPARABLE_CLASS_MATCHER = Matchers.isSubtypeOf((String)"java.lang.Comparable");
    private static final Matcher<MethodTree> COMPARATOR_METHOD_MATCHER = Matchers.allOf((Matcher[])new Matcher[]{Matchers.methodIsNamed((String)"compare"), Matchers.methodHasVisibility((MethodVisibility.Visibility)MethodVisibility.Visibility.PUBLIC), Matchers.methodReturns((Supplier)Suppliers.INT_TYPE), Matchers.methodHasArity((int)2)});
    private static final Matcher<ClassTree> COMPARATOR_CLASS_MATCHER = Matchers.isSubtypeOf((String)"java.util.Comparator");
    private static final TreeVisitor<ComparisonResult, VisitorState> CONSTANT_VISITOR = new SimpleTreeVisitor<ComparisonResult, VisitorState>(ComparisonResult.NONCONSTANT){

        private ComparisonResult forInt(int x) {
            if (x < 0) {
                return ComparisonResult.NEGATIVE_CONSTANT;
            }
            if (x > 0) {
                return ComparisonResult.POSITIVE_CONSTANT;
            }
            return ComparisonResult.ZERO;
        }

        @Override
        public ComparisonResult visitMemberSelect(MemberSelectTree node, VisitorState state) {
            Symbol.VarSymbol varSymbol;
            Object value;
            Symbol sym = ASTHelpers.getSymbol((Tree)node);
            if (sym instanceof Symbol.VarSymbol && (value = (varSymbol = (Symbol.VarSymbol)sym).getConstantValue()) instanceof Integer) {
                Integer integer = (Integer)value;
                return this.forInt(integer);
            }
            return (ComparisonResult)((Object)super.visitMemberSelect(node, state));
        }

        @Override
        public ComparisonResult visitIdentifier(IdentifierTree node, VisitorState state) {
            Symbol.VarSymbol varSymbol;
            Object value;
            Symbol sym = ASTHelpers.getSymbol((Tree)node);
            if (sym instanceof Symbol.VarSymbol && (value = (varSymbol = (Symbol.VarSymbol)sym).getConstantValue()) instanceof Integer) {
                Integer integer = (Integer)value;
                return this.forInt(integer);
            }
            return (ComparisonResult)((Object)super.visitIdentifier(node, state));
        }

        @Override
        public ComparisonResult visitLiteral(LiteralTree node, VisitorState state) {
            Object object = node.getValue();
            if (object instanceof Integer) {
                Integer i = (Integer)object;
                return this.forInt(i);
            }
            return (ComparisonResult)((Object)super.visitLiteral(node, state));
        }
    };

    public Description matchMethod(MethodTree tree, VisitorState state) {
        if (tree.getBody() == null) {
            return Description.NO_MATCH;
        }
        ClassTree declaringClass = (ClassTree)ASTHelpers.findEnclosingNode((TreePath)state.getPath(), ClassTree.class);
        if (!COMPARABLE_CLASS_MATCHER.matches((Tree)declaringClass, state) && !COMPARATOR_CLASS_MATCHER.matches((Tree)declaringClass, state)) {
            return Description.NO_MATCH;
        }
        if (!Matchers.compareToMethodDeclaration().matches((Tree)tree, state) && !COMPARATOR_METHOD_MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        final EnumSet<ComparisonResult> seenResults = EnumSet.noneOf(ComparisonResult.class);
        final SimpleTreeVisitor<Void, VisitorState> visitReturnExpression = new SimpleTreeVisitor<Void, VisitorState>(this){
            final /* synthetic */ ComparisonContractViolated this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            protected Void defaultAction(Tree node, VisitorState state) {
                seenResults.add(node.accept(CONSTANT_VISITOR, state));
                return null;
            }

            @Override
            public Void visitConditionalExpression(ConditionalExpressionTree node, VisitorState state) {
                node.getTrueExpression().accept(this, state);
                node.getFalseExpression().accept(this, state);
                return null;
            }
        };
        tree.getBody().accept(new TreeScanner<Void, VisitorState>(this){
            final /* synthetic */ ComparisonContractViolated this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Void visitReturn(ReturnTree node, VisitorState state) {
                return (Void)node.getExpression().accept(visitReturnExpression, state);
            }
        }, state);
        if (seenResults.isEmpty() || seenResults.contains((Object)ComparisonResult.NONCONSTANT)) {
            return Description.NO_MATCH;
        }
        if (!seenResults.contains((Object)ComparisonResult.ZERO)) {
            ReturnTree returnTree;
            Tree tree2;
            if (tree.getBody().getStatements().size() == 1 && (tree2 = tree.getBody().getStatements().get(0)) instanceof ReturnTree && (tree2 = (returnTree = (ReturnTree)tree2).getExpression()) instanceof ConditionalExpressionTree) {
                String compareType;
                ExpressionTree second;
                boolean trueFirst;
                ConditionalExpressionTree condTree = (ConditionalExpressionTree)tree2;
                ExpressionTree conditionExpr = condTree.getCondition();
                if (!((conditionExpr = ASTHelpers.stripParentheses((ExpressionTree)conditionExpr)) instanceof BinaryTree)) {
                    return this.describeMatch(tree);
                }
                BinaryTree binaryExpr = (BinaryTree)conditionExpr;
                ComparisonResult trueConst = condTree.getTrueExpression().accept(CONSTANT_VISITOR, state);
                ComparisonResult falseConst = condTree.getFalseExpression().accept(CONSTANT_VISITOR, state);
                if (trueConst == ComparisonResult.NEGATIVE_CONSTANT && falseConst == ComparisonResult.POSITIVE_CONSTANT) {
                    trueFirst = true;
                } else if (trueConst == ComparisonResult.POSITIVE_CONSTANT && falseConst == ComparisonResult.NEGATIVE_CONSTANT) {
                    trueFirst = false;
                } else {
                    return this.describeMatch(tree);
                }
                switch (conditionExpr.getKind()) {
                    case LESS_THAN: 
                    case LESS_THAN_EQUAL: {
                        break;
                    }
                    case GREATER_THAN: 
                    case GREATER_THAN_EQUAL: {
                        trueFirst = !trueFirst;
                        break;
                    }
                    default: {
                        return this.describeMatch(tree);
                    }
                }
                Type ty = ASTHelpers.getType((Tree)binaryExpr.getLeftOperand());
                Types types = state.getTypes();
                Symtab symtab = state.getSymtab();
                ExpressionTree first = trueFirst ? binaryExpr.getLeftOperand() : binaryExpr.getRightOperand();
                ExpressionTree expressionTree = second = trueFirst ? binaryExpr.getRightOperand() : binaryExpr.getLeftOperand();
                if (types.isSameType(ty, symtab.intType)) {
                    compareType = "Integer";
                } else if (types.isSameType(ty, symtab.longType)) {
                    compareType = "Long";
                } else {
                    return this.describeMatch(tree);
                }
                return this.describeMatch(condTree, (Fix)SuggestedFix.replace((Tree)condTree, (String)String.format("%s.compare(%s, %s)", compareType, state.getSourceForNode((Tree)first), state.getSourceForNode((Tree)second))));
            }
            return this.describeMatch(tree);
        }
        if (COMPARATOR_METHOD_MATCHER.matches((Tree)tree, state) && seenResults.contains((Object)ComparisonResult.NEGATIVE_CONSTANT) != seenResults.contains((Object)ComparisonResult.POSITIVE_CONSTANT)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }

    private static enum ComparisonResult {
        NEGATIVE_CONSTANT,
        ZERO,
        POSITIVE_CONSTANT,
        NONCONSTANT;

    }
}

