/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.VisitorState;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Names;
import java.util.HashSet;
import java.util.Set;

public class CanBeStaticAnalyzer
extends TreeScanner {
    private final Names names;
    private final Symbol owner;
    private final VisitorState state;
    private boolean canPossiblyBeStatic = true;
    private final Set<Symbol.MethodSymbol> outerReferences = new HashSet<Symbol.MethodSymbol>();

    public static boolean referencesOuter(Tree tree, Symbol owner, VisitorState state) {
        CanBeStaticAnalyzer scanner = new CanBeStaticAnalyzer(owner, state);
        ((JCTree)tree).accept(scanner);
        return !scanner.canPossiblyBeStatic || !scanner.outerReferences.isEmpty();
    }

    public static CanBeStaticResult canBeStaticResult(Tree tree, Symbol owner, VisitorState state) {
        CanBeStaticAnalyzer scanner = new CanBeStaticAnalyzer(owner, state);
        ((JCTree)tree).accept(scanner);
        return CanBeStaticResult.of(scanner.canPossiblyBeStatic, scanner.outerReferences);
    }

    private CanBeStaticAnalyzer(Symbol owner, VisitorState state) {
        this.owner = owner;
        this.state = state;
        this.names = state.getNames();
    }

    @Override
    public void visitIdent(JCTree.JCIdent tree) {
        Symbol sym = tree.sym;
        if (sym == null) {
            return;
        }
        if (ASTHelpers.isStatic((Symbol)sym)) {
            return;
        }
        switch (sym.getKind()) {
            case TYPE_PARAMETER: 
            case FIELD: {
                if (CanBeStaticAnalyzer.isOwnedBy(sym, this.owner, this.state.getTypes())) break;
                this.canPossiblyBeStatic = false;
                break;
            }
            case METHOD: {
                if (CanBeStaticAnalyzer.isOwnedBy(sym, this.owner, this.state.getTypes())) break;
                this.outerReferences.add((Symbol.MethodSymbol)sym);
                break;
            }
            case CLASS: {
                Type enclosing = tree.type.getEnclosingType();
                if (enclosing == null) break;
                enclosing.accept(new TypeVariableScanner(), null);
                break;
            }
        }
    }

    private static boolean isOwnedBy(Symbol sym, Symbol owner, Types types) {
        if (sym.owner == owner) {
            return true;
        }
        if (owner instanceof Symbol.TypeSymbol) {
            Symbol.TypeSymbol typeSymbol = (Symbol.TypeSymbol)owner;
            return sym.isMemberOf(typeSymbol, types);
        }
        return false;
    }

    @Override
    public void visitSelect(JCTree.JCFieldAccess tree) {
        super.visitSelect(tree);
        if (tree.name == this.names._this || tree.name == this.names._super) {
            this.canPossiblyBeStatic = false;
        }
    }

    @Override
    public void visitNewClass(JCTree.JCNewClass tree) {
        super.visitNewClass(tree);
        Type type = ASTHelpers.getType((Tree)tree.clazz);
        if (type == null) {
            return;
        }
        if (CanBeStaticAnalyzer.memberOfEnclosing(this.owner, this.state, type.tsym)) {
            this.canPossiblyBeStatic = false;
        }
    }

    @Override
    public void visitReference(JCTree.JCMemberReference tree) {
        super.visitReference(tree);
        if (tree.getMode() != MemberReferenceTree.ReferenceMode.NEW) {
            return;
        }
        if (CanBeStaticAnalyzer.memberOfEnclosing(this.owner, this.state, tree.expr.type.tsym)) {
            this.canPossiblyBeStatic = false;
        }
    }

    private static boolean memberOfEnclosing(Symbol owner, VisitorState state, Symbol sym) {
        if (sym == null || !sym.hasOuterInstance()) {
            return false;
        }
        Symbol.ClassSymbol encl = ASTHelpers.enclosingClass((Symbol)owner);
        while (encl != null) {
            if (sym.isMemberOf(encl, state.getTypes())) {
                return true;
            }
            encl = encl.owner != null ? ASTHelpers.enclosingClass((Symbol)encl) : null;
        }
        return false;
    }

    @Override
    public void visitAnnotation(JCTree.JCAnnotation tree) {
    }

    record CanBeStaticResult(boolean canPossiblyBeStatic, ImmutableSet<Symbol.MethodSymbol> methodsReferenced) {
        static CanBeStaticResult of(boolean canPossiblyBeStatic, Set<Symbol.MethodSymbol> methodsReferenced) {
            return new CanBeStaticResult(canPossiblyBeStatic, (ImmutableSet<Symbol.MethodSymbol>)ImmutableSet.copyOf(methodsReferenced));
        }
    }

    private class TypeVariableScanner
    extends Types.SimpleVisitor<Void, Void> {
        private TypeVariableScanner() {
        }

        @Override
        public Void visitTypeVar(Type.TypeVar t, Void unused) {
            CanBeStaticAnalyzer.this.canPossiblyBeStatic = false;
            return null;
        }

        @Override
        public Void visitClassType(Type.ClassType t, Void unused) {
            for (Type a : t.getTypeArguments()) {
                a.accept(this, null);
            }
            if (t.getEnclosingType() != null) {
                t.getEnclosingType().accept(this, null);
            }
            return null;
        }

        @Override
        public Void visitType(Type type, Void unused) {
            return null;
        }
    }
}

