/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.errorprone.com.google.common.util.concurrent;

import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.errorprone.checker.index.qual.LessThanUnknown;
import org.checkerframework.errorprone.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.errorprone.checker.index.qual.SameLenUnknown;
import org.checkerframework.errorprone.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.errorprone.checker.index.qual.SubstringIndexBottom;
import org.checkerframework.errorprone.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.errorprone.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.errorprone.checker.initialization.qual.Initialized;
import org.checkerframework.errorprone.checker.nullness.qual.NonNull;
import org.checkerframework.errorprone.checker.nullness.qual.Nullable;
import org.checkerframework.errorprone.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.errorprone.checker.signedness.qual.Signed;
import org.checkerframework.errorprone.checker.signedness.qual.UnknownSignedness;
import org.checkerframework.errorprone.com.google.common.annotations.GwtCompatible;
import org.checkerframework.errorprone.com.google.j2objc.annotations.ReflectionSupport;
import org.checkerframework.errorprone.common.value.qual.UnknownVal;

@GwtCompatible(emulated=true)
@ReflectionSupport(value=ReflectionSupport.Level.FULL)
abstract class InterruptibleTask<@SubstringIndexBottom T>
extends AtomicReference<Runnable>
implements Runnable {
    private static final @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness Runnable DONE;
    private static final @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness Runnable INTERRUPTING;
    private static final @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness Runnable PARKED;
    private static final @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int MAX_BUSY_WAIT_SPINS = 1000;

    InterruptibleTask() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        Throwable error;
        T result;
        boolean run;
        Thread currentThread;
        block26: {
            currentThread = Thread.currentThread();
            if (!this.compareAndSet(null, currentThread)) {
                return;
            }
            run = !this.isDone();
            result = null;
            error = null;
            try {
                if (!run) break block26;
                result = this.runInterruptibly();
            }
            catch (Throwable t2) {
                try {
                    error = t2;
                }
                catch (Throwable throwable) {
                    if (!this.compareAndSet(currentThread, DONE)) {
                        boolean restoreInterruptedBit = false;
                        int spinCount = 0;
                        Runnable state = (Runnable)this.get();
                        while (state == INTERRUPTING || state == PARKED) {
                            if (++spinCount > 1000) {
                                if (state == PARKED || this.compareAndSet(INTERRUPTING, PARKED)) {
                                    restoreInterruptedBit = Thread.interrupted() || restoreInterruptedBit;
                                    LockSupport.park(this);
                                }
                            } else {
                                Thread.yield();
                            }
                            state = (Runnable)this.get();
                        }
                        if (restoreInterruptedBit) {
                            currentThread.interrupt();
                        }
                    }
                    if (run) {
                        this.afterRanInterruptibly(result, error);
                    }
                    throw throwable;
                }
                if (!this.compareAndSet(currentThread, DONE)) {
                    boolean restoreInterruptedBit = false;
                    int spinCount = 0;
                    Runnable state = (Runnable)this.get();
                    while (state == INTERRUPTING || state == PARKED) {
                        if (++spinCount > 1000) {
                            if (state == PARKED || this.compareAndSet(INTERRUPTING, PARKED)) {
                                restoreInterruptedBit = Thread.interrupted() || restoreInterruptedBit;
                                LockSupport.park(this);
                            }
                        } else {
                            Thread.yield();
                        }
                        state = (Runnable)this.get();
                    }
                    if (restoreInterruptedBit) {
                        currentThread.interrupt();
                    }
                }
                if (run) {
                    this.afterRanInterruptibly(result, error);
                }
            }
        }
        if (!this.compareAndSet(currentThread, DONE)) {
            boolean restoreInterruptedBit = false;
            int spinCount = 0;
            Runnable state = (Runnable)this.get();
            while (state == INTERRUPTING || state == PARKED) {
                if (++spinCount > 1000) {
                    if (state == PARKED || this.compareAndSet(INTERRUPTING, PARKED)) {
                        restoreInterruptedBit = Thread.interrupted() || restoreInterruptedBit;
                        LockSupport.park(this);
                    }
                } else {
                    Thread.yield();
                }
                state = (Runnable)this.get();
            }
            if (restoreInterruptedBit) {
                currentThread.interrupt();
            }
        }
        if (run) {
            this.afterRanInterruptibly(result, error);
        }
    }

    abstract @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness boolean isDone();

    abstract T runInterruptibly() throws @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness Exception;

    abstract void afterRanInterruptibly(@Nullable T var1, @Nullable @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @Initialized @UnknownSignedness Throwable var2);

    final void interruptTask() {
        Runnable currentRunner = (Runnable)this.get();
        if (currentRunner instanceof Thread && this.compareAndSet(currentRunner, INTERRUPTING)) {
            try {
                ((Thread)currentRunner).interrupt();
            }
            finally {
                Runnable prev = this.getAndSet(DONE);
                if (prev == PARKED) {
                    LockSupport.unpark((Thread)currentRunner);
                }
            }
        }
    }

    @Override
    @SideEffectFree
    public final @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness String toString() {
        Runnable state = (Runnable)this.get();
        String result = state == DONE ? "running=[DONE]" : (state == INTERRUPTING ? "running=[INTERRUPTED]" : (state instanceof Thread ? "running=[RUNNING ON " + ((Thread)state).getName() + "]" : "running=[NOT STARTED YET]"));
        return result + ", " + this.toPendingString();
    }

    abstract @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness String toPendingString();

    static {
        Class<LockSupport> clazz = LockSupport.class;
        DONE = new DoNothingRunnable();
        INTERRUPTING = new DoNothingRunnable();
        PARKED = new DoNothingRunnable();
    }

    private static final class DoNothingRunnable
    implements Runnable {
        private DoNothingRunnable() {
        }

        @Override
        public void run() {
        }
    }
}

