/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryMember;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMember;
import proguard.classfile.kotlin.KotlinFunctionMetadata;
import proguard.classfile.kotlin.KotlinMetadata;
import proguard.classfile.kotlin.KotlinTypeMetadata;
import proguard.classfile.kotlin.KotlinValueParameterMetadata;
import proguard.classfile.kotlin.visitor.KotlinFunctionVisitor;
import proguard.classfile.kotlin.visitor.KotlinMetadataToClazzVisitor;
import proguard.classfile.kotlin.visitor.KotlinTypeVisitor;
import proguard.classfile.kotlin.visitor.KotlinValueParameterVisitor;
import proguard.classfile.kotlin.visitor.MethodToKotlinFunctionVisitor;
import proguard.classfile.kotlin.visitor.ReferencedKotlinMetadataVisitor;
import proguard.classfile.kotlin.visitor.filter.KotlinClassKindFilter;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;

public class MemberDescriptorReferencedClassVisitor
implements MemberVisitor {
    private final ClassVisitor classVisitor;
    private final KotlinFunctionDescriptorReferenceVisitor kotlinFunRefVisitor;

    public MemberDescriptorReferencedClassVisitor(ClassVisitor classVisitor) {
        this(false, classVisitor);
    }

    public MemberDescriptorReferencedClassVisitor(boolean includeKotlinMetadata, ClassVisitor classVisitor) {
        this.classVisitor = classVisitor;
        this.kotlinFunRefVisitor = includeKotlinMetadata ? new KotlinFunctionDescriptorReferenceVisitor() : null;
    }

    @Override
    public void visitProgramMember(ProgramClass programClass, ProgramMember programMember) {
        programMember.referencedClassesAccept(this.classVisitor);
        if (this.kotlinFunRefVisitor != null) {
            programMember.accept(programClass, (MemberVisitor)new MethodToKotlinFunctionVisitor(this.kotlinFunRefVisitor));
        }
    }

    @Override
    public void visitLibraryMember(LibraryClass libraryClass, LibraryMember libraryMember) {
        libraryMember.referencedClassesAccept(this.classVisitor);
        if (this.kotlinFunRefVisitor != null) {
            libraryMember.accept(libraryClass, (MemberVisitor)new MethodToKotlinFunctionVisitor(this.kotlinFunRefVisitor));
        }
    }

    private class KotlinFunctionDescriptorReferenceVisitor
    implements KotlinFunctionVisitor,
    KotlinValueParameterVisitor,
    KotlinTypeVisitor {
        private KotlinFunctionDescriptorReferenceVisitor() {
        }

        @Override
        public void visitAnyFunction(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata) {
            kotlinFunctionMetadata.valueParametersAccept(clazz, kotlinMetadata, this);
        }

        @Override
        public void visitAnyValueParameter(Clazz clazz, KotlinValueParameterMetadata kotlinValueParameterMetadata) {
        }

        @Override
        public void visitFunctionValParameter(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata) {
            kotlinValueParameterMetadata.typeAccept(clazz, kotlinMetadata, kotlinFunctionMetadata, (KotlinTypeVisitor)this);
        }

        @Override
        public void visitAnyType(Clazz clazz, KotlinTypeMetadata kotlinTypeMetadata) {
            kotlinTypeMetadata.referencedClassAccept(new ReferencedKotlinMetadataVisitor(new KotlinClassKindFilter(metadata -> metadata.flags.isValue, new KotlinMetadataToClazzVisitor(MemberDescriptorReferencedClassVisitor.this.classVisitor))));
        }
    }
}

