/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.domain.taint;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import proguard.analysis.cpa.defaults.DelegateAbstractDomain;
import proguard.analysis.cpa.defaults.MergeJoinOperator;
import proguard.analysis.cpa.defaults.SimpleCpa;
import proguard.analysis.cpa.defaults.StopJoinOperator;
import proguard.analysis.cpa.interfaces.AbstractDomain;
import proguard.analysis.cpa.jvm.domain.taint.JvmTaintSource;
import proguard.analysis.cpa.jvm.domain.taint.JvmTaintTransferRelation;
import proguard.analysis.cpa.jvm.domain.taint.JvmTaintTransformer;
import proguard.classfile.MethodSignature;
import proguard.classfile.Signature;

public class JvmTaintCpa
extends SimpleCpa {
    public JvmTaintCpa(Set<? extends JvmTaintSource> sources) {
        this(JvmTaintCpa.createSourcesMap(sources), new DelegateAbstractDomain(), Collections.emptyMap());
    }

    public JvmTaintCpa(Set<? extends JvmTaintSource> sources, Map<MethodSignature, JvmTaintTransformer> taintTransformers) {
        this(JvmTaintCpa.createSourcesMap(sources), new DelegateAbstractDomain(), taintTransformers);
    }

    public JvmTaintCpa(Map<Signature, Set<JvmTaintSource>> signaturesToSources, Map<MethodSignature, JvmTaintTransformer> taintTransformers) {
        this(signaturesToSources, new DelegateAbstractDomain(), taintTransformers);
    }

    private JvmTaintCpa(Map<Signature, Set<JvmTaintSource>> sources, AbstractDomain abstractDomain, Map<MethodSignature, JvmTaintTransformer> taintTransformers) {
        super(abstractDomain, new JvmTaintTransferRelation(sources, taintTransformers), new MergeJoinOperator(abstractDomain), new StopJoinOperator(abstractDomain));
    }

    public static Map<Signature, Set<JvmTaintSource>> createSourcesMap(Set<? extends JvmTaintSource> sources) {
        HashMap<Signature, Set<JvmTaintSource>> taintSourcesMap = new HashMap<Signature, Set<JvmTaintSource>>();
        sources.forEach(s -> taintSourcesMap.computeIfAbsent(s.signature, key -> new HashSet()).add(s));
        return taintSourcesMap;
    }
}

