/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.time;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Name;

@BugPattern(summary="java.time APIs that silently use the default system time-zone are not allowed.", explanation="Using APIs that silently use the default system time-zone is dangerous. The default system time-zone can vary from machine to machine or JVM to JVM. You must choose an explicit ZoneId.", severity=BugPattern.SeverityLevel.WARNING)
public final class JavaTimeDefaultTimeZone
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final ImmutableSet<String> NOW_STATIC = ImmutableSet.of((Object)"java.time.LocalDate", (Object)"java.time.LocalDateTime", (Object)"java.time.LocalTime", (Object)"java.time.MonthDay", (Object)"java.time.OffsetDateTime", (Object)"java.time.OffsetTime", (Object[])new String[]{"java.time.Year", "java.time.YearMonth", "java.time.ZonedDateTime", "java.time.chrono.JapaneseDate", "java.time.chrono.MinguoDate", "java.time.chrono.HijrahDate", "java.time.chrono.ThaiBuddhistDate"});
    private static final ImmutableSet<String> DATE_NOW_INSTANCE = ImmutableSet.of((Object)"java.time.chrono.Chronology", (Object)"java.time.chrono.HijrahChronology", (Object)"java.time.chrono.IsoChronology", (Object)"java.time.chrono.JapaneseChronology", (Object)"java.time.chrono.MinguoChronology", (Object)"java.time.chrono.ThaiBuddhistChronology", (Object[])new String[0]);
    private static final Matcher<ExpressionTree> CLOCK_MATCHER = Matchers.staticMethod().onClass("java.time.Clock").named("systemDefaultZone").withNoParameters();
    private static final Matcher<ExpressionTree> IN_JAVA_TIME = Matchers.packageStartsWith((String)"java.time");

    private static boolean matches(MethodInvocationTree tree) {
        if (!tree.getArguments().isEmpty()) {
            return false;
        }
        Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MethodInvocationTree)tree);
        return switch (((Name)symbol.getSimpleName()).toString()) {
            case "now" -> {
                if (symbol.isStatic() && NOW_STATIC.contains((Object)symbol.owner.getQualifiedName().toString())) {
                    yield true;
                }
                yield false;
            }
            case "dateNow" -> {
                if (!symbol.isStatic() && DATE_NOW_INSTANCE.contains((Object)symbol.owner.getQualifiedName().toString())) {
                    yield true;
                }
                yield false;
            }
            case "systemDefaultZone" -> {
                if (symbol.isStatic() && symbol.owner.getQualifiedName().contentEquals("java.time.Clock")) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        String replacementMethod;
        if (!JavaTimeDefaultTimeZone.matches(tree) || IN_JAVA_TIME.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        String idealReplacementCode = "ZoneId.of(\"America/Los_Angeles\")";
        SuggestedFix.Builder fixBuilder = SuggestedFix.builder();
        String zoneIdName = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fixBuilder, (String)"java.time.ZoneId");
        String replacementCode = zoneIdName + ".systemDefault()";
        ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)tree);
        boolean systemDefaultZoneClockMethod = CLOCK_MATCHER.matches((Tree)tree, state);
        String string = replacementMethod = systemDefaultZoneClockMethod ? "system" : ASTHelpers.getSymbol((MethodInvocationTree)tree).name.toString();
        if (receiver != null) {
            fixBuilder.replace(state.getEndPosition((Tree)receiver), state.getEndPosition((Tree)tree), "." + replacementMethod + "(" + replacementCode + ")");
        } else {
            if (systemDefaultZoneClockMethod) {
                fixBuilder.addStaticImport("java.time.Clock.systemDefaultZone");
            }
            fixBuilder.replace((Tree)tree, replacementMethod + "(" + replacementCode + ")");
        }
        return this.buildDescription(tree).setMessage(String.format("%s.%s is not allowed because it silently uses the system default time-zone. You must pass an explicit time-zone (e.g., %s) to this method.", ASTHelpers.getSymbol((MethodInvocationTree)tree).owner.getSimpleName(), ASTHelpers.getSymbol((MethodInvocationTree)tree), idealReplacementCode)).addFix((Fix)fixBuilder.build()).build();
    }
}

