/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.time;

import com.google.common.base.Enums;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

@BugPattern(summary="Unit mismatch when decomposing a Duration or Instant to call a <long, TimeUnit> API", severity=BugPattern.SeverityLevel.ERROR)
public final class DurationToLongTimeUnit
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final String JAVA_DURATION = "java.time.Duration";
    private static final String JAVA_INSTANT = "java.time.Instant";
    private static final String JAVA_DURATIONS = "com.google.common.time.Durations";
    private static final String JAVA_INSTANTS = "com.google.common.time.Instants";
    private static final String JODA_DURATION = "org.joda.time.Duration";
    private static final String JODA_RDURATION = "org.joda.time.ReadableDuration";
    private static final String JODA_RINSTANT = "org.joda.time.ReadableInstant";
    private static final String PROTO_DURATION = "com.google.protobuf.Duration";
    private static final String PROTO_TIMESTAMP = "com.google.protobuf.Timestamp";
    private static final String TIME_UNIT = "java.util.concurrent.TimeUnit";
    private static final ImmutableMap<Matcher<ExpressionTree>, TimeUnit> MATCHERS = new ImmutableMap.Builder().put((Object)Matchers.instanceMethod().onExactClass("java.time.Duration").named("toNanos"), (Object)TimeUnit.NANOSECONDS).put((Object)Matchers.instanceMethod().onExactClass("java.time.Duration").named("toMillis"), (Object)TimeUnit.MILLISECONDS).put((Object)Matchers.instanceMethod().onExactClass("java.time.Duration").named("toSeconds"), (Object)TimeUnit.SECONDS).put((Object)Matchers.instanceMethod().onExactClass("java.time.Duration").named("getSeconds"), (Object)TimeUnit.SECONDS).put((Object)Matchers.instanceMethod().onExactClass("java.time.Duration").named("toMinutes"), (Object)TimeUnit.MINUTES).put((Object)Matchers.instanceMethod().onExactClass("java.time.Duration").named("toHours"), (Object)TimeUnit.HOURS).put((Object)Matchers.instanceMethod().onExactClass("java.time.Duration").named("toDays"), (Object)TimeUnit.DAYS).put((Object)Matchers.instanceMethod().onExactClass("java.time.Instant").named("toEpochMilli"), (Object)TimeUnit.MILLISECONDS).put((Object)Matchers.instanceMethod().onExactClass("java.time.Instant").named("getEpochSecond"), (Object)TimeUnit.SECONDS).put((Object)Matchers.staticMethod().onClass("com.google.common.time.Durations").named("toNanosSaturated"), (Object)TimeUnit.NANOSECONDS).put((Object)Matchers.staticMethod().onClass("com.google.common.time.Durations").named("toMicros"), (Object)TimeUnit.MICROSECONDS).put((Object)Matchers.staticMethod().onClass("com.google.common.time.Durations").named("toMicrosSaturated"), (Object)TimeUnit.MICROSECONDS).put((Object)Matchers.staticMethod().onClass("com.google.common.time.Durations").named("toMillisSaturated"), (Object)TimeUnit.MILLISECONDS).put((Object)Matchers.staticMethod().onClass("com.google.common.time.Instants").named("toEpochNanos"), (Object)TimeUnit.NANOSECONDS).put((Object)Matchers.staticMethod().onClass("com.google.common.time.Instants").named("toEpochNanosSaturated"), (Object)TimeUnit.NANOSECONDS).put((Object)Matchers.staticMethod().onClass("com.google.common.time.Instants").named("toEpochMicros"), (Object)TimeUnit.MICROSECONDS).put((Object)Matchers.staticMethod().onClass("com.google.common.time.Instants").named("toEpochMicrosSaturated"), (Object)TimeUnit.MICROSECONDS).put((Object)Matchers.staticMethod().onClass("com.google.common.time.Instants").named("toEpochMillisSaturated"), (Object)TimeUnit.MILLISECONDS).put((Object)Matchers.instanceMethod().onExactClass("org.joda.time.Duration").named("getStandardSeconds"), (Object)TimeUnit.SECONDS).put((Object)Matchers.instanceMethod().onExactClass("org.joda.time.Duration").named("getStandardMinutes"), (Object)TimeUnit.MINUTES).put((Object)Matchers.instanceMethod().onExactClass("org.joda.time.Duration").named("getStandardHours"), (Object)TimeUnit.HOURS).put((Object)Matchers.instanceMethod().onExactClass("org.joda.time.Duration").named("getStandardDays"), (Object)TimeUnit.DAYS).put((Object)Matchers.instanceMethod().onDescendantOf("org.joda.time.ReadableDuration").named("getMillis"), (Object)TimeUnit.MILLISECONDS).put((Object)Matchers.instanceMethod().onDescendantOf("org.joda.time.ReadableInstant").named("getMillis"), (Object)TimeUnit.MILLISECONDS).put((Object)Matchers.instanceMethod().onExactClass("com.google.protobuf.Duration").named("getSeconds"), (Object)TimeUnit.SECONDS).put((Object)Matchers.instanceMethod().onExactClass("com.google.protobuf.Timestamp").named("getSeconds"), (Object)TimeUnit.SECONDS).buildOrThrow();
    private static final Matcher<ExpressionTree> TIME_UNIT_DECOMPOSITION = Matchers.instanceMethod().onExactClass("java.util.concurrent.TimeUnit").named("convert").withParameters("java.time.Duration", new String[0]);
    private static final Supplier<Type> JAVA_UTIL_CONCURRENT_TIMEUNIT = VisitorState.memoize((Supplier & Serializable)state -> state.getTypeFromString(TIME_UNIT));

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        List<? extends ExpressionTree> arguments = tree.getArguments();
        if (arguments.size() >= 2) {
            Type.JCPrimitiveType longType = state.getSymtab().longType;
            Type timeUnitType = (Type)JAVA_UTIL_CONCURRENT_TIMEUNIT.get(state);
            for (int i = 0; i < arguments.size() - 1; ++i) {
                Optional<TimeUnit> sourceTimeUnit;
                Optional<TimeUnit> timeUnitInArgument;
                ExpressionTree arg0 = arguments.get(i);
                ExpressionTree timeUnitTree = arguments.get(i + 1);
                Type type0 = ASTHelpers.getType((Tree)arg0);
                Type type1 = ASTHelpers.getType((Tree)timeUnitTree);
                if (!ASTHelpers.isSameType((Type)type0, (Type)longType, (VisitorState)state) || !ASTHelpers.isSameType((Type)type1, (Type)timeUnitType, (VisitorState)state) || !(timeUnitInArgument = DurationToLongTimeUnit.getTimeUnit(timeUnitTree)).isPresent()) continue;
                for (Map.Entry entry : MATCHERS.entrySet()) {
                    TimeUnit timeUnitExpressedInConversion = (TimeUnit)((Object)entry.getValue());
                    if (!((Matcher)entry.getKey()).matches((Tree)arg0, state) || timeUnitInArgument.get() == timeUnitExpressedInConversion) continue;
                    return this.describeTimeUnitConversionFix(tree, timeUnitTree, timeUnitExpressedInConversion);
                }
                if (!TIME_UNIT_DECOMPOSITION.matches((Tree)arg0, state) || !(sourceTimeUnit = DurationToLongTimeUnit.getTimeUnit(ASTHelpers.getReceiver((ExpressionTree)arg0))).isPresent() || sourceTimeUnit.get().equals((Object)timeUnitInArgument.get())) continue;
                return this.describeTimeUnitConversionFix(tree, timeUnitTree, sourceTimeUnit.get());
            }
        }
        return Description.NO_MATCH;
    }

    private Description describeTimeUnitConversionFix(MethodInvocationTree tree, ExpressionTree timeUnitTree, TimeUnit timeUnitExpressedInConversion) {
        SuggestedFix fix = SuggestedFix.builder().addImport(TIME_UNIT).replace((Tree)timeUnitTree, "TimeUnit." + String.valueOf((Object)timeUnitExpressedInConversion)).build();
        return this.describeMatch(tree, (Fix)fix);
    }

    static Optional<TimeUnit> getTimeUnit(ExpressionTree timeUnit) {
        if (timeUnit instanceof IdentifierTree) {
            IdentifierTree identifierTree = (IdentifierTree)timeUnit;
            return Enums.getIfPresent(TimeUnit.class, (String)identifierTree.getName().toString()).toJavaUtil();
        }
        if (timeUnit instanceof MemberSelectTree) {
            MemberSelectTree memberSelectTree = (MemberSelectTree)timeUnit;
            return Enums.getIfPresent(TimeUnit.class, (String)memberSelectTree.getIdentifier().toString()).toJavaUtil();
        }
        return Optional.empty();
    }
}

