/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.overloading;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.bugpatterns.overloading.ParameterOrderingViolation;
import com.google.errorprone.bugpatterns.overloading.ParameterTree;
import com.sun.source.tree.MethodTree;

class AutoBuilder_ParameterOrderingViolation_Builder
extends ParameterOrderingViolation.Builder {
    private MethodTree methodTree;
    private ImmutableList<ParameterTree> actual;
    private ImmutableList<ParameterTree> expected;

    AutoBuilder_ParameterOrderingViolation_Builder() {
    }

    @Override
    ParameterOrderingViolation.Builder setMethodTree(MethodTree methodTree) {
        if (methodTree == null) {
            throw new NullPointerException("Null methodTree");
        }
        this.methodTree = methodTree;
        return this;
    }

    @Override
    ParameterOrderingViolation.Builder setActual(ImmutableList<ParameterTree> actual) {
        if (actual == null) {
            throw new NullPointerException("Null actual");
        }
        this.actual = actual;
        return this;
    }

    @Override
    ParameterOrderingViolation.Builder setExpected(ImmutableList<ParameterTree> expected) {
        if (expected == null) {
            throw new NullPointerException("Null expected");
        }
        this.expected = expected;
        return this;
    }

    @Override
    ParameterOrderingViolation autoBuild() {
        if (this.methodTree == null || this.actual == null || this.expected == null) {
            StringBuilder missing = new StringBuilder();
            if (this.methodTree == null) {
                missing.append(" methodTree");
            }
            if (this.actual == null) {
                missing.append(" actual");
            }
            if (this.expected == null) {
                missing.append(" expected");
            }
            throw new IllegalStateException("Missing required properties:" + String.valueOf(missing));
        }
        return new ParameterOrderingViolation(this.methodTree, this.actual, this.expected);
    }
}

