/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.flogger;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;

@BugPattern(summary="Splitting log statements and using Api instances directly breaks logging.", linkType=BugPattern.LinkType.CUSTOM, link="https://google.github.io/flogger/best_practice#no-split", severity=BugPattern.SeverityLevel.ERROR)
public final class FloggerSplitLogStatement
extends BugChecker
implements BugChecker.MethodTreeMatcher,
BugChecker.VariableTreeMatcher {
    private static final Matcher<Tree> IS_LOGGER_API = Matchers.isSubtypeOf((String)"com.google.common.flogger.LoggingApi");
    private static final Matcher<Tree> CLASS_MATCHES = Matchers.not((Matcher)Matchers.anyOf((Matcher[])new Matcher[]{Matchers.enclosingClass((Matcher)Matchers.isSubtypeOf((String)"com.google.common.flogger.AbstractLogger")), Matchers.enclosingClass((Matcher)Matchers.isSubtypeOf((String)"com.google.common.flogger.LoggingApi"))}));
    private static final Matcher<MethodTree> METHOD_MATCHES = Matchers.allOf((Matcher[])new Matcher[]{Matchers.methodReturns(IS_LOGGER_API), CLASS_MATCHES});
    private static final Matcher<VariableTree> VARIABLE_MATCHES = Matchers.allOf((Matcher[])new Matcher[]{Matchers.variableType(IS_LOGGER_API), CLASS_MATCHES});

    public Description matchMethod(MethodTree tree, VisitorState state) {
        return METHOD_MATCHES.matches((Tree)tree, state) ? this.describeMatch(tree) : Description.NO_MATCH;
    }

    public Description matchVariable(VariableTree tree, VisitorState state) {
        return VARIABLE_MATCHES.matches((Tree)tree, state) ? this.describeMatch(tree) : Description.NO_MATCH;
    }
}

