/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.collectionincompatibletype;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.collectionincompatibletype.AbstractCollectionIncompatibleTypeMatcher;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.Signatures;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

class TypeArgOfMethodArgMatcher
extends AbstractCollectionIncompatibleTypeMatcher {
    private final Matcher<ExpressionTree> methodMatcher;
    private final String receiverTypeName;
    private final int receiverTypeArgIndex;
    private final int methodArgIndex;
    private final String methodArgTypeName;
    private final int methodArgTypeArgIndex;

    public TypeArgOfMethodArgMatcher(String receiverTypeName, int receiverTypeArgIndex, int methodArgIndex, String methodArgTypeName, int methodArgTypeArgIndex, String name, String firstParam, String ... otherParams) {
        this.methodMatcher = MethodMatchers.instanceMethod().onDescendantOf(receiverTypeName).named(name).withParameters(firstParam, otherParams);
        this.receiverTypeName = receiverTypeName;
        this.receiverTypeArgIndex = receiverTypeArgIndex;
        this.methodArgIndex = methodArgIndex;
        this.methodArgTypeName = methodArgTypeName;
        this.methodArgTypeArgIndex = methodArgTypeArgIndex;
    }

    @Override
    Matcher<ExpressionTree> methodMatcher() {
        return this.methodMatcher;
    }

    @Override
    ExpressionTree extractSourceTree(MethodInvocationTree tree, VisitorState state) {
        return (ExpressionTree)Iterables.get(tree.getArguments(), (int)this.methodArgIndex);
    }

    @Override
    @Nullable ExpressionTree extractSourceTree(MemberReferenceTree tree, VisitorState state) {
        return tree;
    }

    @Override
    Type extractSourceType(MethodInvocationTree tree, VisitorState state) {
        return TypeArgOfMethodArgMatcher.extractTypeArgAsMemberOfSupertype(ASTHelpers.getType((Tree)((Tree)Iterables.get(tree.getArguments(), (int)this.methodArgIndex))), state.getSymbolFromString(this.methodArgTypeName), this.methodArgTypeArgIndex, state.getTypes());
    }

    @Override
    @Nullable Type extractSourceType(MemberReferenceTree tree, VisitorState state) {
        return TypeArgOfMethodArgMatcher.extractTypeArgAsMemberOfSupertype(ASTHelpers.getType((Tree)tree).allparams().get(this.methodArgIndex), state.getSymbolFromString(this.methodArgTypeName), this.methodArgTypeArgIndex, state.getTypes());
    }

    @Override
    Type extractTargetType(MethodInvocationTree tree, VisitorState state) {
        return TypeArgOfMethodArgMatcher.extractTypeArgAsMemberOfSupertype(ASTHelpers.getReceiverType((ExpressionTree)tree), state.getSymbolFromString(this.receiverTypeName), this.receiverTypeArgIndex, state.getTypes());
    }

    @Override
    @Nullable Type extractTargetType(MemberReferenceTree tree, VisitorState state) {
        return TypeArgOfMethodArgMatcher.extractTypeArgAsMemberOfSupertype(ASTHelpers.getReceiverType((ExpressionTree)tree), state.getSymbolFromString(this.receiverTypeName), this.receiverTypeArgIndex, state.getTypes());
    }

    String getMethodArgTypeName() {
        return this.methodArgTypeName;
    }

    @Override
    Optional<Fix> buildFix(AbstractCollectionIncompatibleTypeMatcher.MatchResult result) {
        String fullyQualifiedType = this.getMethodArgTypeName();
        String simpleType = (String)Iterables.getLast((Iterable)Splitter.on((char)'.').split((CharSequence)fullyQualifiedType));
        return Optional.of(SuggestedFix.builder().prefixWith((Tree)result.sourceTree(), String.format("(%s<?>) ", simpleType)).addImport(fullyQualifiedType).build());
    }

    @Override
    public String message(AbstractCollectionIncompatibleTypeMatcher.MatchResult result, String sourceType, String targetType) {
        String sourceTreeType = Signatures.prettyType((Type)ASTHelpers.getType((Tree)result.sourceTree()));
        return String.format("Argument '%s' should not be passed to this method; its type %s has a type argument %s that is not compatible with its collection's type argument %s", result.sourceTree(), sourceTreeType, sourceType, targetType);
    }
}

