/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.checkreturnvalue;

import com.google.common.base.Preconditions;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.checkreturnvalue.ResultUsePolicy;
import com.google.errorprone.bugpatterns.checkreturnvalue.ResultUseRule;
import com.google.errorprone.bugpatterns.checkreturnvalue.Rules;
import com.google.errorprone.util.ASTHelpers;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.List;
import java.util.Optional;

public final class DaggerRules {
    public static ResultUseRule<VisitorState, Symbol> componentBuilders() {
        return new DaggerRule("dagger.Component.Builder");
    }

    public static ResultUseRule<VisitorState, Symbol> subcomponentBuilders() {
        return new DaggerRule("dagger.Subcomponent.Builder");
    }

    public static ResultUseRule<VisitorState, Symbol> productionComponentBuilders() {
        return new DaggerRule("dagger.producers.ProductionComponent.Builder");
    }

    public static ResultUseRule<VisitorState, Symbol> productionSubcomponentBuilders() {
        return new DaggerRule("dagger.producers.ProductionSubcomponent.Builder");
    }

    private DaggerRules() {
    }

    private static final class DaggerRule
    extends Rules.ErrorProneMethodRule {
        private final String annotationName;

        DaggerRule(String annotationName) {
            this.annotationName = (String)Preconditions.checkNotNull((Object)annotationName);
        }

        @Override
        public String id() {
            return "@" + this.annotationName;
        }

        @Override
        public Optional<ResultUsePolicy> evaluateMethod(Symbol.MethodSymbol method, VisitorState state) {
            if (((List)method.getParameters()).size() == 1 && ASTHelpers.isAbstract((Symbol.MethodSymbol)method) && ASTHelpers.hasAnnotation((Symbol)ASTHelpers.enclosingClass((Symbol)method), (String)this.annotationName, (VisitorState)state) && Rules.returnsEnclosingType(method, state)) {
                return Optional.of(ResultUsePolicy.OPTIONAL);
            }
            return Optional.empty();
        }
    }
}

