/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Types;
import java.util.List;

@BugPattern(summary="Catching Throwable/Error masks failures from fail() or assert*() in the try block", severity=BugPattern.SeverityLevel.ERROR)
public class TryFailThrowable
extends BugChecker
implements BugChecker.TryTreeMatcher {
    private static final Matcher<VariableTree> javaLangThrowable = Matchers.isSameType((String)"java.lang.Throwable");
    private static final Matcher<VariableTree> javaLangError = Matchers.isSameType((String)"java.lang.Error");
    private static final Matcher<VariableTree> someAssertionFailure = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.isSameType((String)"java.lang.AssertionError"), Matchers.isSameType((String)"junit.framework.AssertionFailedError")});
    private static final Matcher<ExpressionTree> failOrAssert = new Matcher<ExpressionTree>(){

        public boolean matches(ExpressionTree item, VisitorState state) {
            if (!(item instanceof MethodInvocationTree)) {
                return false;
            }
            Symbol sym = ASTHelpers.getSymbol((Tree)item);
            if (!(sym instanceof Symbol.MethodSymbol)) {
                throw new IllegalArgumentException("not a method call");
            }
            if (!ASTHelpers.isStatic((Symbol)sym)) {
                return false;
            }
            String methodName = sym.getQualifiedName().toString();
            String className = sym.owner.getQualifiedName().toString();
            return !(!methodName.startsWith("assert") && !methodName.startsWith("fail") || !className.equals("org.junit.Assert") && !className.equals("junit.framework.Assert") && !className.equals("junit.framework.TestCase") && !className.endsWith("MoreAsserts"));
        }
    };

    public Description matchTry(TryTree tree, VisitorState state) {
        MatchResult matchResult = TryFailThrowable.tryTreeMatches(tree, state);
        if (!matchResult.matched()) {
            return Description.NO_MATCH;
        }
        Description.Builder builder = this.buildDescription(tree.getCatches().get(0).getParameter());
        if (matchResult.caughtType == CaughtType.JAVA_LANG_THROWABLE) {
            builder.addFix(TryFailThrowable.fixByCatchingException(tree));
        }
        if (matchResult.caughtType == CaughtType.SOME_ASSERTION_FAILURE) {
            builder.addFix(TryFailThrowable.fixByThrowingJavaLangError(matchResult.failStatement, state));
        }
        builder.addFix(TryFailThrowable.fixWithReturnOrBoolean(tree, matchResult.failStatement, state));
        return builder.build();
    }

    private static Fix fixByCatchingException(TryTree tryTree) {
        VariableTree catchParameter = TryFailThrowable.getOnlyCatch(tryTree).getParameter();
        return SuggestedFix.replace((Tree)catchParameter, (String)("Exception " + String.valueOf(catchParameter.getName())));
    }

    private static Fix fixByThrowingJavaLangError(StatementTree failStatement, VisitorState state) {
        String messageSnippet = TryFailThrowable.getMessageSnippet(failStatement, state, HasOtherParameters.FALSE);
        return SuggestedFix.replace((Tree)failStatement, (String)String.format("throw new Error(%s);", messageSnippet));
    }

    private static Fix fixWithReturnOrBoolean(TryTree tryTree, StatementTree failStatement, VisitorState state) {
        Tree parent = state.getPath().getParentPath().getLeaf();
        Tree grandparent = state.getPath().getParentPath().getParentPath().getLeaf();
        if (parent instanceof BlockTree) {
            BlockTree blockTree = (BlockTree)parent;
            if (grandparent instanceof MethodTree && tryTree == TryFailThrowable.getLastStatement(blockTree)) {
                return TryFailThrowable.fixWithReturn(tryTree, failStatement, state);
            }
        }
        return TryFailThrowable.fixWithBoolean(tryTree, failStatement, state);
    }

    private static Fix fixWithReturn(TryTree tryTree, StatementTree failStatement, VisitorState state) {
        SuggestedFix.Builder builder = SuggestedFix.builder();
        builder.delete((Tree)failStatement);
        builder.replace((Tree)TryFailThrowable.getOnlyCatch(tryTree).getBlock(), "{ return; }");
        String messageSnippet = TryFailThrowable.getMessageSnippet(failStatement, state, HasOtherParameters.FALSE);
        builder.postfixWith((Tree)tryTree, String.format("fail(%s);", messageSnippet));
        return builder.build();
    }

    private static Fix fixWithBoolean(TryTree tryTree, StatementTree failStatement, VisitorState state) {
        SuggestedFix.Builder builder = SuggestedFix.builder();
        builder.delete((Tree)failStatement);
        builder.prefixWith((Tree)tryTree, "boolean threw = false;");
        builder.replace((Tree)TryFailThrowable.getOnlyCatch(tryTree).getBlock(), "{ threw = true; }");
        String messageSnippet = TryFailThrowable.getMessageSnippet(failStatement, state, HasOtherParameters.TRUE);
        builder.postfixWith((Tree)tryTree, String.format("assertTrue(%sthrew);", messageSnippet));
        return builder.build();
    }

    private static String getMessageSnippet(StatementTree failStatement, VisitorState state, HasOtherParameters hasOtherParameters) {
        ExpressionTree expression = ((ExpressionStatementTree)failStatement).getExpression();
        Symbol.MethodSymbol sym = (Symbol.MethodSymbol)ASTHelpers.getSymbol((Tree)expression);
        String tail = hasOtherParameters == HasOtherParameters.TRUE ? ", " : "";
        return TryFailThrowable.hasInitialStringParameter(sym, state) ? state.getSourceForNode((Tree)((MethodInvocationTree)expression).getArguments().get(0)) + tail : "";
    }

    private static boolean hasInitialStringParameter(Symbol.MethodSymbol sym, VisitorState state) {
        Types types = state.getTypes();
        List parameters = sym.getParameters();
        return !parameters.isEmpty() && types.isSameType(((Symbol.VarSymbol)parameters.get((int)0)).type, state.getSymtab().stringType);
    }

    private static MatchResult tryTreeMatches(TryTree tryTree, VisitorState state) {
        BlockTree tryBlock = tryTree.getBlock();
        List<? extends StatementTree> statements = tryBlock.getStatements();
        if (statements.isEmpty()) {
            return MatchResult.doesNotMatch();
        }
        StatementTree failStatement = null;
        for (StatementTree statementTree : statements) {
            ExpressionStatementTree expressionStatementTree;
            if (!(statementTree instanceof ExpressionStatementTree) || !failOrAssert.matches((Tree)(expressionStatementTree = (ExpressionStatementTree)statementTree).getExpression(), state)) continue;
            failStatement = statementTree;
            break;
        }
        if (failStatement == null) {
            return MatchResult.doesNotMatch();
        }
        List<? extends CatchTree> catches = tryTree.getCatches();
        if (catches.size() != 1) {
            return MatchResult.doesNotMatch();
        }
        CatchTree catchTree = catches.get(0);
        VariableTree catchType = catchTree.getParameter();
        boolean catchesThrowable = javaLangThrowable.matches((Tree)catchType, state);
        boolean catchesError = javaLangError.matches((Tree)catchType, state);
        boolean catchesOtherError = someAssertionFailure.matches((Tree)catchType, state);
        if (!(catchesThrowable || catchesError || catchesOtherError)) {
            return MatchResult.doesNotMatch();
        }
        List<? extends StatementTree> catchStatements = catchTree.getBlock().getStatements();
        for (StatementTree statementTree : catchStatements) {
            if (Matchers.kindIs((Tree.Kind)Tree.Kind.EMPTY_STATEMENT).matches((Tree)statementTree, state)) continue;
            return MatchResult.doesNotMatch();
        }
        return MatchResult.matches(failStatement, catchesThrowable ? CaughtType.JAVA_LANG_THROWABLE : (catchesError ? CaughtType.JAVA_LANG_ERROR : CaughtType.SOME_ASSERTION_FAILURE));
    }

    private static StatementTree getLastStatement(BlockTree blockTree) {
        return (StatementTree)Iterables.getLast(blockTree.getStatements());
    }

    private static CatchTree getOnlyCatch(TryTree tryTree) {
        return tryTree.getCatches().get(0);
    }

    static final class MatchResult {
        static final MatchResult DOES_NOT_MATCH = new MatchResult(null, null);
        final StatementTree failStatement;
        final CaughtType caughtType;

        static MatchResult matches(StatementTree failStatement, CaughtType caughtType) {
            return new MatchResult((StatementTree)Preconditions.checkNotNull((Object)failStatement), (CaughtType)((Object)Preconditions.checkNotNull((Object)((Object)caughtType))));
        }

        static MatchResult doesNotMatch() {
            return DOES_NOT_MATCH;
        }

        MatchResult(StatementTree failStatement, CaughtType caughtType) {
            this.failStatement = failStatement;
            this.caughtType = caughtType;
        }

        boolean matched() {
            return this.caughtType != null;
        }
    }

    static enum CaughtType {
        JAVA_LANG_ERROR,
        JAVA_LANG_THROWABLE,
        SOME_ASSERTION_FAILURE;

    }

    static enum HasOtherParameters {
        TRUE,
        FALSE;

    }
}

