/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import javax.lang.model.type.UnionType;

@BugPattern(summary="throwIfUnchecked(knownCheckedException) is a no-op.", severity=BugPattern.SeverityLevel.ERROR)
public class ThrowIfUncheckedKnownChecked
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<MethodInvocationTree> IS_THROW_IF_UNCHECKED = Matchers.allOf((Matcher[])new Matcher[]{Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onClass("com.google.common.base.Throwables").named("throwIfUnchecked"), MethodMatchers.staticMethod().onClass("com.google.common.base.Throwables").named("propagateIfPossible")}), Matchers.argumentCount((int)1)});
    private static final Matcher<ExpressionTree> IS_KNOWN_CHECKED_EXCEPTION = new Matcher<ExpressionTree>(){

        public boolean matches(ExpressionTree tree, VisitorState state) {
            Type type = ASTHelpers.getType((Tree)tree);
            if (type.isUnion()) {
                return ((UnionType)((Object)type)).getAlternatives().stream().allMatch(t -> this.isKnownCheckedException(state, (Type)t));
            }
            return this.isKnownCheckedException(state, type);
        }

        boolean isKnownCheckedException(VisitorState state, Type type) {
            Types types = state.getTypes();
            Symtab symtab = state.getSymtab();
            return types.isSubtype(type = types.erasure(type), symtab.exceptionType) && !types.isSameType(type, symtab.exceptionType) && !types.isSubtype(type, symtab.runtimeExceptionType);
        }
    };

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (IS_THROW_IF_UNCHECKED.matches((Tree)tree, state) && Matchers.argument((int)0, IS_KNOWN_CHECKED_EXCEPTION).matches((Tree)tree, state)) {
            return this.describeMatch(tree, (Fix)SuggestedFix.delete((Tree)state.getPath().getParentPath().getLeaf()));
        }
        return Description.NO_MATCH;
    }
}

