/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import java.util.List;

@BugPattern(severity=BugPattern.SeverityLevel.WARNING, summary="This continue statement is redundant and can be removed. It may be misleading.")
public final class RedundantControlFlow
extends BugChecker
implements BugChecker.ContinueTreeMatcher {
    public Description matchContinue(ContinueTree tree, VisitorState state) {
        if (tree.getLabel() != null) {
            return Description.NO_MATCH;
        }
        Tree last = tree;
        for (Tree parent : state.getPath()) {
            switch (parent.getKind()) {
                case FOR_LOOP: 
                case ENHANCED_FOR_LOOP: 
                case WHILE_LOOP: 
                case DO_WHILE_LOOP: {
                    return this.describeMatch(tree, (Fix)SuggestedFix.delete((Tree)tree));
                }
                case CASE: {
                    return Description.NO_MATCH;
                }
                case BLOCK: {
                    List<? extends StatementTree> statements = ((BlockTree)parent).getStatements();
                    if (statements.indexOf(last) == statements.size() - 1) break;
                    return Description.NO_MATCH;
                }
            }
            last = parent;
        }
        return Description.NO_MATCH;
    }
}

