/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableBiMap;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.lang.model.element.Name;

@BugPattern(summary="Arguments of overriding method are inconsistent with overridden method.", severity=BugPattern.SeverityLevel.WARNING)
public class OverridingMethodInconsistentArgumentNamesChecker
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    public Description matchMethod(MethodTree methodTree, VisitorState state) {
        Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol((MethodTree)methodTree);
        Optional superMethod = ASTHelpers.findSuperMethods((Symbol.MethodSymbol)methodSymbol, (Types)state.getTypes()).stream().findFirst();
        if (superMethod.isEmpty() || methodSymbol.isVarArgs() || ((Symbol.MethodSymbol)superMethod.get()).isVarArgs()) {
            return Description.NO_MATCH;
        }
        ImmutableBiMap<Name, Integer> params = OverridingMethodInconsistentArgumentNamesChecker.getParams(methodSymbol);
        ImmutableBiMap<Name, Integer> superParams = OverridingMethodInconsistentArgumentNamesChecker.getParams((Symbol.MethodSymbol)superMethod.get());
        for (Name param : params.keySet()) {
            Name samePositionSuperParam;
            int position = (Integer)params.get((Object)param);
            if (!superParams.containsKey((Object)param) || position == (Integer)superParams.get((Object)param) || !params.containsKey((Object)(samePositionSuperParam = (Name)superParams.inverse().get((Object)position)))) continue;
            return this.buildDescription(methodTree).setMessage(this.getDescription((Symbol.MethodSymbol)superMethod.get())).build();
        }
        return Description.NO_MATCH;
    }

    private static ImmutableBiMap<Name, Integer> getParams(Symbol.MethodSymbol methodSymbol) {
        return (ImmutableBiMap)IntStream.range(0, ((List)methodSymbol.getParameters()).size()).boxed().collect(ImmutableBiMap.toImmutableBiMap(i -> ((Symbol.VarSymbol)((List)methodSymbol.getParameters()).get((int)i.intValue())).name, i -> i));
    }

    public String getDescription(Symbol.MethodSymbol methodSymbol) {
        return "The parameters of this method are inconsistent with the overridden method. A consistent order would be: " + OverridingMethodInconsistentArgumentNamesChecker.getSuggestedSignature(methodSymbol);
    }

    private static String getSuggestedSignature(Symbol.MethodSymbol methodSymbol) {
        return String.format("%s(%s)", methodSymbol.getSimpleName(), OverridingMethodInconsistentArgumentNamesChecker.getSuggestedParameters(methodSymbol));
    }

    private static String getSuggestedParameters(Symbol.MethodSymbol methodSymbol) {
        return methodSymbol.getParameters().stream().map(p -> p.name).collect(Collectors.joining(", "));
    }
}

