/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.predicates.TypePredicate;
import com.google.errorprone.predicates.TypePredicates;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.List;
import java.util.Iterator;
import org.jspecify.annotations.Nullable;

@BugPattern(summary="Passing a literal null to an Optional parameter is almost certainly a mistake. Did you mean to provide an empty Optional?", severity=BugPattern.SeverityLevel.WARNING)
public final class NullOptional
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.NewClassTreeMatcher {
    private static final TypePredicate GUAVA_OPTIONAL = TypePredicates.isDescendantOf((String)"com.google.common.base.Optional");
    private static final TypePredicate OPTIONAL = TypePredicates.anyOf((TypePredicate[])new TypePredicate[]{GUAVA_OPTIONAL, TypePredicates.isDescendantOf((String)"java.util.Optional")});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        this.handleMethodInvocation(ASTHelpers.getSymbol((MethodInvocationTree)tree), tree.getArguments(), state);
        return Description.NO_MATCH;
    }

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        this.handleMethodInvocation(ASTHelpers.getSymbol((NewClassTree)tree), tree.getArguments(), state);
        return Description.NO_MATCH;
    }

    private void handleMethodInvocation(@Nullable Symbol.MethodSymbol symbol, java.util.List<? extends ExpressionTree> arguments, VisitorState state) {
        if (symbol == null) {
            return;
        }
        Iterator parameters = ((List)symbol.getParameters()).iterator();
        Symbol.VarSymbol parameter = null;
        Type parameterType = null;
        for (ExpressionTree expressionTree : arguments) {
            parameter = parameters.hasNext() ? (Symbol.VarSymbol)parameters.next() : parameter;
            parameterType = parameter.type;
            if (symbol.isVarArgs() && !parameters.hasNext()) {
                parameterType = ((Type.ArrayType)parameter.type).elemtype;
            }
            if (expressionTree.getKind() != Tree.Kind.NULL_LITERAL || !OPTIONAL.apply(parameterType, state) || ASTHelpers.hasDirectAnnotationWithSimpleName((Symbol.VarSymbol)parameter, (String)"Nullable")) continue;
            if (Matchers.methodCallInDeclarationOfThrowingRunnable((VisitorState)state)) {
                return;
            }
            SuggestedFix.Builder fix = SuggestedFix.builder();
            fix.replace((Tree)expressionTree, String.format("%s.%s()", SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (Symbol)parameterType.tsym), GUAVA_OPTIONAL.apply(parameterType, state) ? "absent" : "empty"));
            state.reportMatch(this.describeMatch(expressionTree, (Fix)fix.build()));
        }
    }
}

