/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Name;

@BugPattern(severity=BugPattern.SeverityLevel.WARNING, summary="Prefer using when/thenReturn over doReturn/when for additional type safety.")
public final class MockitoDoSetup
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    private static final ImmutableMap<String, String> NAME_MAPPINGS = ImmutableMap.of((Object)"doAnswer", (Object)"thenAnswer", (Object)"doReturn", (Object)"thenReturn", (Object)"doThrow", (Object)"thenThrow");
    private static final Matcher<ExpressionTree> DO_STUBBER = Matchers.staticMethod().onClass("org.mockito.Mockito").namedAnyOf((Iterable)NAME_MAPPINGS.keySet());
    private static final Matcher<ExpressionTree> INSTANCE_WHEN = Matchers.instanceMethod().onDescendantOf("org.mockito.stubbing.Stubber").named("when");
    private static final Matcher<ExpressionTree> SPY = Matchers.staticMethod().onClass("org.mockito.Mockito").named("spy");
    private static final Matcher<ExpressionTree> DO_THROW = Matchers.staticMethod().onClass("org.mockito.Mockito").named("doThrow");
    private static final Matcher<ExpressionTree> STATIC_WHEN = Matchers.staticMethod().onClass("org.mockito.Mockito").named("when");
    private static final Matcher<ExpressionTree> THEN_THROW = Matchers.instanceMethod().onDescendantOf("org.mockito.stubbing.OngoingStubbing").named("thenThrow");

    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        final ImmutableSet<Symbol.VarSymbol> spies = MockitoDoSetup.findSpies(state);
        new BugChecker.SuppressibleTreePathScanner<Void, Void>(this, state){
            final /* synthetic */ MockitoDoSetup this$0;
            {
                this.this$0 = this$0;
                super((BugChecker)this$0, state);
            }

            public Void visitMethodInvocation(MethodInvocationTree tree, Void unused) {
                this.handle(tree);
                return (Void)super.visitMethodInvocation(tree, null);
            }

            private void handle(MethodInvocationTree tree) {
                MethodInvocationTree whenMethod;
                if (!DO_STUBBER.matches((Tree)tree, this.state)) {
                    return;
                }
                TreePath whenPath = this.getCurrentPath().getParentPath().getParentPath();
                Tree whenCall = whenPath.getLeaf();
                if (!(whenCall instanceof MethodInvocationTree) || !INSTANCE_WHEN.matches((Tree)(whenMethod = (MethodInvocationTree)whenCall), this.state)) {
                    return;
                }
                if (this.isSpy(whenMethod.getArguments().get(0))) {
                    return;
                }
                Tree tree2 = whenPath.getParentPath().getParentPath().getLeaf();
                if (!(tree2 instanceof MethodInvocationTree)) {
                    return;
                }
                MethodInvocationTree mockedMethod = (MethodInvocationTree)tree2;
                if (ASTHelpers.isSameType((Type)ASTHelpers.getSymbol((MethodInvocationTree)mockedMethod).getReturnType(), (Type)this.state.getSymtab().voidType, (VisitorState)this.state)) {
                    return;
                }
                SuggestedFix.Builder fix = SuggestedFix.builder();
                String when = SuggestedFixes.qualifyStaticImport((String)"org.mockito.Mockito.when", (SuggestedFix.Builder)fix, (VisitorState)this.state);
                fix.replace((Tree)whenMethod.getMethodSelect(), when).replace(this.state.getEndPosition((Tree)whenMethod) - 1, this.state.getEndPosition((Tree)whenMethod), "").postfixWith((Tree)mockedMethod, String.format(").%s(%s)", NAME_MAPPINGS.get((Object)((Name)ASTHelpers.getSymbol((MethodInvocationTree)tree).getSimpleName()).toString()), MockitoDoSetup.getParameterSource(tree, this.state)));
                this.state.reportMatch(this.this$0.describeMatch(tree, (Fix)fix.build()));
            }

            private boolean isSpy(ExpressionTree tree) {
                Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
                return symbol != null && (spies.contains((Object)symbol) || ASTHelpers.hasAnnotation((Symbol)symbol, (String)"org.mockito.Spy", (VisitorState)this.state));
            }
        }.scan(state.getPath(), null);
        return Description.NO_MATCH;
    }

    private static String getParameterSource(MethodInvocationTree tree, VisitorState state) {
        return state.getSourceCode().subSequence(ASTHelpers.getStartPosition((Tree)tree.getArguments().get(0)), state.getEndPosition((Tree)Iterables.getLast(tree.getArguments()))).toString();
    }

    private static ImmutableSet<Symbol.VarSymbol> findSpies(final VisitorState state) {
        final ImmutableSet.Builder spiesOrThrows = ImmutableSet.builder();
        new TreePathScanner<Void, Void>(){

            @Override
            public Void visitVariable(VariableTree tree, Void unused) {
                if (tree.getInitializer() != null && SPY.matches((Tree)tree.getInitializer(), state)) {
                    spiesOrThrows.add((Object)ASTHelpers.getSymbol((VariableTree)tree));
                }
                return (Void)super.visitVariable(tree, null);
            }

            @Override
            public Void visitMethodInvocation(MethodInvocationTree tree, Void unused) {
                ExpressionTree mock;
                Symbol mockSymbol;
                ExpressionTree receiver;
                Symbol.VarSymbol varSymbol;
                Symbol whenTarget;
                MethodInvocationTree methodInvocationTree;
                Tree whenCall;
                if (DO_THROW.matches((Tree)tree, state) && (whenCall = this.getCurrentPath().getParentPath().getParentPath().getLeaf()) instanceof MethodInvocationTree && INSTANCE_WHEN.matches((Tree)(methodInvocationTree = (MethodInvocationTree)whenCall), state) && (whenTarget = ASTHelpers.getSymbol((Tree)methodInvocationTree.getArguments().get(0))) instanceof Symbol.VarSymbol) {
                    varSymbol = (Symbol.VarSymbol)whenTarget;
                    spiesOrThrows.add((Object)varSymbol);
                }
                if (THEN_THROW.matches((Tree)tree, state) && STATIC_WHEN.matches((Tree)(receiver = ASTHelpers.getReceiver((ExpressionTree)tree)), state) && (mockSymbol = ASTHelpers.getSymbol((Tree)(mock = ASTHelpers.getReceiver((ExpressionTree)((MethodInvocationTree)receiver).getArguments().get(0))))) instanceof Symbol.VarSymbol) {
                    varSymbol = (Symbol.VarSymbol)mockSymbol;
                    spiesOrThrows.add((Object)varSymbol);
                }
                return (Void)super.visitMethodInvocation(tree, null);
            }

            @Override
            public Void visitAssignment(AssignmentTree tree, Void unused) {
                Symbol symbol;
                if (SPY.matches((Tree)tree.getExpression(), state) && (symbol = ASTHelpers.getSymbol((Tree)tree.getVariable())) instanceof Symbol.VarSymbol) {
                    Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)symbol;
                    spiesOrThrows.add((Object)varSymbol);
                }
                return (Void)super.visitAssignment(tree, null);
            }
        }.scan(state.getPath().getCompilationUnit(), null);
        return spiesOrThrows.build();
    }
}

