/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.formatstring.LenientFormatStringUtils;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.util.List;
import java.util.regex.Pattern;

@BugPattern(altNames={"PreconditionsExpensiveString"}, summary="String.format is passed to a lenient formatting method, which can be unwrapped to improve efficiency.", severity=BugPattern.SeverityLevel.WARNING)
public class ExpensiveLenientFormatString
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> STRING_FORMAT_MATCHER = Matchers.staticMethod().onClass("java.lang.String").named("format");
    private static final Pattern INVALID_FORMAT_CHARACTERS = Pattern.compile("%[^%s]");

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        int lenientFormatStringPosition = LenientFormatStringUtils.getLenientFormatStringPosition(tree, state);
        if (lenientFormatStringPosition == -1) {
            return Description.NO_MATCH;
        }
        if (tree.getArguments().size() < lenientFormatStringPosition + 1) {
            return Description.NO_MATCH;
        }
        ExpressionTree argument = tree.getArguments().get(lenientFormatStringPosition);
        if (!STRING_FORMAT_MATCHER.matches((Tree)argument, state)) {
            return Description.NO_MATCH;
        }
        MethodInvocationTree stringFormat = (MethodInvocationTree)argument;
        List<? extends ExpressionTree> stringFormatArguments = stringFormat.getArguments();
        String formatString = (String)ASTHelpers.constValue((Tree)stringFormatArguments.get(0), String.class);
        if (formatString == null) {
            return Description.NO_MATCH;
        }
        if (INVALID_FORMAT_CHARACTERS.matcher(formatString).find()) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(stringFormat, (Fix)SuggestedFix.builder().replace(ASTHelpers.getStartPosition((Tree)stringFormat), ASTHelpers.getStartPosition((Tree)stringFormatArguments.get(0)), "").replace(state.getEndPosition((Tree)Iterables.getLast(stringFormatArguments)), state.getEndPosition((Tree)stringFormat), "").build());
    }
}

