/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;

@BugPattern(summary="The result of this unary operation on a lambda parameter is discarded", severity=BugPattern.SeverityLevel.ERROR)
public class DiscardedPostfixExpression
extends BugChecker
implements BugChecker.UnaryTreeMatcher {
    public Description matchUnary(UnaryTree tree, VisitorState state) {
        switch (tree.getKind()) {
            case POSTFIX_INCREMENT: 
            case POSTFIX_DECREMENT: {
                break;
            }
            default: {
                return Description.NO_MATCH;
            }
        }
        Tree parent = state.getPath().getParentPath().getLeaf();
        if (!(parent instanceof LambdaExpressionTree)) {
            return Description.NO_MATCH;
        }
        JCTree.JCLambda lambda = (JCTree.JCLambda)parent;
        Symbol sym = ASTHelpers.getSymbol((Tree)tree.getExpression());
        if (lambda.getParameters().stream().noneMatch(p -> ASTHelpers.getSymbol((VariableTree)p) == sym)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree, (Fix)SuggestedFix.replace((Tree)tree, (String)String.format("%s %s 1", state.getSourceForNode((Tree)tree.getExpression()), tree.getKind() == Tree.Kind.POSTFIX_INCREMENT ? "+" : "-")));
    }
}

