/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.auto.value.AutoBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableTable;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AutoBuilder_DangerousLiteralNullChecker_NullReplacementRule_Builder;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Name;
import java.io.Serializable;

@BugPattern(name="DangerousLiteralNull", summary="This method is null-hostile: passing a null literal to it is always wrong", severity=BugPattern.SeverityLevel.ERROR)
public class DangerousLiteralNullChecker
extends BugChecker
implements BugChecker.LiteralTreeMatcher {
    private static final Supplier<ImmutableList<NullReplacementRule>> RULES = VisitorState.memoize((Supplier & Serializable)state -> ImmutableList.of((Object)NullReplacementRule.builder().setKlass(state.getName("java.util.Optional")).setMethod(state.getName("orElseGet")).setReplacementBody("orElse(null)").build(), (Object)NullReplacementRule.builder().setKlass(state.getName("java.util.Optional")).setMethod(state.getName("orElseThrow")).setReplacementBody("orElseThrow(NullPointerException::new)").build()));
    private static final Supplier<ImmutableTable<Name, Name, String>> RULE_LOOKUP = VisitorState.memoize((Supplier & Serializable)state -> {
        ImmutableTable.Builder builder = ImmutableTable.builder();
        for (NullReplacementRule rule : (ImmutableList)RULES.get(state)) {
            builder.put((Object)rule.klass(), (Object)rule.method(), (Object)rule.replacementBody());
        }
        return builder.buildOrThrow();
    });

    public Description matchLiteral(LiteralTree tree, VisitorState state) {
        if (!Matchers.nullLiteral().matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        Tree parent = state.getPath().getParentPath().getLeaf();
        if (!(parent instanceof MethodInvocationTree)) {
            return Description.NO_MATCH;
        }
        MethodInvocationTree invocation = (MethodInvocationTree)parent;
        if (invocation.getArguments().size() != 1) {
            return Description.NO_MATCH;
        }
        Symbol.MethodSymbol sym = ASTHelpers.getSymbol((MethodInvocationTree)invocation);
        String newBody = (String)((ImmutableTable)RULE_LOOKUP.get(state)).get((Object)sym.owner.getQualifiedName(), (Object)sym.name);
        if (newBody == null) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(invocation, (Fix)SuggestedFix.replace((Tree)invocation, (String)String.format("%s.%s", state.getSourceForNode((Tree)ASTHelpers.getReceiver((ExpressionTree)invocation)), newBody)));
    }

    record NullReplacementRule(Name klass, Name method, String replacementBody) {
        private static Builder builder() {
            return new AutoBuilder_DangerousLiteralNullChecker_NullReplacementRule_Builder();
        }

        @AutoBuilder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setKlass(Name var1);

            abstract Builder setMethod(Name var1);

            abstract Builder setReplacementBody(String var1);

            abstract NullReplacementRule build();
        }
    }
}

