/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.constant.AnyMethodrefConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.optimize.info.ContainsConstructorsMarker;

public class NoConstructorReferenceReplacer
implements InstructionVisitor,
ConstantVisitor {
    private final CodeAttributeEditor codeAttributeEditor;
    private final InstructionVisitor extraReferenceVisitor;
    private boolean containsConstructors;

    public NoConstructorReferenceReplacer(CodeAttributeEditor codeAttributeEditor) {
        this(codeAttributeEditor, null);
    }

    public NoConstructorReferenceReplacer(CodeAttributeEditor codeAttributeEditor, InstructionVisitor extraReferenceVisitor) {
        this.codeAttributeEditor = codeAttributeEditor;
        this.extraReferenceVisitor = extraReferenceVisitor;
    }

    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
    }

    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        switch (constantInstruction.opcode) {
            case -76: 
            case -75: 
            case -74: 
            case -73: {
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, (ConstantVisitor)this);
                if (this.containsConstructors) break;
                this.codeAttributeEditor.replaceInstruction(offset, new Instruction[]{new SimpleInstruction(1), new SimpleInstruction(-65)});
                if (this.extraReferenceVisitor == null) break;
                this.extraReferenceVisitor.visitConstantInstruction(clazz, method, codeAttribute, offset, constantInstruction);
            }
        }
    }

    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    public void visitFieldrefConstant(Clazz clazz, FieldrefConstant fieldrefConstant) {
        Clazz referencedClass = fieldrefConstant.referencedClass;
        this.containsConstructors = referencedClass == null || ContainsConstructorsMarker.containsConstructors(referencedClass);
    }

    public void visitAnyMethodrefConstant(Clazz clazz, AnyMethodrefConstant anyMethodrefConstant) {
        Clazz referencedClass = anyMethodrefConstant.referencedClass;
        this.containsConstructors = referencedClass == null || (referencedClass.getAccessFlags() & 0x200) != 0 || ContainsConstructorsMarker.containsConstructors(referencedClass);
    }
}

