/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.types;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.turbine.binder.bound.TypeBoundClass;
import com.google.turbine.binder.sym.TyVarSymbol;
import com.google.turbine.type.Type;
import java.util.function.Function;

public final class Erasure {
    public static Type erase(Type ty, Function<TyVarSymbol, TypeBoundClass.TyVarInfo> tenv) {
        return switch (ty.tyKind()) {
            default -> throw new MatchException(null, null);
            case Type.TyKind.CLASS_TY -> Erasure.eraseClassTy((Type.ClassTy)ty);
            case Type.TyKind.ARRAY_TY -> Erasure.eraseArrayTy((Type.ArrayTy)ty, tenv);
            case Type.TyKind.TY_VAR -> Erasure.eraseTyVar((Type.TyVar)ty, tenv);
            case Type.TyKind.INTERSECTION_TY -> Erasure.eraseIntersectionTy((Type.IntersectionTy)ty, tenv);
            case Type.TyKind.WILD_TY -> Erasure.eraseWildTy((Type.WildTy)ty, tenv);
            case Type.TyKind.METHOD_TY -> Erasure.erasureMethodTy((Type.MethodTy)ty, tenv);
            case Type.TyKind.PRIM_TY, Type.TyKind.VOID_TY, Type.TyKind.ERROR_TY, Type.TyKind.NONE_TY -> ty;
        };
    }

    private static ImmutableList<Type> erase(ImmutableList<Type> types, Function<TyVarSymbol, TypeBoundClass.TyVarInfo> tenv) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (Type type : types) {
            result.add((Object)Erasure.erase(type, tenv));
        }
        return result.build();
    }

    private static Type eraseIntersectionTy(Type.IntersectionTy ty, Function<TyVarSymbol, TypeBoundClass.TyVarInfo> tenv) {
        return ty.bounds().isEmpty() ? Type.ClassTy.OBJECT : Erasure.erase((Type)ty.bounds().getFirst(), tenv);
    }

    private static Type eraseTyVar(Type.TyVar ty, Function<TyVarSymbol, TypeBoundClass.TyVarInfo> tenv) {
        TypeBoundClass.TyVarInfo info = tenv.apply(ty.sym());
        return Erasure.erase(info.upperBound(), tenv);
    }

    private static Type.ArrayTy eraseArrayTy(Type.ArrayTy ty, Function<TyVarSymbol, TypeBoundClass.TyVarInfo> tenv) {
        return Type.ArrayTy.create(Erasure.erase(ty.elementType(), tenv), ty.annos());
    }

    public static Type.ClassTy eraseClassTy(Type.ClassTy ty) {
        ImmutableList.Builder classes = ImmutableList.builder();
        for (Type.ClassTy.SimpleClassTy c : ty.classes()) {
            if (c.targs().isEmpty()) {
                classes.add((Object)c);
                continue;
            }
            classes.add((Object)Type.ClassTy.SimpleClassTy.create(c.sym(), (ImmutableList<Type>)ImmutableList.of(), c.annos()));
        }
        return Type.ClassTy.create((Iterable<Type.ClassTy.SimpleClassTy>)classes.build());
    }

    private static Type eraseWildTy(Type.WildTy ty, Function<TyVarSymbol, TypeBoundClass.TyVarInfo> tenv) {
        return switch (ty.boundKind()) {
            default -> throw new MatchException(null, null);
            case Type.WildTy.BoundKind.NONE, Type.WildTy.BoundKind.LOWER -> Type.ClassTy.OBJECT;
            case Type.WildTy.BoundKind.UPPER -> Erasure.erase(ty.bound(), tenv);
        };
    }

    private static Type erasureMethodTy(Type.MethodTy ty, Function<TyVarSymbol, TypeBoundClass.TyVarInfo> tenv) {
        return Type.MethodTy.create((ImmutableSet<TyVarSymbol>)ImmutableSet.of(), Erasure.erase(ty.returnType(), tenv), ty.receiverType() != null ? Erasure.erase(ty.receiverType(), tenv) : null, Erasure.erase(ty.parameters(), tenv), Erasure.erase(ty.thrown(), tenv));
    }

    private Erasure() {
    }
}

