/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.processing;

import com.google.common.base.Joiner;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.turbine.binder.bound.TypeBoundClass;
import com.google.turbine.binder.sym.PackageSymbol;
import com.google.turbine.binder.sym.TyVarSymbol;
import com.google.turbine.model.TurbineConstantTypeKind;
import com.google.turbine.model.TurbineTyKind;
import com.google.turbine.processing.ModelFactory;
import com.google.turbine.processing.TurbineAnnotationMirror;
import com.google.turbine.processing.TurbineAnnotationProxy;
import com.google.turbine.processing.TurbineTypes;
import com.google.turbine.type.AnnoInfo;
import com.google.turbine.type.Type;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Objects;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.type.WildcardType;
import org.jspecify.annotations.Nullable;

public abstract class TurbineTypeMirror
implements TypeMirror {
    protected final ModelFactory factory;

    protected TurbineTypeMirror(ModelFactory factory) {
        this.factory = Objects.requireNonNull(factory);
    }

    protected abstract ImmutableList<AnnoInfo> annos();

    @Override
    public final List<? extends AnnotationMirror> getAnnotationMirrors() {
        ImmutableList.Builder result = ImmutableList.builder();
        for (AnnoInfo anno : this.annos()) {
            result.add((Object)TurbineAnnotationMirror.create(this.factory, anno));
        }
        return result.build();
    }

    @Override
    public final <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return TurbineAnnotationProxy.getAnnotation(this.factory, this.annos(), annotationType);
    }

    @Override
    public final <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationType) {
        return TurbineAnnotationProxy.getAnnotationsByType((ModelFactory)this.factory, this.annos(), annotationType);
    }

    public abstract Type asTurbineType();

    @Override
    public String toString() {
        return this.asTurbineType().toString();
    }

    public static class TurbineExecutableType
    extends TurbineTypeMirror
    implements ExecutableType {
        public final Type.MethodTy type;

        @Override
        public Type.MethodTy asTurbineType() {
            return this.type;
        }

        TurbineExecutableType(ModelFactory factory, Type.MethodTy type) {
            super(factory);
            this.type = type;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(@Nullable Object obj) {
            if (!(obj instanceof TurbineExecutableType)) return false;
            TurbineExecutableType turbineExecutableType = (TurbineExecutableType)obj;
            if (!this.type.equals(turbineExecutableType.type)) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return this.type.hashCode();
        }

        @Override
        public List<? extends TypeVariable> getTypeVariables() {
            ImmutableList.Builder result = ImmutableList.builder();
            for (TyVarSymbol tyVar : this.type.tyParams()) {
                result.add((Object)((TypeVariable)this.factory.asTypeMirror(Type.TyVar.create(tyVar, (ImmutableList<AnnoInfo>)ImmutableList.of()))));
            }
            return result.build();
        }

        @Override
        public TypeMirror getReturnType() {
            return this.factory.asTypeMirror(this.type.returnType());
        }

        @Override
        public List<? extends TypeMirror> getParameterTypes() {
            return this.factory.asTypeMirrors((Iterable<? extends Type>)this.type.parameters());
        }

        @Override
        public TypeMirror getReceiverType() {
            return this.type.receiverType() != null ? this.factory.asTypeMirror(this.type.receiverType()) : this.factory.noType();
        }

        @Override
        public List<? extends TypeMirror> getThrownTypes() {
            return this.factory.asTypeMirrors((Iterable<? extends Type>)this.type.thrown());
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.EXECUTABLE;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visitExecutable(this, p);
        }

        @Override
        protected ImmutableList<AnnoInfo> annos() {
            return ImmutableList.of();
        }
    }

    public static class TurbineNullType
    extends TurbineTypeMirror
    implements NullType {
        @Override
        public Type asTurbineType() {
            return Type.PrimTy.create(TurbineConstantTypeKind.NULL, (ImmutableList<AnnoInfo>)ImmutableList.of());
        }

        public TurbineNullType(ModelFactory factory) {
            super(factory);
        }

        @Override
        protected ImmutableList<AnnoInfo> annos() {
            return ImmutableList.of();
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            return obj instanceof NullType;
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.NULL;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visitNull(this, p);
        }
    }

    static class TurbineIntersectionType
    extends TurbineTypeMirror
    implements IntersectionType {
        private final Type.IntersectionTy type;
        final Supplier<ImmutableList<TypeMirror>> bounds;

        @Override
        public Type asTurbineType() {
            return this.type;
        }

        TurbineIntersectionType(ModelFactory factory, Type.IntersectionTy type) {
            super(factory);
            this.bounds = this.factory.memoize(new Supplier<ImmutableList<TypeMirror>>(){

                public ImmutableList<TypeMirror> get() {
                    return factory.asTypeMirrors((Iterable<? extends Type>)TurbineTypes.getBounds(factory, type));
                }
            });
            this.type = type;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(@Nullable Object obj) {
            if (!(obj instanceof TurbineIntersectionType)) return false;
            TurbineIntersectionType turbineIntersectionType = (TurbineIntersectionType)obj;
            if (!this.type.equals(turbineIntersectionType.type)) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return this.type.hashCode();
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.INTERSECTION;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visitIntersection(this, p);
        }

        @Override
        public List<? extends TypeMirror> getBounds() {
            return (List)this.bounds.get();
        }

        @Override
        public String toString() {
            return Joiner.on((char)'&').join(this.getBounds());
        }

        @Override
        protected ImmutableList<AnnoInfo> annos() {
            return ImmutableList.of();
        }
    }

    static class TurbineWildcardType
    extends TurbineTypeMirror
    implements WildcardType {
        private final Type.WildTy type;

        @Override
        public Type asTurbineType() {
            return this.type;
        }

        public TurbineWildcardType(ModelFactory factory, Type.WildTy type) {
            super(factory);
            this.type = type;
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.WILDCARD;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visitWildcard(this, p);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(@Nullable Object obj) {
            if (!(obj instanceof TurbineWildcardType)) return false;
            TurbineWildcardType turbineWildcardType = (TurbineWildcardType)obj;
            if (!this.type.equals(turbineWildcardType.type)) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return this.type.hashCode();
        }

        @Override
        public TypeMirror getExtendsBound() {
            return this.type.boundKind() == Type.WildTy.BoundKind.UPPER ? this.factory.asTypeMirror(this.type.bound()) : null;
        }

        @Override
        public TypeMirror getSuperBound() {
            return this.type.boundKind() == Type.WildTy.BoundKind.LOWER ? this.factory.asTypeMirror(this.type.bound()) : null;
        }

        @Override
        protected ImmutableList<AnnoInfo> annos() {
            return this.type.annotations();
        }
    }

    static class TurbineTypeVariable
    extends TurbineTypeMirror
    implements TypeVariable {
        private final Type.TyVar type;
        private final Supplier<TypeBoundClass.TyVarInfo> info;

        @Override
        public int hashCode() {
            return this.type.hashCode();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(@Nullable Object obj) {
            if (!(obj instanceof TurbineTypeVariable)) return false;
            TurbineTypeVariable turbineTypeVariable = (TurbineTypeVariable)obj;
            if (!this.type.equals(turbineTypeVariable.type)) return false;
            return true;
        }

        @Override
        public Type asTurbineType() {
            return this.type;
        }

        private TypeBoundClass.TyVarInfo info() {
            return (TypeBoundClass.TyVarInfo)this.info.get();
        }

        TurbineTypeVariable(ModelFactory factory, Type.TyVar type) {
            super(factory);
            this.info = this.factory.memoize(new Supplier<TypeBoundClass.TyVarInfo>(){

                public TypeBoundClass.TyVarInfo get() {
                    return factory.getTyVarInfo(type.sym());
                }
            });
            this.type = type;
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.TYPEVAR;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visitTypeVariable(this, p);
        }

        @Override
        public Element asElement() {
            return this.factory.typeParameterElement(this.type.sym());
        }

        @Override
        public TypeMirror getUpperBound() {
            return this.factory.asTypeMirror(this.info().upperBound());
        }

        @Override
        public TypeMirror getLowerBound() {
            return this.info().lowerBound() != null ? this.factory.asTypeMirror(this.info().lowerBound()) : this.factory.nullType();
        }

        @Override
        protected ImmutableList<AnnoInfo> annos() {
            return this.type.annos();
        }
    }

    static class TurbineVoidType
    extends TurbineTypeMirror
    implements NoType {
        @Override
        public Type asTurbineType() {
            return Type.VOID;
        }

        TurbineVoidType(ModelFactory factory) {
            super(factory);
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.VOID;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visitNoType(this, p);
        }

        @Override
        protected ImmutableList<AnnoInfo> annos() {
            return ImmutableList.of();
        }
    }

    static class TurbineNoType
    extends TurbineTypeMirror
    implements NoType {
        @Override
        public Type asTurbineType() {
            return Type.NONE;
        }

        TurbineNoType(ModelFactory factory) {
            super(factory);
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.NONE;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visitNoType(this, p);
        }

        @Override
        public boolean equals(@Nullable Object other) {
            return other instanceof TurbineNoType;
        }

        @Override
        public int hashCode() {
            return this.getKind().hashCode();
        }

        @Override
        protected ImmutableList<AnnoInfo> annos() {
            return ImmutableList.of();
        }
    }

    static class TurbinePackageType
    extends TurbineTypeMirror
    implements NoType {
        final PackageSymbol symbol;

        @Override
        public Type asTurbineType() {
            throw new UnsupportedOperationException();
        }

        TurbinePackageType(ModelFactory factory, PackageSymbol symbol) {
            super(factory);
            this.symbol = symbol;
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.PACKAGE;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visitNoType(this, p);
        }

        @Override
        public String toString() {
            return this.symbol.toString();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(@Nullable Object other) {
            if (!(other instanceof TurbinePackageType)) return false;
            TurbinePackageType turbinePackageType = (TurbinePackageType)other;
            if (!this.symbol.equals(turbinePackageType.symbol)) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return this.symbol.hashCode();
        }

        @Override
        protected ImmutableList<AnnoInfo> annos() {
            return ImmutableList.of();
        }
    }

    static class TurbineErrorType
    extends TurbineTypeMirror
    implements ErrorType {
        private final Type.ErrorTy type;

        public TurbineErrorType(ModelFactory factory, Type.ErrorTy type) {
            super(factory);
            this.type = type;
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.ERROR;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visitError(this, p);
        }

        @Override
        protected ImmutableList<AnnoInfo> annos() {
            return ImmutableList.of();
        }

        @Override
        public Type asTurbineType() {
            return this.type;
        }

        @Override
        public Element asElement() {
            return this.factory.noElement(this.type.name());
        }

        @Override
        public TypeMirror getEnclosingType() {
            return this.factory.noType();
        }

        @Override
        public List<? extends TypeMirror> getTypeArguments() {
            return this.factory.asTypeMirrors((Iterable<? extends Type>)this.type.targs());
        }
    }

    static class TurbineArrayType
    extends TurbineTypeMirror
    implements ArrayType {
        private final Type.ArrayTy type;

        @Override
        public Type asTurbineType() {
            return this.type;
        }

        TurbineArrayType(ModelFactory factory, Type.ArrayTy type) {
            super(factory);
            this.type = type;
        }

        @Override
        public TypeMirror getComponentType() {
            return this.factory.asTypeMirror(this.type.elementType());
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.ARRAY;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visitArray(this, p);
        }

        @Override
        protected ImmutableList<AnnoInfo> annos() {
            return this.type.annos();
        }
    }

    static class TurbineDeclaredType
    extends TurbineTypeMirror
    implements DeclaredType {
        private final Type.ClassTy type;
        final Supplier<Element> element;
        final Supplier<TypeMirror> enclosing;
        final Supplier<ImmutableList<TypeMirror>> typeArguments;

        @Override
        public int hashCode() {
            return this.type.sym().hashCode();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(@Nullable Object obj) {
            if (!(obj instanceof TurbineDeclaredType)) return false;
            TurbineDeclaredType turbineDeclaredType = (TurbineDeclaredType)obj;
            if (!this.type.equals(turbineDeclaredType.type)) return false;
            return true;
        }

        @Override
        public Type.ClassTy asTurbineType() {
            return this.type;
        }

        TurbineDeclaredType(ModelFactory factory, Type.ClassTy type) {
            super(factory);
            this.element = this.factory.memoize(new Supplier<Element>(){

                public Element get() {
                    return factory.typeElement(type.sym());
                }
            });
            this.enclosing = this.factory.memoize(new Supplier<TypeMirror>(){

                public TypeMirror get() {
                    TypeBoundClass info = factory.getSymbol(type.sym());
                    if (info != null && info.owner() != null && (info.access() & 8) == 0 && info.kind() == TurbineTyKind.CLASS) {
                        if (type.classes().size() > 1) {
                            return factory.asTypeMirror(Type.ClassTy.create((Iterable<Type.ClassTy.SimpleClassTy>)type.classes().subList(0, type.classes().size() - 1)));
                        }
                        return factory.asTypeMirror(Type.ClassTy.asNonParametricClassTy(info.owner()));
                    }
                    return factory.noType();
                }
            });
            this.typeArguments = this.factory.memoize(new Supplier<ImmutableList<TypeMirror>>(){

                public ImmutableList<TypeMirror> get() {
                    return factory.asTypeMirrors((Iterable<? extends Type>)((Type.ClassTy.SimpleClassTy)type.classes().getLast()).targs());
                }
            });
            this.type = type;
        }

        @Override
        public Element asElement() {
            return (Element)this.element.get();
        }

        @Override
        public TypeMirror getEnclosingType() {
            return (TypeMirror)this.enclosing.get();
        }

        @Override
        public List<? extends TypeMirror> getTypeArguments() {
            return (List)this.typeArguments.get();
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.DECLARED;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visitDeclared(this, p);
        }

        public Type.ClassTy type() {
            return this.type;
        }

        @Override
        protected ImmutableList<AnnoInfo> annos() {
            return ((Type.ClassTy.SimpleClassTy)this.type.classes().getLast()).annos();
        }
    }

    static class TurbinePrimitiveType
    extends TurbineTypeMirror
    implements PrimitiveType {
        public final Type.PrimTy type;

        @Override
        public Type asTurbineType() {
            return this.type;
        }

        TurbinePrimitiveType(ModelFactory factory, Type.PrimTy type) {
            super(factory);
            if (type.primkind() == TurbineConstantTypeKind.STRING) {
                throw new AssertionError(type);
            }
            this.type = type;
        }

        @Override
        public TypeKind getKind() {
            return switch (this.type.primkind()) {
                default -> throw new MatchException(null, null);
                case TurbineConstantTypeKind.CHAR -> TypeKind.CHAR;
                case TurbineConstantTypeKind.SHORT -> TypeKind.SHORT;
                case TurbineConstantTypeKind.INT -> TypeKind.INT;
                case TurbineConstantTypeKind.LONG -> TypeKind.LONG;
                case TurbineConstantTypeKind.FLOAT -> TypeKind.FLOAT;
                case TurbineConstantTypeKind.DOUBLE -> TypeKind.DOUBLE;
                case TurbineConstantTypeKind.BOOLEAN -> TypeKind.BOOLEAN;
                case TurbineConstantTypeKind.BYTE -> TypeKind.BYTE;
                case TurbineConstantTypeKind.NULL -> TypeKind.NULL;
                case TurbineConstantTypeKind.STRING -> throw new AssertionError((Object)this.type.primkind());
            };
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visitPrimitive(this, p);
        }

        @Override
        protected ImmutableList<AnnoInfo> annos() {
            return this.type.annos();
        }
    }
}

