/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.bytecode;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.FormatMethod;
import com.google.turbine.bytecode.ByteReader;
import com.google.turbine.bytecode.ClassFile;
import com.google.turbine.bytecode.ConstantPoolReader;
import com.google.turbine.model.Const;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public class ClassReader {
    private final @Nullable String path;
    private final ByteReader reader;

    @Deprecated
    public static ClassFile read(byte[] bytes) {
        return ClassReader.read(null, bytes);
    }

    public static ClassFile read(@Nullable String path, byte[] bytes) {
        return new ClassReader(path, bytes).read();
    }

    private ClassReader(@Nullable String path, byte[] bytes) {
        this.path = path;
        this.reader = new ByteReader(bytes, 0);
    }

    @CheckReturnValue
    @FormatMethod
    Error error(String format, Object ... args) {
        StringBuilder sb = new StringBuilder();
        if (this.path != null) {
            sb.append(this.path).append(": ");
        }
        sb.append(String.format(format, args));
        return new AssertionError((Object)sb.toString());
    }

    private ClassFile read() {
        int magic = this.reader.u4();
        if (magic != -889275714) {
            throw this.error("bad magic: 0x%x", magic);
        }
        int minorVersion = this.reader.u2();
        int majorVersion = this.reader.u2();
        if (majorVersion < 45) {
            throw this.error("bad version: %d.%d", majorVersion, minorVersion);
        }
        ConstantPoolReader constantPool = ConstantPoolReader.readConstantPool(this.reader);
        int accessFlags = this.reader.u2();
        String thisClass = constantPool.classInfo(this.reader.u2());
        int superClassIndex = this.reader.u2();
        String superClass = superClassIndex != 0 ? constantPool.classInfo(superClassIndex) : null;
        int interfacesCount = this.reader.u2();
        ArrayList<String> interfaces = new ArrayList<String>();
        for (int i = 0; i < interfacesCount; ++i) {
            interfaces.add(constantPool.classInfo(this.reader.u2()));
        }
        List<ClassFile.FieldInfo> fieldinfos = this.readFields(constantPool);
        List<ClassFile.MethodInfo> methodinfos = this.readMethods(constantPool);
        String signature = null;
        Object innerclasses = ImmutableList.of();
        ImmutableList.Builder annotations = ImmutableList.builder();
        ImmutableList.Builder typeAnnotations = ImmutableList.builder();
        ClassFile.ModuleInfo module = null;
        String transitiveJar = null;
        ClassFile.RecordInfo record = null;
        int attributesCount = this.reader.u2();
        block23: for (int j = 0; j < attributesCount; ++j) {
            String name;
            int attributeNameIndex = this.reader.u2();
            switch (name = constantPool.utf8(attributeNameIndex)) {
                case "RuntimeInvisibleAnnotations": {
                    this.readAnnotations((ImmutableList.Builder<ClassFile.AnnotationInfo>)annotations, constantPool, ClassFile.AnnotationInfo.RuntimeVisibility.INVISIBLE);
                    continue block23;
                }
                case "RuntimeVisibleAnnotations": {
                    this.readAnnotations((ImmutableList.Builder<ClassFile.AnnotationInfo>)annotations, constantPool, ClassFile.AnnotationInfo.RuntimeVisibility.VISIBLE);
                    continue block23;
                }
                case "RuntimeInvisibleTypeAnnotations": {
                    this.readTypeAnnotations((ImmutableList.Builder<ClassFile.TypeAnnotationInfo>)typeAnnotations, constantPool, ClassFile.AnnotationInfo.RuntimeVisibility.INVISIBLE);
                    continue block23;
                }
                case "RuntimeVisibleTypeAnnotations": {
                    this.readTypeAnnotations((ImmutableList.Builder<ClassFile.TypeAnnotationInfo>)typeAnnotations, constantPool, ClassFile.AnnotationInfo.RuntimeVisibility.VISIBLE);
                    continue block23;
                }
                case "Signature": {
                    signature = this.readSignature(constantPool);
                    continue block23;
                }
                case "InnerClasses": {
                    innerclasses = this.readInnerClasses(constantPool);
                    continue block23;
                }
                case "Module": {
                    module = this.readModule(constantPool);
                    continue block23;
                }
                case "TurbineTransitiveJar": {
                    transitiveJar = this.readTurbineTransitiveJar(constantPool);
                    continue block23;
                }
                case "Record": {
                    record = this.readRecord(constantPool);
                    continue block23;
                }
                default: {
                    this.reader.skip(this.reader.u4());
                }
            }
        }
        return new ClassFile(accessFlags, majorVersion, thisClass, signature, superClass, interfaces, (List<String>)ImmutableList.of(), methodinfos, fieldinfos, (List<ClassFile.AnnotationInfo>)annotations.build(), (List<ClassFile.InnerClass>)innerclasses, (ImmutableList<ClassFile.TypeAnnotationInfo>)typeAnnotations.build(), module, null, (ImmutableList<String>)ImmutableList.of(), record, transitiveJar);
    }

    private String readSignature(ConstantPoolReader constantPool) {
        int unusedLength = this.reader.u4();
        String signature = constantPool.utf8(this.reader.u2());
        return signature;
    }

    private List<ClassFile.InnerClass> readInnerClasses(ConstantPoolReader constantPool) {
        int unusedLength = this.reader.u4();
        int numberOfClasses = this.reader.u2();
        ArrayList<ClassFile.InnerClass> innerclasses = new ArrayList<ClassFile.InnerClass>();
        for (int i = 0; i < numberOfClasses; ++i) {
            int innerClassInfoIndex = this.reader.u2();
            String innerClass = constantPool.classInfo(innerClassInfoIndex);
            int outerClassInfoIndex = this.reader.u2();
            String outerClass = outerClassInfoIndex != 0 ? constantPool.classInfo(outerClassInfoIndex) : null;
            int innerNameIndex = this.reader.u2();
            String innerName = innerNameIndex != 0 ? constantPool.utf8(innerNameIndex) : null;
            int innerClassAccessFlags = this.reader.u2();
            if (innerName == null || outerClass == null) continue;
            innerclasses.add(new ClassFile.InnerClass(innerClass, outerClass, innerName, innerClassAccessFlags));
        }
        return innerclasses;
    }

    private void readAnnotations(ImmutableList.Builder<ClassFile.AnnotationInfo> annotations, ConstantPoolReader constantPool, ClassFile.AnnotationInfo.RuntimeVisibility runtimeVisibility) {
        int unusedLength = this.reader.u4();
        int numAnnotations = this.reader.u2();
        for (int n = 0; n < numAnnotations; ++n) {
            annotations.add((Object)this.readAnnotation(constantPool, runtimeVisibility));
        }
    }

    public void readParameterAnnotations(List<ImmutableList.Builder<ClassFile.AnnotationInfo>> annotations, ConstantPoolReader constantPool, ClassFile.AnnotationInfo.RuntimeVisibility runtimeVisibility) {
        int unusedLength = this.reader.u4();
        int numParameters = this.reader.u1();
        while (annotations.size() < numParameters) {
            annotations.add((ImmutableList.Builder<ClassFile.AnnotationInfo>)ImmutableList.builder());
        }
        for (int i = 0; i < numParameters; ++i) {
            int numAnnotations = this.reader.u2();
            for (int n = 0; n < numAnnotations; ++n) {
                annotations.get(i).add((Object)this.readAnnotation(constantPool, runtimeVisibility));
            }
        }
    }

    private void readMethodParameters(ImmutableList.Builder<ClassFile.MethodInfo.ParameterInfo> parameters, ConstantPoolReader constantPool) {
        int unusedLength = this.reader.u4();
        int numParameters = this.reader.u1();
        for (int i = 0; i < numParameters; ++i) {
            int nameIndex = this.reader.u2();
            String name = nameIndex == 0 ? null : constantPool.utf8(nameIndex);
            int access = this.reader.u2();
            if (name == null || (access & 0x9000) != 0) continue;
            parameters.add((Object)new ClassFile.MethodInfo.ParameterInfo(name, access));
        }
    }

    private ClassFile.ModuleInfo readModule(ConstantPoolReader constantPool) {
        int unusedLength = this.reader.u4();
        String name = constantPool.moduleInfo(this.reader.u2());
        int flags = this.reader.u2();
        int versionIndex = this.reader.u2();
        String version = versionIndex != 0 ? constantPool.utf8(versionIndex) : null;
        ImmutableList.Builder requires = ImmutableList.builder();
        int numRequires = this.reader.u2();
        for (int i = 0; i < numRequires; ++i) {
            String requiresModule = constantPool.moduleInfo(this.reader.u2());
            int requiresFlags = this.reader.u2();
            int requiresVersionIndex = this.reader.u2();
            String requiresVersion = requiresVersionIndex != 0 ? constantPool.utf8(requiresVersionIndex) : null;
            requires.add((Object)new ClassFile.ModuleInfo.RequireInfo(requiresModule, requiresFlags, requiresVersion));
        }
        ImmutableList.Builder exports = ImmutableList.builder();
        int numExports = this.reader.u2();
        for (int i = 0; i < numExports; ++i) {
            String exportsModule = constantPool.packageInfo(this.reader.u2());
            int exportsFlags = this.reader.u2();
            int numExportsTo = this.reader.u2();
            ImmutableList.Builder exportsToModules = ImmutableList.builder();
            for (int n = 0; n < numExportsTo; ++n) {
                String exportsToModule = constantPool.moduleInfo(this.reader.u2());
                exportsToModules.add((Object)exportsToModule);
            }
            exports.add((Object)new ClassFile.ModuleInfo.ExportInfo(exportsModule, exportsFlags, (ImmutableList<String>)exportsToModules.build()));
        }
        ImmutableList.Builder opens = ImmutableList.builder();
        int numOpens = this.reader.u2();
        for (int i = 0; i < numOpens; ++i) {
            String opensModule = constantPool.packageInfo(this.reader.u2());
            int opensFlags = this.reader.u2();
            int numOpensTo = this.reader.u2();
            ImmutableList.Builder opensToModules = ImmutableList.builder();
            for (int n = 0; n < numOpensTo; ++n) {
                String opensToModule = constantPool.moduleInfo(this.reader.u2());
                opensToModules.add((Object)opensToModule);
            }
            opens.add((Object)new ClassFile.ModuleInfo.OpenInfo(opensModule, opensFlags, (ImmutableList<String>)opensToModules.build()));
        }
        ImmutableList.Builder uses = ImmutableList.builder();
        int numUses = this.reader.u2();
        for (int i = 0; i < numUses; ++i) {
            String use = constantPool.classInfo(this.reader.u2());
            uses.add((Object)new ClassFile.ModuleInfo.UseInfo(use));
        }
        ImmutableList.Builder provides = ImmutableList.builder();
        int numProvides = this.reader.u2();
        for (int i = 0; i < numProvides; ++i) {
            String typeName = constantPool.classInfo(this.reader.u2());
            int numProvidesWith = this.reader.u2();
            ImmutableList.Builder impls = ImmutableList.builder();
            for (int n = 0; n < numProvidesWith; ++n) {
                String impl = constantPool.classInfo(this.reader.u2());
                impls.add((Object)impl);
            }
            provides.add((Object)new ClassFile.ModuleInfo.ProvideInfo(typeName, (ImmutableList<String>)impls.build()));
        }
        return new ClassFile.ModuleInfo(name, flags, version, (ImmutableList<ClassFile.ModuleInfo.RequireInfo>)requires.build(), (ImmutableList<ClassFile.ModuleInfo.ExportInfo>)exports.build(), (ImmutableList<ClassFile.ModuleInfo.OpenInfo>)opens.build(), (ImmutableList<ClassFile.ModuleInfo.UseInfo>)uses.build(), (ImmutableList<ClassFile.ModuleInfo.ProvideInfo>)provides.build());
    }

    private ClassFile.AnnotationInfo readAnnotation(ConstantPoolReader constantPool, ClassFile.AnnotationInfo.RuntimeVisibility runtimeVisibility) {
        int typeIndex = this.reader.u2();
        String annotationType = constantPool.utf8(typeIndex);
        int numElementValuePairs = this.reader.u2();
        ImmutableMap.Builder values = ImmutableMap.builder();
        for (int e = 0; e < numElementValuePairs; ++e) {
            int elementNameIndex = this.reader.u2();
            String key = constantPool.utf8(elementNameIndex);
            ClassFile.AnnotationInfo.ElementValue value = this.readElementValue(constantPool);
            values.put((Object)key, (Object)value);
        }
        return new ClassFile.AnnotationInfo(annotationType, runtimeVisibility, (Map<String, ClassFile.AnnotationInfo.ElementValue>)values.buildOrThrow());
    }

    private void readTypeAnnotations(ImmutableList.Builder<ClassFile.TypeAnnotationInfo> typeAnnotations, ConstantPoolReader constantPool, ClassFile.AnnotationInfo.RuntimeVisibility runtimeVisibility) {
        int unusedLength = this.reader.u4();
        int numAnnotations = this.reader.u2();
        for (int n = 0; n < numAnnotations; ++n) {
            ClassFile.TypeAnnotationInfo anno = this.readTypeAnnotation(constantPool, runtimeVisibility);
            if (anno == null) continue;
            typeAnnotations.add((Object)anno);
        }
    }

    private @Nullable ClassFile.TypeAnnotationInfo readTypeAnnotation(ConstantPoolReader constantPool, ClassFile.AnnotationInfo.RuntimeVisibility runtimeVisibility) {
        int targetTypeId = this.reader.u1();
        ClassFile.TypeAnnotationInfo.TargetType targetType = ClassFile.TypeAnnotationInfo.TargetType.forTag(targetTypeId);
        ClassFile.TypeAnnotationInfo.Target target = null;
        if (targetType != null) {
            target = this.readTypeAnnotationTarget(targetType);
        } else {
            switch (targetTypeId) {
                case 64: 
                case 65: {
                    this.reader.skip(this.reader.u2() * 6);
                    break;
                }
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: {
                    this.reader.skip(2);
                    break;
                }
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: {
                    this.reader.skip(3);
                    break;
                }
                default: {
                    throw this.error("invalid target type: %d", targetTypeId);
                }
            }
        }
        ClassFile.TypeAnnotationInfo.TypePath typePath = ClassFile.TypeAnnotationInfo.TypePath.root();
        int pathLength = this.reader.u1();
        for (int i = 0; i < pathLength; ++i) {
            typePath = this.readTypePath(typePath);
        }
        ClassFile.AnnotationInfo anno = this.readAnnotation(constantPool, runtimeVisibility);
        if (targetType == null) {
            return null;
        }
        return new ClassFile.TypeAnnotationInfo(targetType, Objects.requireNonNull(target), typePath, anno);
    }

    private ClassFile.TypeAnnotationInfo.Target readTypeAnnotationTarget(ClassFile.TypeAnnotationInfo.TargetType targetType) {
        return switch (targetType) {
            default -> throw new MatchException(null, null);
            case ClassFile.TypeAnnotationInfo.TargetType.CLASS_TYPE_PARAMETER, ClassFile.TypeAnnotationInfo.TargetType.METHOD_TYPE_PARAMETER -> {
                int typeParameterIndex = this.reader.u1();
                yield ClassFile.TypeAnnotationInfo.TypeParameterTarget.create(typeParameterIndex);
            }
            case ClassFile.TypeAnnotationInfo.TargetType.SUPERTYPE -> {
                int superTypeIndex = this.reader.u2();
                yield ClassFile.TypeAnnotationInfo.SuperTypeTarget.create(superTypeIndex);
            }
            case ClassFile.TypeAnnotationInfo.TargetType.CLASS_TYPE_PARAMETER_BOUND, ClassFile.TypeAnnotationInfo.TargetType.METHOD_TYPE_PARAMETER_BOUND -> {
                int typeParameterIndex = this.reader.u1();
                int boundIndex = this.reader.u1();
                yield ClassFile.TypeAnnotationInfo.TypeParameterBoundTarget.create(typeParameterIndex, boundIndex);
            }
            case ClassFile.TypeAnnotationInfo.TargetType.FIELD, ClassFile.TypeAnnotationInfo.TargetType.METHOD_RETURN, ClassFile.TypeAnnotationInfo.TargetType.METHOD_RECEIVER_PARAMETER -> ClassFile.TypeAnnotationInfo.EMPTY_TARGET;
            case ClassFile.TypeAnnotationInfo.TargetType.METHOD_FORMAL_PARAMETER -> {
                int formalParameterIndex = this.reader.u1();
                yield ClassFile.TypeAnnotationInfo.FormalParameterTarget.create(formalParameterIndex);
            }
            case ClassFile.TypeAnnotationInfo.TargetType.METHOD_THROWS -> {
                int throwsTypeIndex = this.reader.u2();
                yield ClassFile.TypeAnnotationInfo.ThrowsTarget.create(throwsTypeIndex);
            }
        };
    }

    private ClassFile.TypeAnnotationInfo.TypePath readTypePath(ClassFile.TypeAnnotationInfo.TypePath typePath) {
        int typePathKind = this.reader.u1();
        int typeArgumentIndex = this.reader.u1();
        return switch (typePathKind) {
            case 0 -> typePath.array();
            case 1 -> typePath.nested();
            case 2 -> typePath.wild();
            case 3 -> typePath.typeArgument(typeArgumentIndex);
            default -> throw this.error("invalid type path kind: %d", typePathKind);
        };
    }

    private ClassFile.AnnotationInfo.ElementValue readElementValue(ConstantPoolReader constantPool) {
        int tag = this.reader.u1();
        return switch (tag) {
            case 66 -> new ClassFile.AnnotationInfo.ElementValue.ConstValue(new Const.ByteValue((byte)this.readInt(constantPool)));
            case 67 -> new ClassFile.AnnotationInfo.ElementValue.ConstValue(new Const.CharValue((char)this.readInt(constantPool)));
            case 83 -> new ClassFile.AnnotationInfo.ElementValue.ConstValue(new Const.ShortValue((short)this.readInt(constantPool)));
            case 68, 70, 73, 74, 115 -> new ClassFile.AnnotationInfo.ElementValue.ConstValue(this.readConst(constantPool));
            case 90 -> new ClassFile.AnnotationInfo.ElementValue.ConstValue(new Const.BooleanValue(this.readInt(constantPool) != 0));
            case 101 -> {
                int typeNameIndex = this.reader.u2();
                int constNameIndex = this.reader.u2();
                String typeName = constantPool.utf8(typeNameIndex);
                String constName = constantPool.utf8(constNameIndex);
                yield new ClassFile.AnnotationInfo.ElementValue.EnumConstValue(typeName, constName);
            }
            case 99 -> {
                int classInfoIndex = this.reader.u2();
                String className = constantPool.utf8(classInfoIndex);
                yield new ClassFile.AnnotationInfo.ElementValue.ConstTurbineClassValue(className);
            }
            case 64 -> new ClassFile.AnnotationInfo.ElementValue.ConstTurbineAnnotationValue(this.readAnnotation(constantPool, ClassFile.AnnotationInfo.RuntimeVisibility.INVISIBLE));
            case 91 -> {
                int numValues = this.reader.u2();
                ImmutableList.Builder elements = ImmutableList.builder();
                for (int i = 0; i < numValues; ++i) {
                    elements.add((Object)this.readElementValue(constantPool));
                }
                yield new ClassFile.AnnotationInfo.ElementValue.ArrayValue((List<ClassFile.AnnotationInfo.ElementValue>)elements.build());
            }
            default -> throw new AssertionError((Object)String.format("bad tag value %c", tag));
        };
    }

    private int readInt(ConstantPoolReader constantPool) {
        return ((Const.IntValue)this.readConst(constantPool)).value();
    }

    private Const.Value readConst(ConstantPoolReader constantPool) {
        int constValueIndex = this.reader.u2();
        return constantPool.constant(constValueIndex);
    }

    private List<ClassFile.MethodInfo> readMethods(ConstantPoolReader constantPool) {
        int methodsCount = this.reader.u2();
        ArrayList<ClassFile.MethodInfo> methods = new ArrayList<ClassFile.MethodInfo>();
        for (int i = 0; i < methodsCount; ++i) {
            int accessFlags = this.reader.u2();
            int nameIndex = this.reader.u2();
            String name = constantPool.utf8(nameIndex);
            int descriptorIndex = this.reader.u2();
            String desc = constantPool.utf8(descriptorIndex);
            int attributesCount = this.reader.u2();
            String signature = null;
            ImmutableList<String> exceptions = ImmutableList.of();
            ImmutableList.Builder annotations = ImmutableList.builder();
            ImmutableList.Builder typeAnnotations = ImmutableList.builder();
            ArrayList<ImmutableList.Builder<ClassFile.AnnotationInfo>> parameterAnnotationsBuilder = new ArrayList<ImmutableList.Builder<ClassFile.AnnotationInfo>>();
            ImmutableList.Builder parameters = ImmutableList.builder();
            ClassFile.AnnotationInfo.ElementValue defaultValue = null;
            block25: for (int j = 0; j < attributesCount; ++j) {
                String attributeName;
                switch (attributeName = constantPool.utf8(this.reader.u2())) {
                    case "Exceptions": {
                        exceptions = this.readExceptions(constantPool);
                        continue block25;
                    }
                    case "Signature": {
                        signature = this.readSignature(constantPool);
                        continue block25;
                    }
                    case "AnnotationDefault": {
                        int unusedLength = this.reader.u4();
                        defaultValue = this.readElementValue(constantPool);
                        continue block25;
                    }
                    case "RuntimeInvisibleAnnotations": {
                        this.readAnnotations((ImmutableList.Builder<ClassFile.AnnotationInfo>)annotations, constantPool, ClassFile.AnnotationInfo.RuntimeVisibility.INVISIBLE);
                        continue block25;
                    }
                    case "RuntimeVisibleAnnotations": {
                        this.readAnnotations((ImmutableList.Builder<ClassFile.AnnotationInfo>)annotations, constantPool, ClassFile.AnnotationInfo.RuntimeVisibility.VISIBLE);
                        continue block25;
                    }
                    case "RuntimeInvisibleTypeAnnotations": {
                        this.readTypeAnnotations((ImmutableList.Builder<ClassFile.TypeAnnotationInfo>)typeAnnotations, constantPool, ClassFile.AnnotationInfo.RuntimeVisibility.INVISIBLE);
                        continue block25;
                    }
                    case "RuntimeVisibleTypeAnnotations": {
                        this.readTypeAnnotations((ImmutableList.Builder<ClassFile.TypeAnnotationInfo>)typeAnnotations, constantPool, ClassFile.AnnotationInfo.RuntimeVisibility.VISIBLE);
                        continue block25;
                    }
                    case "RuntimeInvisibleParameterAnnotations": {
                        this.readParameterAnnotations(parameterAnnotationsBuilder, constantPool, ClassFile.AnnotationInfo.RuntimeVisibility.INVISIBLE);
                        continue block25;
                    }
                    case "RuntimeVisibleParameterAnnotations": {
                        this.readParameterAnnotations(parameterAnnotationsBuilder, constantPool, ClassFile.AnnotationInfo.RuntimeVisibility.VISIBLE);
                        continue block25;
                    }
                    case "MethodParameters": {
                        this.readMethodParameters((ImmutableList.Builder<ClassFile.MethodInfo.ParameterInfo>)parameters, constantPool);
                        continue block25;
                    }
                    default: {
                        this.reader.skip(this.reader.u4());
                    }
                }
            }
            ImmutableList.Builder parameterAnnotations = ImmutableList.builder();
            for (ImmutableList.Builder builder : parameterAnnotationsBuilder) {
                parameterAnnotations.add((Object)builder.build());
            }
            if ((accessFlags & 0x1040) != 0) continue;
            methods.add(new ClassFile.MethodInfo(accessFlags, name, desc, signature, (List<String>)exceptions, defaultValue, (List<ClassFile.AnnotationInfo>)annotations.build(), (ImmutableList<ImmutableList<ClassFile.AnnotationInfo>>)parameterAnnotations.build(), (ImmutableList<ClassFile.TypeAnnotationInfo>)typeAnnotations.build(), (ImmutableList<ClassFile.MethodInfo.ParameterInfo>)parameters.build()));
        }
        return methods;
    }

    private ImmutableList<String> readExceptions(ConstantPoolReader constantPool) {
        ImmutableList.Builder exceptions = ImmutableList.builder();
        int unusedLength = this.reader.u4();
        int numberOfExceptions = this.reader.u2();
        for (int exceptionIndex = 0; exceptionIndex < numberOfExceptions; ++exceptionIndex) {
            exceptions.add((Object)constantPool.classInfo(this.reader.u2()));
        }
        return exceptions.build();
    }

    private List<ClassFile.FieldInfo> readFields(ConstantPoolReader constantPool) {
        int fieldsCount = this.reader.u2();
        ArrayList<ClassFile.FieldInfo> fields = new ArrayList<ClassFile.FieldInfo>();
        for (int i = 0; i < fieldsCount; ++i) {
            int accessFlags = this.reader.u2();
            int nameIndex = this.reader.u2();
            String name = constantPool.utf8(nameIndex);
            int descriptorIndex = this.reader.u2();
            String desc = constantPool.utf8(descriptorIndex);
            int attributesCount = this.reader.u2();
            Const.Value value = null;
            ImmutableList.Builder annotations = ImmutableList.builder();
            ImmutableList.Builder typeAnnotations = ImmutableList.builder();
            String signature = null;
            block17: for (int j = 0; j < attributesCount; ++j) {
                String attributeName;
                switch (attributeName = constantPool.utf8(this.reader.u2())) {
                    case "ConstantValue": {
                        int unusedLength = this.reader.u4();
                        value = constantPool.constant(this.reader.u2());
                        continue block17;
                    }
                    case "RuntimeInvisibleAnnotations": {
                        this.readAnnotations((ImmutableList.Builder<ClassFile.AnnotationInfo>)annotations, constantPool, ClassFile.AnnotationInfo.RuntimeVisibility.INVISIBLE);
                        continue block17;
                    }
                    case "RuntimeVisibleAnnotations": {
                        this.readAnnotations((ImmutableList.Builder<ClassFile.AnnotationInfo>)annotations, constantPool, ClassFile.AnnotationInfo.RuntimeVisibility.VISIBLE);
                        continue block17;
                    }
                    case "RuntimeInvisibleTypeAnnotations": {
                        this.readTypeAnnotations((ImmutableList.Builder<ClassFile.TypeAnnotationInfo>)typeAnnotations, constantPool, ClassFile.AnnotationInfo.RuntimeVisibility.INVISIBLE);
                        continue block17;
                    }
                    case "RuntimeVisibleTypeAnnotations": {
                        this.readTypeAnnotations((ImmutableList.Builder<ClassFile.TypeAnnotationInfo>)typeAnnotations, constantPool, ClassFile.AnnotationInfo.RuntimeVisibility.VISIBLE);
                        continue block17;
                    }
                    case "Signature": {
                        signature = this.readSignature(constantPool);
                        continue block17;
                    }
                    default: {
                        this.reader.skip(this.reader.u4());
                    }
                }
            }
            fields.add(new ClassFile.FieldInfo(accessFlags, name, desc, signature, value, (List<ClassFile.AnnotationInfo>)annotations.build(), (ImmutableList<ClassFile.TypeAnnotationInfo>)typeAnnotations.build()));
        }
        return fields;
    }

    private String readTurbineTransitiveJar(ConstantPoolReader constantPool) {
        int unusedLength = this.reader.u4();
        return constantPool.utf8(this.reader.u2());
    }

    private ClassFile.RecordInfo readRecord(ConstantPoolReader constantPool) {
        int unusedLength = this.reader.u4();
        int componentsCount = this.reader.u2();
        ImmutableList.Builder components = ImmutableList.builder();
        for (int i = 0; i < componentsCount; ++i) {
            String name = constantPool.utf8(this.reader.u2());
            String descriptor = constantPool.utf8(this.reader.u2());
            int attributesCount = this.reader.u2();
            ImmutableList.Builder annotations = ImmutableList.builder();
            ImmutableList.Builder typeAnnotations = ImmutableList.builder();
            String signature = null;
            block15: for (int j = 0; j < attributesCount; ++j) {
                String attributeName;
                switch (attributeName = constantPool.utf8(this.reader.u2())) {
                    case "RuntimeInvisibleAnnotations": {
                        this.readAnnotations((ImmutableList.Builder<ClassFile.AnnotationInfo>)annotations, constantPool, ClassFile.AnnotationInfo.RuntimeVisibility.INVISIBLE);
                        continue block15;
                    }
                    case "RuntimeVisibleAnnotations": {
                        this.readAnnotations((ImmutableList.Builder<ClassFile.AnnotationInfo>)annotations, constantPool, ClassFile.AnnotationInfo.RuntimeVisibility.VISIBLE);
                        continue block15;
                    }
                    case "RuntimeInvisibleTypeAnnotations": {
                        this.readTypeAnnotations((ImmutableList.Builder<ClassFile.TypeAnnotationInfo>)typeAnnotations, constantPool, ClassFile.AnnotationInfo.RuntimeVisibility.INVISIBLE);
                        continue block15;
                    }
                    case "RuntimeVisibleTypeAnnotations": {
                        this.readTypeAnnotations((ImmutableList.Builder<ClassFile.TypeAnnotationInfo>)typeAnnotations, constantPool, ClassFile.AnnotationInfo.RuntimeVisibility.VISIBLE);
                        continue block15;
                    }
                    case "Signature": {
                        signature = this.readSignature(constantPool);
                        continue block15;
                    }
                    default: {
                        this.reader.skip(this.reader.u4());
                    }
                }
            }
            components.add((Object)new ClassFile.RecordInfo.RecordComponentInfo(name, descriptor, signature, (ImmutableList<ClassFile.AnnotationInfo>)annotations.build(), (ImmutableList<ClassFile.TypeAnnotationInfo>)typeAnnotations.build()));
        }
        return new ClassFile.RecordInfo((ImmutableList<ClassFile.RecordInfo.RecordComponentInfo>)components.build());
    }
}

