/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder.bound;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.turbine.binder.bound.AnnotationMetadata;
import com.google.turbine.binder.bound.HeaderBoundClass;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.binder.sym.FieldSymbol;
import com.google.turbine.binder.sym.MethodSymbol;
import com.google.turbine.binder.sym.ParamSymbol;
import com.google.turbine.binder.sym.RecordComponentSymbol;
import com.google.turbine.binder.sym.TyVarSymbol;
import com.google.turbine.model.Const;
import com.google.turbine.type.AnnoInfo;
import com.google.turbine.type.Type;
import org.jspecify.annotations.Nullable;

public interface TypeBoundClass
extends HeaderBoundClass {
    public @Nullable Type superClassType();

    public ImmutableList<Type> interfaceTypes();

    public ImmutableList<ClassSymbol> permits();

    public ImmutableMap<TyVarSymbol, TyVarInfo> typeParameterTypes();

    public ImmutableList<FieldInfo> fields();

    public ImmutableList<MethodInfo> methods();

    public ImmutableList<RecordComponentInfo> components();

    public @Nullable AnnotationMetadata annotationMetadata();

    public ImmutableList<AnnoInfo> annotations();

    public static class RecordComponentInfo {
        private final RecordComponentSymbol sym;
        private final Type type;
        private final int access;
        private final ImmutableList<AnnoInfo> annotations;

        public RecordComponentInfo(RecordComponentSymbol sym, Type type, ImmutableList<AnnoInfo> annotations, int access) {
            this.sym = sym;
            this.type = type;
            this.access = access;
            this.annotations = annotations;
        }

        public RecordComponentSymbol sym() {
            return this.sym;
        }

        public Type type() {
            return this.type;
        }

        public ImmutableList<AnnoInfo> annotations() {
            return this.annotations;
        }

        public String name() {
            return this.sym.name();
        }

        public int access() {
            return this.access;
        }
    }

    public static class ParamInfo {
        private final ParamSymbol sym;
        private final Type type;
        private final int access;
        private final ImmutableList<AnnoInfo> annotations;

        public ParamInfo(ParamSymbol sym, Type type, ImmutableList<AnnoInfo> annotations, int access) {
            this.sym = sym;
            this.type = type;
            this.access = access;
            this.annotations = annotations;
        }

        public ParamSymbol sym() {
            return this.sym;
        }

        public Type type() {
            return this.type;
        }

        public boolean synthetic() {
            return (this.access & 0x9000) != 0;
        }

        public ImmutableList<AnnoInfo> annotations() {
            return this.annotations;
        }

        public String name() {
            return this.sym.name();
        }

        public int access() {
            return this.access;
        }
    }

    public static class MethodInfo {
        private final MethodSymbol sym;
        private final ImmutableMap<TyVarSymbol, TyVarInfo> tyParams;
        private final Type returnType;
        private final ImmutableList<ParamInfo> parameters;
        private final ImmutableList<Type> exceptions;
        private final int access;
        private final @Nullable Const defaultValue;
        private final  @Nullable Tree.MethDecl decl;
        private final ImmutableList<AnnoInfo> annotations;
        private final @Nullable ParamInfo receiver;

        public MethodInfo(MethodSymbol sym, ImmutableMap<TyVarSymbol, TyVarInfo> tyParams, Type returnType, ImmutableList<ParamInfo> parameters, ImmutableList<Type> exceptions, int access, @Nullable Const defaultValue,  @Nullable Tree.MethDecl decl, ImmutableList<AnnoInfo> annotations, @Nullable ParamInfo receiver) {
            this.sym = sym;
            this.tyParams = tyParams;
            this.returnType = returnType;
            this.parameters = parameters;
            this.exceptions = exceptions;
            this.access = access;
            this.defaultValue = defaultValue;
            this.decl = decl;
            this.annotations = annotations;
            this.receiver = receiver;
        }

        public MethodSymbol sym() {
            return this.sym;
        }

        public String name() {
            return this.sym.name();
        }

        public ImmutableMap<TyVarSymbol, TyVarInfo> tyParams() {
            return this.tyParams;
        }

        public Type returnType() {
            return this.returnType;
        }

        public ImmutableList<ParamInfo> parameters() {
            return this.parameters;
        }

        public ImmutableList<Type> exceptions() {
            return this.exceptions;
        }

        public int access() {
            return this.access;
        }

        public @Nullable Const defaultValue() {
            return this.defaultValue;
        }

        public boolean hasDefaultValue() {
            return this.decl() != null ? this.decl().defaultValue().isPresent() : this.defaultValue() != null;
        }

        public  @Nullable Tree.MethDecl decl() {
            return this.decl;
        }

        public ImmutableList<AnnoInfo> annotations() {
            return this.annotations;
        }

        public @Nullable ParamInfo receiver() {
            return this.receiver;
        }

        public Type.MethodTy asType() {
            return Type.MethodTy.create((ImmutableSet<TyVarSymbol>)this.tyParams.keySet(), this.returnType, this.receiver != null ? this.receiver.type() : null, MethodInfo.asTypes(this.parameters), this.exceptions);
        }

        private static ImmutableList<Type> asTypes(ImmutableList<ParamInfo> parameters) {
            ImmutableList.Builder result = ImmutableList.builder();
            for (ParamInfo param : parameters) {
                if (param.synthetic()) continue;
                result.add((Object)param.type());
            }
            return result.build();
        }
    }

    public static class FieldInfo {
        private final FieldSymbol sym;
        private final Type type;
        private final int access;
        private final ImmutableList<AnnoInfo> annotations;
        private final  @Nullable Tree.VarDecl decl;
        private final @Nullable Const.Value value;

        public FieldInfo(FieldSymbol sym, Type type, int access, ImmutableList<AnnoInfo> annotations,  @Nullable Tree.VarDecl decl, @Nullable Const.Value value) {
            this.sym = sym;
            this.type = type;
            this.access = access;
            this.annotations = annotations;
            this.decl = decl;
            this.value = value;
        }

        public FieldSymbol sym() {
            return this.sym;
        }

        public String name() {
            return this.sym.name();
        }

        public Type type() {
            return this.type;
        }

        public int access() {
            return this.access;
        }

        public  @Nullable Tree.VarDecl decl() {
            return this.decl;
        }

        public @Nullable Const.Value value() {
            return this.value;
        }

        public ImmutableList<AnnoInfo> annotations() {
            return this.annotations;
        }
    }

    public static class TyVarInfo {
        private final Type.IntersectionTy upperBound;
        private final @Nullable Type lowerBound;
        private final ImmutableList<AnnoInfo> annotations;

        public TyVarInfo(Type.IntersectionTy upperBound, @Nullable Type lowerBound, ImmutableList<AnnoInfo> annotations) {
            this.upperBound = upperBound;
            if (lowerBound != null) {
                throw new IllegalArgumentException("TODO(cushon): support lower bounds");
            }
            this.lowerBound = lowerBound;
            this.annotations = annotations;
        }

        public Type.IntersectionTy upperBound() {
            return this.upperBound;
        }

        public @Nullable Type lowerBound() {
            return this.lowerBound;
        }

        public ImmutableList<AnnoInfo> annotations() {
            return this.annotations;
        }
    }
}

