/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.StandardSystemProperty;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.turbine.binder.ClassPath;
import com.google.turbine.binder.bound.ModuleInfo;
import com.google.turbine.binder.bytecode.BytecodeBinder;
import com.google.turbine.binder.bytecode.BytecodeBoundClass;
import com.google.turbine.binder.env.Env;
import com.google.turbine.binder.env.SimpleEnv;
import com.google.turbine.binder.lookup.SimpleTopLevelIndex;
import com.google.turbine.binder.lookup.TopLevelIndex;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.binder.sym.ModuleSymbol;
import com.google.turbine.zip.Zip;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public final class CtSymClassBinder {
    public static @Nullable ClassPath bind(int version) throws IOException {
        Path ctSym;
        String explicitCtSymPath = System.getProperty("turbine.ctSymPath");
        if (explicitCtSymPath == null) {
            String javaHome = StandardSystemProperty.JAVA_HOME.value();
            Objects.requireNonNull(javaHome, "attempted to use --release, but JAVA_HOME is not set");
            ctSym = Paths.get(javaHome, new String[0]).resolve("lib/ct.sym");
            if (!Files.exists(ctSym, new LinkOption[0])) {
                throw new IllegalStateException("lib/ct.sym does not exist in " + javaHome);
            }
        } else {
            ctSym = Paths.get(explicitCtSymPath, new String[0]);
            if (!Files.exists(ctSym, new LinkOption[0])) {
                throw new IllegalStateException("ct.sym does not exist at " + String.valueOf(ctSym));
            }
        }
        final HashMap<ClassSymbol, BytecodeBoundClass> map = new HashMap<ClassSymbol, BytecodeBoundClass>();
        HashMap<ModuleSymbol, ModuleInfo> modules = new HashMap<ModuleSymbol, ModuleInfo>();
        Env<ClassSymbol, BytecodeBoundClass> benv = new Env<ClassSymbol, BytecodeBoundClass>(){

            @Override
            public @Nullable BytecodeBoundClass get(ClassSymbol sym) {
                return (BytecodeBoundClass)map.get(sym);
            }
        };
        char releaseChar = CtSymClassBinder.formatReleaseVersion(version);
        for (Zip.Entry ze : new Zip.ZipIterable(ctSym)) {
            int idx;
            String name = ze.name();
            if (!name.endsWith(".sig") || (idx = name.indexOf(47)) == -1 || ze.name().substring(0, idx).indexOf(releaseChar) == -1) continue;
            idx = name.indexOf(47, idx + 1);
            if (name.substring(name.lastIndexOf(47) + 1).equals("module-info.sig")) {
                ModuleInfo moduleInfo = BytecodeBinder.bindModuleInfo(name, (java.util.function.Supplier<byte[]>)((Object)ze));
                modules.put(new ModuleSymbol(moduleInfo.name()), moduleInfo);
                continue;
            }
            ClassSymbol sym = new ClassSymbol(name.substring(idx + 1, name.length() - ".sig".length()));
            map.putIfAbsent(sym, new BytecodeBoundClass(sym, ze, benv, String.valueOf(ctSym) + "!" + ze.name()));
        }
        if (map.isEmpty()) {
            return null;
        }
        final SimpleEnv env = new SimpleEnv(ImmutableMap.copyOf(map));
        final SimpleEnv moduleEnv = new SimpleEnv(ImmutableMap.copyOf(modules));
        final TopLevelIndex index = SimpleTopLevelIndex.of((Iterable<ClassSymbol>)env.asMap().keySet());
        return new ClassPath(){

            @Override
            public Env<ClassSymbol, BytecodeBoundClass> env() {
                return env;
            }

            @Override
            public Env<ModuleSymbol, ModuleInfo> moduleEnv() {
                return moduleEnv;
            }

            @Override
            public TopLevelIndex index() {
                return index;
            }

            @Override
            public @Nullable Supplier<byte[]> resource(String input) {
                return null;
            }
        };
    }

    @VisibleForTesting
    static char formatReleaseVersion(int n) {
        if (n <= 4 || n >= 36) {
            throw new IllegalArgumentException("invalid release version: " + n);
        }
        if (n < 10) {
            return (char)(48 + n);
        }
        return (char)(65 + n - 10);
    }

    private CtSymClassBinder() {
    }
}

