/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.truth.Correspondence;
import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.GraphMatching;
import com.google.common.truth.Ordered;
import com.google.common.truth.Subject;
import com.google.common.truth.SubjectUtils;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.DoNotCall;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

public class IterableSubject
extends Subject {
    private final @Nullable Iterable<?> actual;
    private static final Ordered IN_ORDER = () -> {};
    private static final Ordered ALREADY_FAILED = () -> {};

    protected IterableSubject(FailureMetadata metadata, @Nullable Iterable<?> iterable) {
        this(metadata, iterable, null);
    }

    IterableSubject(FailureMetadata metadata, @Nullable Iterable<?> iterable, @Nullable String typeDescriptionOverride) {
        super(metadata, iterable, typeDescriptionOverride);
        this.actual = iterable;
    }

    @Override
    protected String actualCustomStringRepresentation() {
        if (this.actual != null) {
            String objectToString = this.actual.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(this.actual));
            if (this.actual.toString().equals(objectToString)) {
                return Iterables.toString(this.actual);
            }
        }
        return super.actualCustomStringRepresentation();
    }

    @Override
    public void isEqualTo(@Nullable Object expected) {
        boolean equal = Objects.equal(this.actual, (Object)expected);
        if (equal) {
            return;
        }
        if (this.actual instanceof List && expected instanceof List) {
            this.containsExactlyElementsIn((List)expected).inOrder();
        } else if (this.actual instanceof Set && expected instanceof Set || this.actual instanceof Multiset && expected instanceof Multiset) {
            this.containsExactlyElementsIn((Collection)expected);
        } else {
            super.isEqualTo(expected);
        }
    }

    public final void isEmpty() {
        if (!Iterables.isEmpty((Iterable)((Iterable)Preconditions.checkNotNull(this.actual)))) {
            this.failWithActual(Fact.simpleFact("expected to be empty"), new Fact[0]);
        }
    }

    public final void isNotEmpty() {
        if (Iterables.isEmpty((Iterable)((Iterable)Preconditions.checkNotNull(this.actual)))) {
            this.failWithoutActual(Fact.simpleFact("expected not to be empty"), new Fact[0]);
        }
    }

    public final void hasSize(int expectedSize) {
        Preconditions.checkArgument((expectedSize >= 0 ? 1 : 0) != 0, (String)"expectedSize(%s) must be >= 0", (int)expectedSize);
        int actualSize = Iterables.size((Iterable)((Iterable)Preconditions.checkNotNull(this.actual)));
        this.check("size()", new Object[0]).that(actualSize).isEqualTo(expectedSize);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public final void contains(@Nullable Object element) {
        if (!Iterables.contains((Iterable)((Iterable)Preconditions.checkNotNull(this.actual)), (Object)element)) {
            @Nullable ArrayList elementList = Lists.newArrayList((Object[])new Object[]{element});
            if (SubjectUtils.hasMatchingToStringPair(this.actual, elementList)) {
                this.failWithoutActual(Fact.fact("expected to contain", element), Fact.fact("an instance of", SubjectUtils.objectToTypeName(element)), Fact.simpleFact("but did not"), Fact.fact("though it did contain", SubjectUtils.countDuplicatesAndAddTypeInfo(SubjectUtils.retainMatchingToString(this.actual, elementList))), this.fullContents());
            } else {
                this.failWithActual("expected to contain", element);
            }
        }
    }

    public final void doesNotContain(@Nullable Object element) {
        if (Iterables.contains((Iterable)((Iterable)Preconditions.checkNotNull(this.actual)), (Object)element)) {
            this.failWithActual("expected not to contain", element);
        }
    }

    public final void containsNoDuplicates() {
        ArrayList duplicates = Lists.newArrayList();
        for (Multiset.Entry entry : LinkedHashMultiset.create((Iterable)((Iterable)Preconditions.checkNotNull(this.actual))).entrySet()) {
            if (entry.getCount() <= 1) continue;
            duplicates.add(entry);
        }
        if (!duplicates.isEmpty()) {
            this.failWithoutActual(Fact.simpleFact("expected not to contain duplicates"), Fact.fact("but contained", duplicates), this.fullContents());
        }
    }

    public final void containsAnyOf(@Nullable Object first, @Nullable Object second, Object ... rest) {
        this.containsAnyIn(SubjectUtils.accumulate(first, second, rest));
    }

    public final void containsAnyIn(@Nullable Iterable<?> expected) {
        Preconditions.checkNotNull(expected);
        Collection actual = SubjectUtils.iterableToCollection((Iterable)Preconditions.checkNotNull(this.actual));
        for (Object item : expected) {
            if (!actual.contains(item)) continue;
            return;
        }
        if (SubjectUtils.hasMatchingToStringPair(actual, expected)) {
            this.failWithoutActual(Fact.fact("expected to contain any of", SubjectUtils.countDuplicatesAndAddTypeInfo(expected)), Fact.simpleFact("but did not"), Fact.fact("though it did contain", SubjectUtils.countDuplicatesAndAddTypeInfo(SubjectUtils.retainMatchingToString((Iterable)Preconditions.checkNotNull(this.actual), expected))), this.fullContents());
        } else {
            this.failWithActual("expected to contain any of", expected);
        }
    }

    public final void containsAnyIn(@Nullable Object[] expected) {
        this.containsAnyIn(SubjectUtils.asList(expected));
    }

    @CanIgnoreReturnValue
    public final Ordered containsAtLeast(@Nullable Object firstExpected, @Nullable Object secondExpected, Object ... restOfExpected) {
        return this.containsAtLeastElementsIn(SubjectUtils.accumulate(firstExpected, secondExpected, restOfExpected));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @CanIgnoreReturnValue
    public final Ordered containsAtLeastElementsIn(Iterable<?> expectedIterable) {
        LinkedList actual = Lists.newLinkedList((Iterable)((Iterable)Preconditions.checkNotNull(this.actual)));
        final Collection<?> expected = SubjectUtils.iterableToCollection(expectedIterable);
        @Nullable ArrayList missing = Lists.newArrayList();
        @Nullable ArrayList actualNotInOrder = Lists.newArrayList();
        boolean ordered = true;
        for (Object e : expected) {
            int index = actual.indexOf(e);
            if (index != -1) {
                IterableSubject.moveElements(actual, actualNotInOrder, index);
                actual.remove(0);
                continue;
            }
            if (actualNotInOrder.remove(e)) {
                ordered = false;
                continue;
            }
            missing.add(e);
        }
        if (!missing.isEmpty()) {
            return this.failAtLeast(expected, missing);
        }
        return ordered ? IN_ORDER : new Ordered(){

            @Override
            public void inOrder() {
                ImmutableList.Builder facts = ImmutableList.builder();
                facts.add((Object)Fact.simpleFact("required elements were all found, but order was wrong"));
                facts.add((Object)Fact.fact("expected order for required elements", expected));
                ArrayList actualOrder = Lists.newArrayList((Iterable)((Iterable)Preconditions.checkNotNull((Object)IterableSubject.this.actual)));
                if (actualOrder.retainAll(expected)) {
                    facts.add((Object)Fact.fact("but order was", actualOrder));
                    facts.add((Object)IterableSubject.this.fullContents());
                    IterableSubject.this.failWithoutActual((Iterable<Fact>)facts.build());
                } else {
                    IterableSubject.this.failWithActual((Iterable<Fact>)facts.build());
                }
            }
        };
    }

    @CanIgnoreReturnValue
    public final Ordered containsAtLeastElementsIn(@Nullable Object[] expected) {
        return this.containsAtLeastElementsIn(SubjectUtils.asList(expected));
    }

    private Ordered failAtLeast(Collection<?> expected, Collection<?> missingRawObjects) {
        List<Object> nearMissRawObjects = SubjectUtils.retainMatchingToString((Iterable)Preconditions.checkNotNull(this.actual), missingRawObjects);
        ImmutableList.Builder facts = ImmutableList.builder();
        facts.addAll(IterableSubject.makeElementFactsForBoth("missing", missingRawObjects, "though it did contain", nearMissRawObjects));
        facts.add((Object)Fact.fact("expected to contain at least", expected));
        facts.add((Object)this.butWas());
        this.failWithoutActual((Iterable<Fact>)facts.build());
        return ALREADY_FAILED;
    }

    private static void moveElements(List<?> input, Collection<@Nullable Object> output, int maxElements) {
        for (int i = 0; i < maxElements; ++i) {
            output.add(input.remove(0));
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @CanIgnoreReturnValue
    public final Ordered containsExactly(Object ... varargs) {
        @Nullable ArrayList expected = varargs == null ? Lists.newArrayList((Object[])new Object[]{null}) : SubjectUtils.asList(varargs);
        return this.containsExactlyElementsIn(expected, varargs != null && varargs.length == 1 && varargs[0] instanceof Iterable);
    }

    @CanIgnoreReturnValue
    public final Ordered containsExactlyElementsIn(@Nullable Iterable<?> expected) {
        return this.containsExactlyElementsIn(expected, false);
    }

    @CanIgnoreReturnValue
    public final Ordered containsExactlyElementsIn(@Nullable Object @Nullable [] expected) {
        return this.containsExactlyElementsIn(SubjectUtils.asList((Object[])Preconditions.checkNotNull((Object)expected)));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private Ordered containsExactlyElementsIn(final @Nullable Iterable<?> required, boolean addElementsInWarning) {
        Preconditions.checkNotNull(required);
        Iterator actualIter = ((Iterable)Preconditions.checkNotNull(this.actual)).iterator();
        Iterator<?> requiredIter = required.iterator();
        if (!requiredIter.hasNext()) {
            if (actualIter.hasNext()) {
                this.isEmpty();
                return ALREADY_FAILED;
            }
            return IN_ORDER;
        }
        boolean isFirst = true;
        while (actualIter.hasNext() && requiredIter.hasNext()) {
            Object requiredElement;
            Object actualElement = actualIter.next();
            if (!Objects.equal(actualElement, requiredElement = requiredIter.next())) {
                if (isFirst && !actualIter.hasNext() && !requiredIter.hasNext()) {
                    this.checkNoNeedToDisplayBothValues("onlyElement()", new Object[0]).that(actualElement).failEqualityCheckForEqualsWithoutDescription(requiredElement);
                    return ALREADY_FAILED;
                }
                @Nullable ArrayList missing = Lists.newArrayList();
                missing.add(requiredElement);
                Iterators.addAll((Collection)missing, requiredIter);
                @Nullable ArrayList extra = Lists.newArrayList();
                if (!missing.remove(actualElement)) {
                    extra.add(actualElement);
                }
                while (actualIter.hasNext()) {
                    Object item = actualIter.next();
                    if (missing.remove(item)) continue;
                    extra.add(item);
                }
                if (missing.isEmpty() && extra.isEmpty()) {
                    return new Ordered(){

                        @Override
                        public void inOrder() {
                            IterableSubject.this.failWithActual(Fact.simpleFact("contents match, but order was wrong"), Fact.fact("expected", required));
                        }
                    };
                }
                return this.failExactly(required, addElementsInWarning, missing, extra);
            }
            isFirst = false;
        }
        if (actualIter.hasNext()) {
            return this.failExactly(required, addElementsInWarning, (Collection<?>)ImmutableList.of(), Lists.newArrayList(actualIter));
        }
        if (requiredIter.hasNext()) {
            return this.failExactly(required, addElementsInWarning, Lists.newArrayList(requiredIter), (Collection<?>)ImmutableList.of());
        }
        return IN_ORDER;
    }

    private Ordered failExactly(Iterable<?> required, boolean addElementsInWarning, Collection<?> missingRawObjects, Collection<?> extraRawObjects) {
        ImmutableList.Builder facts = ImmutableList.builder();
        facts.addAll(IterableSubject.makeElementFactsForBoth("missing", missingRawObjects, "unexpected", extraRawObjects));
        facts.add((Object)Fact.fact("expected", required));
        facts.add((Object)this.butWas());
        if (addElementsInWarning) {
            facts.add((Object)Fact.simpleFact("Passing an iterable to the varargs method containsExactly(Object...) is often not the correct thing to do. Did you mean to call containsExactlyElementsIn(Iterable) instead?"));
        }
        this.failWithoutActual((Iterable<Fact>)facts.build());
        return ALREADY_FAILED;
    }

    private static ImmutableList<Fact> makeElementFactsForBoth(String firstKey, Collection<?> firstCollection, String secondKey, Collection<?> secondCollection) {
        boolean addTypeInfo = SubjectUtils.hasMatchingToStringPair(firstCollection, secondCollection);
        SubjectUtils.DuplicateGroupedAndTyped first = SubjectUtils.countDuplicatesAndMaybeAddTypeInfoReturnObject(firstCollection, addTypeInfo);
        SubjectUtils.DuplicateGroupedAndTyped second = SubjectUtils.countDuplicatesAndMaybeAddTypeInfoReturnObject(secondCollection, addTypeInfo);
        ElementFactGrouping grouping = IterableSubject.pickGrouping(first.entrySet(), second.entrySet());
        ImmutableList.Builder facts = ImmutableList.builder();
        ImmutableList<Fact> firstFacts = IterableSubject.makeElementFacts(firstKey, first, grouping);
        ImmutableList<Fact> secondFacts = IterableSubject.makeElementFacts(secondKey, second, grouping);
        facts.addAll(firstFacts);
        if (firstFacts.size() > 1 && secondFacts.size() > 1) {
            facts.add((Object)Fact.simpleFact(""));
        }
        facts.addAll(secondFacts);
        facts.add((Object)Fact.simpleFact("---"));
        return facts.build();
    }

    private static ImmutableList<Fact> makeElementFacts(String label, SubjectUtils.DuplicateGroupedAndTyped elements, ElementFactGrouping grouping) {
        if (elements.isEmpty()) {
            return ImmutableList.of();
        }
        if (grouping == ElementFactGrouping.ALL_IN_ONE_FACT) {
            return ImmutableList.of((Object)Fact.fact(IterableSubject.keyToGoWithElementsString(label, elements), elements));
        }
        ImmutableList.Builder facts = ImmutableList.builder();
        facts.add((Object)Fact.simpleFact(IterableSubject.keyToServeAsHeader(label, elements)));
        int n = 1;
        for (Multiset.Entry<?> entry : elements.entrySet()) {
            int count = entry.getCount();
            Object item = entry.getElement();
            facts.add((Object)Fact.fact(IterableSubject.numberString(n, count), item));
            n += count;
        }
        return facts.build();
    }

    private static String keyToGoWithElementsString(String label, SubjectUtils.DuplicateGroupedAndTyped elements) {
        return Strings.lenientFormat((String)"%s (%s)", (Object[])new Object[]{label, elements.totalCopies()});
    }

    private static String keyToServeAsHeader(String label, SubjectUtils.DuplicateGroupedAndTyped elements) {
        String key = IterableSubject.keyToGoWithElementsString(label, elements);
        if (elements.homogeneousTypeToDisplay.isPresent()) {
            key = key + " (" + (String)elements.homogeneousTypeToDisplay.get() + ")";
        }
        return key;
    }

    private static String numberString(int n, int count) {
        return count == 1 ? Strings.lenientFormat((String)"#%s", (Object[])new Object[]{n}) : Strings.lenientFormat((String)"#%s [%s copies]", (Object[])new Object[]{n, count});
    }

    private static ElementFactGrouping pickGrouping(Iterable<Multiset.Entry<?>> first, Iterable<Multiset.Entry<?>> second) {
        boolean firstHasMultiple = IterableSubject.hasMultiple(first);
        boolean secondHasMultiple = IterableSubject.hasMultiple(second);
        if ((firstHasMultiple || secondHasMultiple) && IterableSubject.anyContainsCommaOrNewline(first, second)) {
            return ElementFactGrouping.FACT_PER_ELEMENT;
        }
        if (firstHasMultiple && IterableSubject.containsEmptyOrLong(first)) {
            return ElementFactGrouping.FACT_PER_ELEMENT;
        }
        if (secondHasMultiple && IterableSubject.containsEmptyOrLong(second)) {
            return ElementFactGrouping.FACT_PER_ELEMENT;
        }
        return ElementFactGrouping.ALL_IN_ONE_FACT;
    }

    private static boolean anyContainsCommaOrNewline(Iterable<Multiset.Entry<?>> ... lists) {
        for (Multiset.Entry entry : Iterables.concat((Iterable[])lists)) {
            String s = String.valueOf(entry.getElement());
            if (!s.contains("\n") && !s.contains(",")) continue;
            return true;
        }
        return false;
    }

    private static boolean hasMultiple(Iterable<Multiset.Entry<?>> entries) {
        int totalCount = 0;
        for (Multiset.Entry<?> entry : entries) {
            if ((totalCount += entry.getCount()) <= 1) continue;
            return true;
        }
        return false;
    }

    private static boolean containsEmptyOrLong(Iterable<Multiset.Entry<?>> entries) {
        int totalLength = 0;
        for (Multiset.Entry<?> entry : entries) {
            String s = SubjectUtils.entryString(entry);
            if (s.isEmpty()) {
                return true;
            }
            totalLength += s.length();
        }
        return totalLength > 200;
    }

    public final void containsNoneOf(@Nullable Object firstExcluded, @Nullable Object secondExcluded, Object ... restOfExcluded) {
        this.containsNoneIn(SubjectUtils.accumulate(firstExcluded, secondExcluded, restOfExcluded));
    }

    public final void containsNoneIn(Iterable<?> excluded) {
        Collection actual = SubjectUtils.iterableToCollection((Iterable)Preconditions.checkNotNull(this.actual));
        ArrayList<@Nullable E> present = new ArrayList();
        for (Object item : Sets.newLinkedHashSet(excluded)) {
            if (!actual.contains(item)) continue;
            present.add(item);
        }
        if (!present.isEmpty()) {
            this.failWithoutActual(Fact.fact("expected not to contain any of", SubjectUtils.annotateEmptyStrings(excluded)), Fact.fact("but contained", SubjectUtils.annotateEmptyStrings(present)), this.fullContents());
        }
    }

    public final void containsNoneIn(@Nullable Object[] excluded) {
        this.containsNoneIn(SubjectUtils.asList(excluded));
    }

    public void isInStrictOrder() {
        this.isInStrictOrder((Comparator<?>)Ordering.natural());
    }

    public final void isInStrictOrder(final Comparator<?> comparator) {
        Preconditions.checkNotNull(comparator);
        this.pairwiseCheck("expected to be in strict order", new PairwiseChecker(this){

            @Override
            public boolean check(@Nullable Object prev, @Nullable Object next) {
                return comparator.compare(prev, next) < 0;
            }
        });
    }

    public void isInOrder() {
        this.isInOrder((Comparator<?>)Ordering.natural());
    }

    public final void isInOrder(final Comparator<?> comparator) {
        Preconditions.checkNotNull(comparator);
        this.pairwiseCheck("expected to be in order", new PairwiseChecker(this){

            @Override
            public boolean check(@Nullable Object prev, @Nullable Object next) {
                return comparator.compare(prev, next) <= 0;
            }
        });
    }

    private void pairwiseCheck(String expectedFact, PairwiseChecker checker) {
        Iterator iterator = ((Iterable)Preconditions.checkNotNull(this.actual)).iterator();
        if (iterator.hasNext()) {
            Object prev = iterator.next();
            while (iterator.hasNext()) {
                Object next = iterator.next();
                if (!checker.check(prev, next)) {
                    this.failWithoutActual(Fact.simpleFact(expectedFact), Fact.fact("but contained", prev), Fact.fact("followed by", next), this.fullContents());
                    return;
                }
                prev = next;
            }
        }
    }

    @Override
    @Deprecated
    public void isNoneOf(@Nullable Object first, @Nullable Object second, Object ... rest) {
        super.isNoneOf(first, second, rest);
    }

    @Override
    @Deprecated
    public void isNotIn(@Nullable Iterable<?> iterable) {
        Preconditions.checkNotNull(iterable);
        if (Iterables.contains(iterable, this.actual)) {
            this.failWithActual("expected not to be any of", iterable);
        }
        ArrayList<@Nullable ?> nonIterables = new ArrayList();
        for (Object element : iterable) {
            if (element instanceof Iterable) continue;
            nonIterables.add(element);
        }
        if (!nonIterables.isEmpty()) {
            this.failWithoutActual(Fact.simpleFact(Strings.lenientFormat((String)"The actual value is an Iterable, and you've written a test that compares it to some objects that are not Iterables. Did you instead mean to check whether its *contents* match any of the *contents* of the given values? If so, call containsNoneOf(...)/containsNoneIn(...) instead. Non-iterables: %s", (Object[])new Object[]{nonIterables})), new Fact[0]);
        }
    }

    private Fact fullContents() {
        return Fact.fact("full contents", this.actualCustomStringRepresentationForPackageMembersToCall());
    }

    public <A, E> UsingCorrespondence<A, E> comparingElementsUsing(Correspondence<? super A, ? super E> correspondence) {
        return new UsingCorrespondence<A, E>(this, correspondence);
    }

    public <T> UsingCorrespondence<T, T> formattingDiffsUsing(Correspondence.DiffFormatter<? super T, ? super T> formatter) {
        return this.comparingElementsUsing(Correspondence.equality().formattingDiffsUsing(formatter));
    }

    public static class UsingCorrespondence<A, E> {
        private final IterableSubject subject;
        private final Correspondence<? super A, ? super E> correspondence;
        private final Optional<Pairer> pairer;

        UsingCorrespondence(IterableSubject subject, Correspondence<? super A, ? super E> correspondence) {
            this.subject = (IterableSubject)Preconditions.checkNotNull((Object)subject);
            this.correspondence = (Correspondence)Preconditions.checkNotNull(correspondence);
            this.pairer = Optional.absent();
        }

        UsingCorrespondence(IterableSubject subject, Correspondence<? super A, ? super E> correspondence, Pairer pairer) {
            this.subject = (IterableSubject)Preconditions.checkNotNull((Object)subject);
            this.correspondence = (Correspondence)Preconditions.checkNotNull(correspondence);
            this.pairer = Optional.of((Object)pairer);
        }

        @Deprecated
        @DoNotCall(value="UsingCorrespondence.equals() is not supported. Did you mean to call containsExactlyElementsIn(expected) instead of equals(expected)?")
        public final boolean equals(@Nullable Object o) {
            throw new UnsupportedOperationException("UsingCorrespondence.equals() is not supported. Did you mean to call containsExactlyElementsIn(expected) instead of equals(expected)?");
        }

        @Deprecated
        @DoNotCall(value="UsingCorrespondence.hashCode() is not supported.")
        public final int hashCode() {
            throw new UnsupportedOperationException("UsingCorrespondence.hashCode() is not supported.");
        }

        @Deprecated
        @DoNotCall(value="UsingCorrespondence.toString() is not supported.")
        public final String toString() {
            throw new UnsupportedOperationException("UsingCorrespondence.toString() is not supported. Did you mean to call assertThat(foo.toString()) instead of assertThat(foo).toString()?");
        }

        public UsingCorrespondence<A, E> displayingDiffsPairedBy(Function<? super E, ?> keyFunction) {
            Function<? super E, ?> actualKeyFunction = keyFunction;
            return this.displayingDiffsPairedBy(actualKeyFunction, keyFunction);
        }

        public UsingCorrespondence<A, E> displayingDiffsPairedBy(Function<? super A, ?> actualKeyFunction, Function<? super E, ?> expectedKeyFunction) {
            return new UsingCorrespondence<A, E>(this.subject, this.correspondence, new Pairer(actualKeyFunction, expectedKeyFunction));
        }

        public void contains(E expected) {
            List keyMatches;
            Correspondence.ExceptionStore exceptions = Correspondence.ExceptionStore.forIterable();
            for (A actual : this.getCastActual()) {
                if (!this.correspondence.safeCompare(actual, expected, exceptions)) continue;
                if (exceptions.hasCompareException()) {
                    this.subject.failWithoutActual((Iterable<Fact>)ImmutableList.builder().addAll(exceptions.describeAsMainCause()).add((Object)Fact.fact("expected to contain", expected)).addAll(this.correspondence.describeForIterable()).add((Object)Fact.fact("found match (but failing because of exception)", actual)).add((Object)this.subject.fullContents()).build());
                }
                return;
            }
            if (this.pairer.isPresent() && !(keyMatches = ((Pairer)this.pairer.get()).pairOne(expected, this.getCastActual(), exceptions)).isEmpty()) {
                this.subject.failWithoutActual((Iterable<Fact>)ImmutableList.builder().add((Object)Fact.fact("expected to contain", expected)).addAll(this.correspondence.describeForIterable()).add((Object)Fact.simpleFact("but did not")).addAll(this.formatExtras("though it did contain elements with correct key", expected, keyMatches, exceptions)).add((Object)Fact.simpleFact("---")).add((Object)this.subject.fullContents()).addAll(exceptions.describeAsAdditionalInfo()).build());
                return;
            }
            this.subject.failWithoutActual((Iterable<Fact>)ImmutableList.builder().add((Object)Fact.fact("expected to contain", expected)).addAll(this.correspondence.describeForIterable()).add((Object)this.subject.butWas()).addAll(exceptions.describeAsAdditionalInfo()).build());
        }

        public void doesNotContain(E excluded) {
            Correspondence.ExceptionStore exceptions = Correspondence.ExceptionStore.forIterable();
            ArrayList<A> matchingElements = new ArrayList<A>();
            for (A actual : this.getCastActual()) {
                if (!this.correspondence.safeCompare(actual, excluded, exceptions)) continue;
                matchingElements.add(actual);
            }
            if (!matchingElements.isEmpty()) {
                this.subject.failWithoutActual((Iterable<Fact>)ImmutableList.builder().add((Object)Fact.fact("expected not to contain", excluded)).addAll(this.correspondence.describeForIterable()).add((Object)Fact.fact("but contained", SubjectUtils.countDuplicates(matchingElements))).add((Object)this.subject.fullContents()).addAll(exceptions.describeAsAdditionalInfo()).build());
                return;
            }
            if (exceptions.hasCompareException()) {
                this.subject.failWithoutActual((Iterable<Fact>)ImmutableList.builder().addAll(exceptions.describeAsMainCause()).add((Object)Fact.fact("expected not to contain", excluded)).addAll(this.correspondence.describeForIterable()).add((Object)Fact.simpleFact("found no match (but failing because of exception)")).add((Object)this.subject.fullContents()).build());
            }
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Ordered containsExactly(E ... expected) {
            return this.containsExactlyElementsIn(expected == null ? Lists.newArrayList((Object[])new Object[]{null}) : SubjectUtils.asList(expected));
        }

        @CanIgnoreReturnValue
        public Ordered containsExactlyElementsIn(final @Nullable Iterable<? extends E> expected) {
            List<A> actualList = SubjectUtils.iterableToList(this.getCastActual());
            List expectedList = SubjectUtils.iterableToList((Iterable)Preconditions.checkNotNull(expected));
            if (expectedList.isEmpty()) {
                if (actualList.isEmpty()) {
                    return IN_ORDER;
                }
                this.subject.isEmpty();
                return ALREADY_FAILED;
            }
            if (this.correspondInOrderExactly(actualList.iterator(), expectedList.iterator())) {
                return IN_ORDER;
            }
            Correspondence.ExceptionStore exceptions = Correspondence.ExceptionStore.forIterable();
            ImmutableSetMultimap<Integer, Integer> candidateMapping = this.findCandidateMapping(actualList, expectedList, exceptions);
            if (this.failIfCandidateMappingHasMissingOrExtra(actualList, expectedList, candidateMapping, exceptions)) {
                return ALREADY_FAILED;
            }
            ImmutableBiMap<Integer, Integer> maximalOneToOneMapping = this.findMaximalOneToOneMapping((ImmutableMultimap<Integer, Integer>)candidateMapping);
            if (this.failIfOneToOneMappingHasMissingOrExtra((List<? extends A>)actualList, expectedList, (BiMap<Integer, Integer>)maximalOneToOneMapping, exceptions)) {
                return ALREADY_FAILED;
            }
            if (exceptions.hasCompareException()) {
                this.subject.failWithoutActual((Iterable<Fact>)ImmutableList.builder().addAll(exceptions.describeAsMainCause()).add((Object)Fact.fact("expected", expected)).addAll(this.correspondence.describeForIterable()).add((Object)Fact.simpleFact("found all expected elements (but failing because of exception)")).add((Object)this.subject.fullContents()).build());
                return ALREADY_FAILED;
            }
            return new Ordered(){

                @Override
                public void inOrder() {
                    subject.failWithActual((Iterable<Fact>)ImmutableList.builder().add((Object)Fact.simpleFact("contents match, but order was wrong")).add((Object)Fact.fact("expected", expected)).addAll(correspondence.describeForIterable()).build());
                }
            };
        }

        @CanIgnoreReturnValue
        public Ordered containsExactlyElementsIn(E @Nullable [] expected) {
            return this.containsExactlyElementsIn(SubjectUtils.asList((Object[])Preconditions.checkNotNull(expected)));
        }

        private boolean correspondInOrderExactly(Iterator<? extends A> actual, Iterator<? extends E> expected) {
            Correspondence.ExceptionStore exceptions = Correspondence.ExceptionStore.forIterable();
            while (actual.hasNext() && expected.hasNext()) {
                E expectedElement;
                A actualElement = actual.next();
                if (this.correspondence.safeCompare(actualElement, expectedElement = expected.next(), exceptions)) continue;
                return false;
            }
            return !actual.hasNext() && !expected.hasNext();
        }

        private ImmutableSetMultimap<Integer, Integer> findCandidateMapping(List<? extends A> actual, List<? extends E> expected, Correspondence.ExceptionStore exceptions) {
            ImmutableSetMultimap.Builder mapping = ImmutableSetMultimap.builder();
            for (int actualIndex = 0; actualIndex < actual.size(); ++actualIndex) {
                for (int expectedIndex = 0; expectedIndex < expected.size(); ++expectedIndex) {
                    if (!this.correspondence.safeCompare(actual.get(actualIndex), expected.get(expectedIndex), exceptions)) continue;
                    mapping.put((Object)actualIndex, (Object)expectedIndex);
                }
            }
            return mapping.build();
        }

        private boolean failIfCandidateMappingHasMissingOrExtra(List<? extends A> actual, List<? extends E> expected, ImmutableSetMultimap<Integer, Integer> mapping, Correspondence.ExceptionStore exceptions) {
            List<A> extra = this.findNotIndexed(actual, (Set<Integer>)mapping.keySet());
            List<E> missing = this.findNotIndexed(expected, (Set<Integer>)mapping.inverse().keySet());
            if (!missing.isEmpty() || !extra.isEmpty()) {
                this.subject.failWithoutActual((Iterable<Fact>)ImmutableList.builder().addAll(this.describeMissingOrExtra(missing, extra, exceptions)).add((Object)Fact.fact("expected", expected)).addAll(this.correspondence.describeForIterable()).add((Object)this.subject.butWas()).addAll(exceptions.describeAsAdditionalInfo()).build());
                return true;
            }
            return false;
        }

        private ImmutableList<Fact> describeMissingOrExtra(List<? extends E> missing, List<? extends A> extra, Correspondence.ExceptionStore exceptions) {
            if (this.pairer.isPresent()) {
                Pairing pairing = ((Pairer)this.pairer.get()).pair(missing, extra, exceptions);
                if (pairing != null) {
                    return this.describeMissingOrExtraWithPairing(pairing, exceptions);
                }
                return ImmutableList.builder().addAll(this.describeMissingOrExtraWithoutPairing(missing, extra)).add((Object)Fact.simpleFact("a key function which does not uniquely key the expected elements was provided and has consequently been ignored")).build();
            }
            if (missing.size() == 1 && extra.size() >= 1) {
                return ImmutableList.builder().add((Object)Fact.fact("missing (1)", missing.get(0))).addAll(this.formatExtras("unexpected", missing.get(0), extra, exceptions)).add((Object)Fact.simpleFact("---")).build();
            }
            return this.describeMissingOrExtraWithoutPairing(missing, extra);
        }

        private ImmutableList<Fact> describeMissingOrExtraWithoutPairing(List<? extends E> missing, List<? extends A> extra) {
            return IterableSubject.makeElementFactsForBoth("missing", missing, "unexpected", extra);
        }

        private ImmutableList<Fact> describeMissingOrExtraWithPairing(Pairing pairing, Correspondence.ExceptionStore exceptions) {
            ImmutableList.Builder facts = ImmutableList.builder();
            for (Object key : pairing.pairedKeysToExpectedValues.keySet()) {
                Object missing = pairing.pairedKeysToExpectedValues.get(key);
                List extras = pairing.pairedKeysToActualValues.get(key);
                facts.add((Object)Fact.fact("for key", key));
                facts.add((Object)Fact.fact("missing", missing));
                facts.addAll(this.formatExtras("unexpected", missing, extras, exceptions));
                facts.add((Object)Fact.simpleFact("---"));
            }
            if (!pairing.unpairedActualValues.isEmpty() || !pairing.unpairedExpectedValues.isEmpty()) {
                facts.add((Object)Fact.simpleFact("elements without matching keys:"));
                facts.addAll(this.describeMissingOrExtraWithoutPairing(pairing.unpairedExpectedValues, pairing.unpairedActualValues));
            }
            return facts.build();
        }

        private ImmutableList<Fact> formatExtras(String label, E missing, List<? extends A> extras, Correspondence.ExceptionStore exceptions) {
            ArrayList<@Nullable String> diffs = new ArrayList<String>(extras.size());
            boolean hasDiffs = false;
            for (int i = 0; i < extras.size(); ++i) {
                A extra = extras.get(i);
                String diff = this.correspondence.safeFormatDiff(extra, missing, exceptions);
                diffs.add(diff);
                if (diff == null) continue;
                hasDiffs = true;
            }
            if (hasDiffs) {
                ImmutableList.Builder extraFacts = ImmutableList.builder();
                extraFacts.add((Object)Fact.simpleFact(Strings.lenientFormat((String)"%s (%s)", (Object[])new Object[]{label, extras.size()})));
                for (int i = 0; i < extras.size(); ++i) {
                    A extra = extras.get(i);
                    extraFacts.add((Object)Fact.fact(Strings.lenientFormat((String)"#%s", (Object[])new Object[]{i + 1}), extra));
                    if (diffs.get(i) == null) continue;
                    extraFacts.add((Object)Fact.fact("diff", diffs.get(i)));
                }
                return extraFacts.build();
            }
            return ImmutableList.of((Object)Fact.fact(Strings.lenientFormat((String)"%s (%s)", (Object[])new Object[]{label, extras.size()}), SubjectUtils.countDuplicates(extras)));
        }

        private <T> List<T> findNotIndexed(List<T> list, Set<Integer> indexes) {
            if (indexes.size() == list.size()) {
                return SubjectUtils.asList(new Object[0]);
            }
            ArrayList notIndexed = Lists.newArrayList();
            for (int index = 0; index < list.size(); ++index) {
                if (indexes.contains(index)) continue;
                notIndexed.add(list.get(index));
            }
            return notIndexed;
        }

        private ImmutableBiMap<Integer, Integer> findMaximalOneToOneMapping(ImmutableMultimap<Integer, Integer> edges) {
            return GraphMatching.maximumCardinalityBipartiteMatching(edges);
        }

        private boolean failIfOneToOneMappingHasMissingOrExtra(List<? extends A> actual, List<? extends E> expected, BiMap<Integer, Integer> mapping, Correspondence.ExceptionStore exceptions) {
            List<A> extra = this.findNotIndexed(actual, mapping.keySet());
            List<E> missing = this.findNotIndexed(expected, mapping.values());
            if (!missing.isEmpty() || !extra.isEmpty()) {
                this.subject.failWithoutActual((Iterable<Fact>)ImmutableList.builder().add((Object)Fact.simpleFact("in an assertion requiring a 1:1 mapping between the expected and the actual elements, each actual element matches as least one expected element, and vice versa, but there was no 1:1 mapping")).add((Object)Fact.simpleFact("using the most complete 1:1 mapping (or one such mapping, if there is a tie)")).addAll(this.describeMissingOrExtra(missing, extra, exceptions)).add((Object)Fact.fact("expected", expected)).addAll(this.correspondence.describeForIterable()).add((Object)this.subject.butWas()).addAll(exceptions.describeAsAdditionalInfo()).build());
                return true;
            }
            return false;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Ordered containsAtLeast(E first, E second, E ... rest) {
            return this.containsAtLeastElementsIn(SubjectUtils.accumulate(first, second, rest));
        }

        @CanIgnoreReturnValue
        public Ordered containsAtLeastElementsIn(final Iterable<? extends E> expected) {
            List<A> actualList = SubjectUtils.iterableToList(this.getCastActual());
            List<E> expectedList = SubjectUtils.iterableToList(expected);
            if (this.correspondInOrderAllIn(actualList.iterator(), expectedList.iterator())) {
                return IN_ORDER;
            }
            Correspondence.ExceptionStore exceptions = Correspondence.ExceptionStore.forIterable();
            ImmutableSetMultimap<Integer, Integer> candidateMapping = this.findCandidateMapping(actualList, expectedList, exceptions);
            if (this.failIfCandidateMappingHasMissing(actualList, expectedList, candidateMapping, exceptions)) {
                return ALREADY_FAILED;
            }
            ImmutableBiMap<Integer, Integer> maximalOneToOneMapping = this.findMaximalOneToOneMapping((ImmutableMultimap<Integer, Integer>)candidateMapping);
            if (this.failIfOneToOneMappingHasMissing((List<? extends A>)actualList, (List<? extends E>)expectedList, (BiMap<Integer, Integer>)maximalOneToOneMapping, exceptions)) {
                return ALREADY_FAILED;
            }
            if (exceptions.hasCompareException()) {
                this.subject.failWithoutActual((Iterable<Fact>)ImmutableList.builder().addAll(exceptions.describeAsMainCause()).add((Object)Fact.fact("expected to contain at least", expected)).addAll(this.correspondence.describeForIterable()).add((Object)Fact.simpleFact("found all expected elements (but failing because of exception)")).add((Object)this.subject.fullContents()).build());
                return ALREADY_FAILED;
            }
            return new Ordered(){

                @Override
                public void inOrder() {
                    subject.failWithActual((Iterable<Fact>)ImmutableList.builder().add((Object)Fact.simpleFact("required elements were all found, but order was wrong")).add((Object)Fact.fact("expected order for required elements", expected)).addAll(correspondence.describeForIterable()).build());
                }
            };
        }

        @CanIgnoreReturnValue
        public Ordered containsAtLeastElementsIn(E[] expected) {
            return this.containsAtLeastElementsIn(SubjectUtils.asList(expected));
        }

        private boolean correspondInOrderAllIn(Iterator<? extends A> actual, Iterator<? extends E> expected) {
            Correspondence.ExceptionStore exceptions = Correspondence.ExceptionStore.forIterable();
            while (expected.hasNext()) {
                E expectedElement = expected.next();
                if (this.findCorresponding(actual, expectedElement, exceptions) && !exceptions.hasCompareException()) continue;
                return false;
            }
            return true;
        }

        private boolean findCorresponding(Iterator<? extends A> actual, E expectedElement, Correspondence.ExceptionStore exceptions) {
            while (actual.hasNext()) {
                A actualElement = actual.next();
                if (!this.correspondence.safeCompare(actualElement, expectedElement, exceptions)) continue;
                return true;
            }
            return false;
        }

        private boolean failIfCandidateMappingHasMissing(List<? extends A> actual, List<? extends E> expected, ImmutableSetMultimap<Integer, Integer> mapping, Correspondence.ExceptionStore exceptions) {
            List<E> missing = this.findNotIndexed(expected, (Set<Integer>)mapping.inverse().keySet());
            if (!missing.isEmpty()) {
                List<? extends A> extra = this.findNotIndexed(actual, (Set<Integer>)mapping.keySet());
                this.subject.failWithoutActual((Iterable<Fact>)ImmutableList.builder().addAll(this.describeMissing(missing, extra, exceptions)).add((Object)Fact.fact("expected to contain at least", expected)).addAll(this.correspondence.describeForIterable()).add((Object)this.subject.butWas()).addAll(exceptions.describeAsAdditionalInfo()).build());
                return true;
            }
            return false;
        }

        private ImmutableList<Fact> describeMissing(List<? extends E> missing, List<? extends A> extra, Correspondence.ExceptionStore exceptions) {
            if (this.pairer.isPresent()) {
                Pairing pairing = ((Pairer)this.pairer.get()).pair(missing, extra, exceptions);
                if (pairing != null) {
                    return this.describeMissingWithPairing(pairing, exceptions);
                }
                return ImmutableList.builder().addAll(this.describeMissingWithoutPairing(missing)).add((Object)Fact.simpleFact("a key function which does not uniquely key the expected elements was provided and has consequently been ignored")).build();
            }
            return this.describeMissingWithoutPairing(missing);
        }

        private ImmutableList<Fact> describeMissingWithoutPairing(List<? extends E> missing) {
            return IterableSubject.makeElementFactsForBoth("missing", missing, "unexpected", (Collection)ImmutableList.of());
        }

        private ImmutableList<Fact> describeMissingWithPairing(Pairing pairing, Correspondence.ExceptionStore exceptions) {
            ImmutableList.Builder facts = ImmutableList.builder();
            for (Object key : pairing.pairedKeysToExpectedValues.keySet()) {
                Object missing = pairing.pairedKeysToExpectedValues.get(key);
                List extras = pairing.pairedKeysToActualValues.get(key);
                facts.add((Object)Fact.fact("for key", key));
                facts.add((Object)Fact.fact("missing", missing));
                facts.addAll(this.formatExtras("did contain elements with that key", missing, extras, exceptions));
                facts.add((Object)Fact.simpleFact("---"));
            }
            if (!pairing.unpairedExpectedValues.isEmpty()) {
                facts.add((Object)Fact.simpleFact("elements without matching keys:"));
                facts.addAll(this.describeMissingWithoutPairing(pairing.unpairedExpectedValues));
            }
            return facts.build();
        }

        private boolean failIfOneToOneMappingHasMissing(List<? extends A> actual, List<? extends E> expected, BiMap<Integer, Integer> mapping, Correspondence.ExceptionStore exceptions) {
            List<E> missing = this.findNotIndexed(expected, mapping.values());
            if (!missing.isEmpty()) {
                List<? extends A> extra = this.findNotIndexed(actual, mapping.keySet());
                this.subject.failWithoutActual((Iterable<Fact>)ImmutableList.builder().add((Object)Fact.simpleFact("in an assertion requiring a 1:1 mapping between the expected and a subset of the actual elements, each actual element matches as least one expected element, and vice versa, but there was no 1:1 mapping")).add((Object)Fact.simpleFact("using the most complete 1:1 mapping (or one such mapping, if there is a tie)")).addAll(this.describeMissing(missing, extra, exceptions)).add((Object)Fact.fact("expected to contain at least", expected)).addAll(this.correspondence.describeForIterable()).add((Object)this.subject.butWas()).addAll(exceptions.describeAsAdditionalInfo()).build());
                return true;
            }
            return false;
        }

        @SafeVarargs
        public final void containsAnyOf(E first, E second, E ... rest) {
            this.containsAnyIn(SubjectUtils.accumulate(first, second, rest));
        }

        public void containsAnyIn(Iterable<? extends E> expected) {
            Collection<A> actual = SubjectUtils.iterableToCollection(this.getCastActual());
            Correspondence.ExceptionStore exceptions = Correspondence.ExceptionStore.forIterable();
            for (E expectedItem : expected) {
                for (A actualItem : actual) {
                    if (!this.correspondence.safeCompare(actualItem, expectedItem, exceptions)) continue;
                    if (exceptions.hasCompareException()) {
                        this.subject.failWithoutActual((Iterable<Fact>)ImmutableList.builder().addAll(exceptions.describeAsMainCause()).add((Object)Fact.fact("expected to contain any of", expected)).addAll(this.correspondence.describeForIterable()).add((Object)Fact.simpleFact("found match (but failing because of exception)")).add((Object)this.subject.fullContents()).build());
                    }
                    return;
                }
            }
            if (this.pairer.isPresent()) {
                Pairing pairing = ((Pairer)this.pairer.get()).pair(SubjectUtils.iterableToList(expected), SubjectUtils.iterableToList(actual), exceptions);
                if (pairing != null) {
                    if (!pairing.pairedKeysToExpectedValues.isEmpty()) {
                        this.subject.failWithoutActual((Iterable<Fact>)ImmutableList.builder().add((Object)Fact.fact("expected to contain any of", expected)).addAll(this.correspondence.describeForIterable()).add((Object)this.subject.butWas()).addAll(this.describeAnyMatchesByKey(pairing, exceptions)).addAll(exceptions.describeAsAdditionalInfo()).build());
                    } else {
                        this.subject.failWithoutActual((Iterable<Fact>)ImmutableList.builder().add((Object)Fact.fact("expected to contain any of", expected)).addAll(this.correspondence.describeForIterable()).add((Object)this.subject.butWas()).add((Object)Fact.simpleFact("it does not contain any matches by key, either")).addAll(exceptions.describeAsAdditionalInfo()).build());
                    }
                } else {
                    this.subject.failWithoutActual((Iterable<Fact>)ImmutableList.builder().add((Object)Fact.fact("expected to contain any of", expected)).addAll(this.correspondence.describeForIterable()).add((Object)this.subject.butWas()).add((Object)Fact.simpleFact("a key function which does not uniquely key the expected elements was provided and has consequently been ignored")).addAll(exceptions.describeAsAdditionalInfo()).build());
                }
            } else {
                this.subject.failWithoutActual((Iterable<Fact>)ImmutableList.builder().add((Object)Fact.fact("expected to contain any of", expected)).addAll(this.correspondence.describeForIterable()).add((Object)this.subject.butWas()).addAll(exceptions.describeAsAdditionalInfo()).build());
            }
        }

        public void containsAnyIn(E[] expected) {
            this.containsAnyIn(SubjectUtils.asList(expected));
        }

        private ImmutableList<Fact> describeAnyMatchesByKey(Pairing pairing, Correspondence.ExceptionStore exceptions) {
            ImmutableList.Builder facts = ImmutableList.builder();
            for (Object key : pairing.pairedKeysToExpectedValues.keySet()) {
                Object expected = pairing.pairedKeysToExpectedValues.get(key);
                List got = pairing.pairedKeysToActualValues.get(key);
                facts.add((Object)Fact.fact("for key", key));
                facts.add((Object)Fact.fact("expected any of", expected));
                facts.addAll(this.formatExtras("but got", expected, got, exceptions));
                facts.add((Object)Fact.simpleFact("---"));
            }
            return facts.build();
        }

        @SafeVarargs
        public final void containsNoneOf(E firstExcluded, E secondExcluded, E ... restOfExcluded) {
            this.containsNoneIn(SubjectUtils.accumulate(firstExcluded, secondExcluded, restOfExcluded));
        }

        public void containsNoneIn(Iterable<? extends E> excluded) {
            Collection<A> actual = SubjectUtils.iterableToCollection(this.getCastActual());
            LinkedListMultimap present = LinkedListMultimap.create();
            Correspondence.ExceptionStore exceptions = Correspondence.ExceptionStore.forIterable();
            for (Object excludedItem : Sets.newLinkedHashSet(excluded)) {
                for (A actualItem : actual) {
                    if (!this.correspondence.safeCompare(actualItem, excludedItem, exceptions)) continue;
                    present.put(excludedItem, actualItem);
                }
            }
            if (!present.isEmpty()) {
                ImmutableList.Builder facts = ImmutableList.builder();
                facts.add((Object)Fact.fact("expected not to contain any of", SubjectUtils.annotateEmptyStrings(excluded)));
                facts.addAll(this.correspondence.describeForIterable());
                for (Object excludedItem : present.keySet()) {
                    List actualItems = present.get(excludedItem);
                    facts.add((Object)Fact.fact("but contained", SubjectUtils.annotateEmptyStrings(actualItems)));
                    facts.add((Object)Fact.fact("corresponding to", excludedItem));
                    facts.add((Object)Fact.simpleFact("---"));
                }
                facts.add((Object)this.subject.fullContents());
                facts.addAll(exceptions.describeAsAdditionalInfo());
                this.subject.failWithoutActual((Iterable<Fact>)facts.build());
                return;
            }
            if (exceptions.hasCompareException()) {
                this.subject.failWithoutActual((Iterable<Fact>)ImmutableList.builder().addAll(exceptions.describeAsMainCause()).add((Object)Fact.fact("expected not to contain any of", SubjectUtils.annotateEmptyStrings(excluded))).addAll(this.correspondence.describeForIterable()).add((Object)Fact.simpleFact("found no matches (but failing because of exception)")).add((Object)this.subject.fullContents()).build());
            }
        }

        public void containsNoneIn(E[] excluded) {
            this.containsNoneIn(SubjectUtils.asList(excluded));
        }

        private Iterable<A> getCastActual() {
            return (Iterable)Preconditions.checkNotNull((Object)this.subject.actual);
        }

        private final class Pairing {
            private final Map<Object, E> pairedKeysToExpectedValues = new LinkedHashMap();
            private final ListMultimap<Object, A> pairedKeysToActualValues = LinkedListMultimap.create();
            private final List<E> unpairedExpectedValues = Lists.newArrayList();
            private final List<A> unpairedActualValues = Lists.newArrayList();

            private Pairing(UsingCorrespondence usingCorrespondence) {
            }
        }

        private final class Pairer {
            private final Function<? super A, ?> actualKeyFunction;
            private final Function<? super E, ?> expectedKeyFunction;

            Pairer(Function<? super A, ?> actualKeyFunction, Function<? super E, ?> expectedKeyFunction) {
                this.actualKeyFunction = actualKeyFunction;
                this.expectedKeyFunction = expectedKeyFunction;
            }

            @Nullable Pairing pair(List<? extends E> expectedValues, List<? extends A> actualValues, Correspondence.ExceptionStore exceptions) {
                Object key;
                Object expected2;
                Pairing pairing = new Pairing(UsingCorrespondence.this);
                ArrayList<@Nullable Object> expectedKeys = new ArrayList<Object>(expectedValues.size());
                for (Object expected2 : expectedValues) {
                    expectedKeys.add(this.expectedKey(expected2, exceptions));
                }
                for (int i = 0; i < expectedValues.size(); ++i) {
                    expected2 = expectedValues.get(i);
                    key = expectedKeys.get(i);
                    if (key == null) continue;
                    if (pairing.pairedKeysToExpectedValues.containsKey(key)) {
                        return null;
                    }
                    pairing.pairedKeysToExpectedValues.put(key, expected2);
                }
                for (Object actual : actualValues) {
                    key = this.actualKey(actual, exceptions);
                    if (pairing.pairedKeysToExpectedValues.containsKey(key)) {
                        pairing.pairedKeysToActualValues.put(Preconditions.checkNotNull(key), actual);
                        continue;
                    }
                    pairing.unpairedActualValues.add(actual);
                }
                for (int i = 0; i < expectedValues.size(); ++i) {
                    expected2 = expectedValues.get(i);
                    key = expectedKeys.get(i);
                    if (pairing.pairedKeysToActualValues.containsKey(key)) continue;
                    pairing.unpairedExpectedValues.add(expected2);
                    pairing.pairedKeysToExpectedValues.remove(key);
                }
                return pairing;
            }

            List<A> pairOne(E expectedValue, Iterable<? extends A> actualValues, Correspondence.ExceptionStore exceptions) {
                Object key = this.expectedKey(expectedValue, exceptions);
                ArrayList matches = new ArrayList();
                if (key != null) {
                    for (Object actual : actualValues) {
                        if (!key.equals(this.actualKey(actual, exceptions))) continue;
                        matches.add(actual);
                    }
                }
                return matches;
            }

            private @Nullable Object actualKey(A actual, Correspondence.ExceptionStore exceptions) {
                try {
                    return this.actualKeyFunction.apply(actual);
                }
                catch (RuntimeException e) {
                    exceptions.addActualKeyFunctionException(Pairer.class, e, actual);
                    return null;
                }
            }

            private @Nullable Object expectedKey(E expected, Correspondence.ExceptionStore exceptions) {
                try {
                    return this.expectedKeyFunction.apply(expected);
                }
                catch (RuntimeException e) {
                    exceptions.addExpectedKeyFunctionException(Pairer.class, e, expected);
                    return null;
                }
            }
        }
    }

    private static interface PairwiseChecker {
        public boolean check(@Nullable Object var1, @Nullable Object var2);
    }

    static enum ElementFactGrouping {
        ALL_IN_ONE_FACT,
        FACT_PER_ELEMENT;

    }
}

