/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.types;

import com.google.common.collect.ImmutableList;
import com.google.turbine.type.AnnoInfo;
import com.google.turbine.type.Type;

public class Deannotate {
    public static Type deannotate(Type ty) {
        return switch (ty.tyKind()) {
            default -> throw new MatchException(null, null);
            case Type.TyKind.CLASS_TY -> Deannotate.deannotateClassTy((Type.ClassTy)ty);
            case Type.TyKind.ARRAY_TY -> Type.ArrayTy.create(Deannotate.deannotate(((Type.ArrayTy)ty).elementType()), (ImmutableList<AnnoInfo>)ImmutableList.of());
            case Type.TyKind.INTERSECTION_TY -> Type.IntersectionTy.create(Deannotate.deannotate(((Type.IntersectionTy)ty).bounds()));
            case Type.TyKind.WILD_TY -> Deannotate.deannotateWildTy((Type.WildTy)ty);
            case Type.TyKind.METHOD_TY -> Deannotate.deannotateMethodTy((Type.MethodTy)ty);
            case Type.TyKind.PRIM_TY -> Type.PrimTy.create(((Type.PrimTy)ty).primkind(), (ImmutableList<AnnoInfo>)ImmutableList.of());
            case Type.TyKind.TY_VAR -> Type.TyVar.create(((Type.TyVar)ty).sym(), (ImmutableList<AnnoInfo>)ImmutableList.of());
            case Type.TyKind.VOID_TY, Type.TyKind.ERROR_TY, Type.TyKind.NONE_TY -> ty;
        };
    }

    public static ImmutableList<Type> deannotate(ImmutableList<Type> types) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (Type type : types) {
            result.add((Object)Deannotate.deannotate(type));
        }
        return result.build();
    }

    public static Type.ClassTy deannotateClassTy(Type.ClassTy ty) {
        ImmutableList.Builder classes = ImmutableList.builder();
        for (Type.ClassTy.SimpleClassTy c : ty.classes()) {
            classes.add((Object)Type.ClassTy.SimpleClassTy.create(c.sym(), Deannotate.deannotate(c.targs()), (ImmutableList<AnnoInfo>)ImmutableList.of()));
        }
        return Type.ClassTy.create((Iterable<Type.ClassTy.SimpleClassTy>)classes.build());
    }

    private static Type deannotateWildTy(Type.WildTy ty) {
        return switch (ty.boundKind()) {
            default -> throw new MatchException(null, null);
            case Type.WildTy.BoundKind.NONE -> Type.WildUnboundedTy.create((ImmutableList<AnnoInfo>)ImmutableList.of());
            case Type.WildTy.BoundKind.LOWER -> Type.WildLowerBoundedTy.create(Deannotate.deannotate(ty.bound()), (ImmutableList<AnnoInfo>)ImmutableList.of());
            case Type.WildTy.BoundKind.UPPER -> Type.WildUpperBoundedTy.create(Deannotate.deannotate(ty.bound()), (ImmutableList<AnnoInfo>)ImmutableList.of());
        };
    }

    private static Type deannotateMethodTy(Type.MethodTy ty) {
        return Type.MethodTy.create(ty.tyParams(), Deannotate.deannotate(ty.returnType()), ty.receiverType() != null ? Deannotate.deannotate(ty.receiverType()) : null, Deannotate.deannotate(ty.parameters()), Deannotate.deannotate(ty.thrown()));
    }

    private Deannotate() {
    }
}

