/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.parse;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.turbine.diag.TurbineError;
import com.google.turbine.model.Const;
import com.google.turbine.model.TurbineConstantTypeKind;
import com.google.turbine.parse.Lexer;
import com.google.turbine.parse.Token;
import com.google.turbine.tree.Tree;
import com.google.turbine.tree.TurbineOperatorKind;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

public class ConstExpressionParser {
    Token token;
    private int position;
    private final Lexer lexer;

    public ConstExpressionParser(Lexer lexer, Token token, int position) {
        this.lexer = lexer;
        this.token = token;
        this.position = position;
    }

    private static @Nullable TurbineOperatorKind operator(Token token) {
        return switch (token) {
            case Token.ASSIGN -> TurbineOperatorKind.ASSIGN;
            case Token.MULT -> TurbineOperatorKind.MULT;
            case Token.DIV -> TurbineOperatorKind.DIVIDE;
            case Token.MOD -> TurbineOperatorKind.MODULO;
            case Token.PLUS -> TurbineOperatorKind.PLUS;
            case Token.MINUS -> TurbineOperatorKind.MINUS;
            case Token.LTLT -> TurbineOperatorKind.SHIFT_LEFT;
            case Token.GTGT -> TurbineOperatorKind.SHIFT_RIGHT;
            case Token.GTGTGT -> TurbineOperatorKind.UNSIGNED_SHIFT_RIGHT;
            case Token.LT -> TurbineOperatorKind.LESS_THAN;
            case Token.GT -> TurbineOperatorKind.GREATER_THAN;
            case Token.LTE -> TurbineOperatorKind.LESS_THAN_EQ;
            case Token.GTE -> TurbineOperatorKind.GREATER_THAN_EQ;
            case Token.EQ -> TurbineOperatorKind.EQUAL;
            case Token.NOTEQ -> TurbineOperatorKind.NOT_EQUAL;
            case Token.AND -> TurbineOperatorKind.BITWISE_AND;
            case Token.OR -> TurbineOperatorKind.BITWISE_OR;
            case Token.XOR -> TurbineOperatorKind.BITWISE_XOR;
            case Token.ANDAND -> TurbineOperatorKind.AND;
            case Token.OROR -> TurbineOperatorKind.OR;
            case Token.COND -> TurbineOperatorKind.TERNARY;
            default -> null;
        };
    }

    private  @Nullable Tree.Expression primary(boolean negate) {
        return switch (this.token) {
            case Token.INT_LITERAL -> this.finishLiteral(TurbineConstantTypeKind.INT, negate);
            case Token.DOUBLE_LITERAL -> this.finishLiteral(TurbineConstantTypeKind.DOUBLE, negate);
            case Token.LONG_LITERAL -> this.finishLiteral(TurbineConstantTypeKind.LONG, negate);
            case Token.FLOAT_LITERAL -> this.finishLiteral(TurbineConstantTypeKind.FLOAT, negate);
            case Token.TRUE -> {
                int pos = this.position;
                this.eat();
                yield new Tree.Literal(pos, TurbineConstantTypeKind.BOOLEAN, new Const.BooleanValue(true));
            }
            case Token.FALSE -> {
                int pos = this.position;
                this.eat();
                yield new Tree.Literal(pos, TurbineConstantTypeKind.BOOLEAN, new Const.BooleanValue(false));
            }
            case Token.CHAR_LITERAL -> this.finishLiteral(TurbineConstantTypeKind.CHAR, negate);
            case Token.STRING_LITERAL -> this.finishLiteral(TurbineConstantTypeKind.STRING, false);
            case Token.PLUS -> {
                this.eat();
                yield this.unaryRest(TurbineOperatorKind.UNARY_PLUS);
            }
            case Token.MINUS -> {
                this.eat();
                yield this.unaryRest(TurbineOperatorKind.NEG);
            }
            case Token.NOT -> {
                this.eat();
                yield this.unaryRest(TurbineOperatorKind.NOT);
            }
            case Token.TILDE -> {
                this.eat();
                yield this.unaryRest(TurbineOperatorKind.BITWISE_COMP);
            }
            case Token.LPAREN -> this.maybeCast();
            case Token.LBRACE -> {
                int pos = this.position;
                this.eat();
                yield this.arrayInitializer(pos);
            }
            case Token.IDENT -> this.qualIdent();
            case Token.BYTE -> this.primitiveClassLiteral(TurbineConstantTypeKind.BYTE);
            case Token.CHAR -> this.primitiveClassLiteral(TurbineConstantTypeKind.CHAR);
            case Token.DOUBLE -> this.primitiveClassLiteral(TurbineConstantTypeKind.DOUBLE);
            case Token.FLOAT -> this.primitiveClassLiteral(TurbineConstantTypeKind.FLOAT);
            case Token.INT -> this.primitiveClassLiteral(TurbineConstantTypeKind.INT);
            case Token.LONG -> this.primitiveClassLiteral(TurbineConstantTypeKind.LONG);
            case Token.SHORT -> this.primitiveClassLiteral(TurbineConstantTypeKind.SHORT);
            case Token.BOOLEAN -> this.primitiveClassLiteral(TurbineConstantTypeKind.BOOLEAN);
            case Token.VOID -> {
                this.eat();
                yield this.finishClassLiteral(this.position, new Tree.VoidTy(this.position));
            }
            case Token.AT -> this.annotation();
            default -> null;
        };
    }

    private Tree.Expression primitiveClassLiteral(TurbineConstantTypeKind type) {
        this.eat();
        return this.finishClassLiteral(this.position, new Tree.PrimTy(this.position, (ImmutableList<Tree.Anno>)ImmutableList.of(), type));
    }

    private Tree.Expression maybeCast() {
        this.eat();
        return switch (this.token) {
            case Token.BOOLEAN -> {
                this.eat();
                yield this.castTail(TurbineConstantTypeKind.BOOLEAN);
            }
            case Token.BYTE -> {
                this.eat();
                yield this.castTail(TurbineConstantTypeKind.BYTE);
            }
            case Token.SHORT -> {
                this.eat();
                yield this.castTail(TurbineConstantTypeKind.SHORT);
            }
            case Token.INT -> {
                this.eat();
                yield this.castTail(TurbineConstantTypeKind.INT);
            }
            case Token.LONG -> {
                this.eat();
                yield this.castTail(TurbineConstantTypeKind.LONG);
            }
            case Token.CHAR -> {
                this.eat();
                yield this.castTail(TurbineConstantTypeKind.CHAR);
            }
            case Token.DOUBLE -> {
                this.eat();
                yield this.castTail(TurbineConstantTypeKind.DOUBLE);
            }
            case Token.FLOAT -> {
                this.eat();
                yield this.castTail(TurbineConstantTypeKind.FLOAT);
            }
            default -> this.maybeStringCast();
        };
    }

    private  @Nullable Tree.Expression maybeStringCast() {
        Tree.Expression expr = this.expression(null);
        if (expr == null) {
            return null;
        }
        if (this.token != Token.RPAREN) {
            return null;
        }
        this.eat();
        if (expr.kind() == Tree.Kind.CONST_VAR_NAME) {
            Tree.ConstVarName cvar = (Tree.ConstVarName)expr;
            return switch (this.token) {
                case Token.STRING_LITERAL, Token.LPAREN, Token.IDENT -> {
                    Tree.Expression expression = this.primary(false);
                    if (expression == null) {
                        yield null;
                    }
                    yield new Tree.TypeCast(this.position, ConstExpressionParser.asClassTy(cvar.position(), cvar.name()), expression);
                }
                default -> new Tree.Paren(this.position, expr);
            };
        }
        return new Tree.Paren(this.position, expr);
    }

    private static Tree.ClassTy asClassTy(int pos, ImmutableList<Tree.Ident> names) {
        Tree.ClassTy cty = null;
        for (Tree.Ident bit : names) {
            cty = new Tree.ClassTy(pos, Optional.ofNullable(cty), bit, (ImmutableList<Tree.Type>)ImmutableList.of(), (ImmutableList<Tree.Anno>)ImmutableList.of());
        }
        return cty;
    }

    private void eat() {
        this.token = this.lexer.next();
        this.position = this.lexer.position();
    }

    private  @Nullable Tree.Expression arrayInitializer(int pos) {
        if (this.token == Token.RBRACE) {
            this.eat();
            return new Tree.ArrayInit(pos, (ImmutableList<Tree.Expression>)ImmutableList.of());
        }
        ImmutableList.Builder exprs = ImmutableList.builder();
        block4: while (true) {
            if (this.token == Token.RBRACE) {
                this.eat();
                break;
            }
            Tree.Expression item = this.expression(null);
            if (item == null) {
                return null;
            }
            exprs.add((Object)item);
            switch (this.token) {
                case COMMA: {
                    this.eat();
                    break;
                }
                case RBRACE: {
                    this.eat();
                    break block4;
                }
                default: {
                    return null;
                }
            }
        }
        return new Tree.ArrayInit(pos, (ImmutableList<Tree.Expression>)exprs.build());
    }

    private Tree.Expression finishLiteral(TurbineConstantTypeKind kind, boolean negate) {
        Const.Value value;
        int pos = this.position;
        Object text = this.ident().value();
        switch (kind) {
            case INT: {
                int radix = 10;
                if (((String)text).startsWith("0x") || ((String)text).startsWith("0X")) {
                    text = ((String)text).substring(2);
                    radix = 16;
                } else if (ConstExpressionParser.isOctal((String)text)) {
                    radix = 8;
                } else if (((String)text).startsWith("0b") || ((String)text).startsWith("0B")) {
                    text = ((String)text).substring(2);
                    radix = 2;
                }
                if (negate) {
                    text = "-" + (String)text;
                }
                long longValue = this.parseLong((String)text, radix);
                if (radix == 10 ? longValue != (long)((int)longValue) : Math.abs(longValue) >> 32 != 0L) {
                    throw this.error(TurbineError.ErrorKind.INVALID_LITERAL, text);
                }
                value = new Const.IntValue((int)longValue);
                break;
            }
            case LONG: {
                int radix = 10;
                if (((String)text).startsWith("0x") || ((String)text).startsWith("0X")) {
                    text = ((String)text).substring(2);
                    radix = 16;
                } else if (ConstExpressionParser.isOctal((String)text)) {
                    radix = 8;
                } else if (((String)text).startsWith("0b") || ((String)text).startsWith("0B")) {
                    text = ((String)text).substring(2);
                    radix = 2;
                }
                if (negate) {
                    text = "-" + (String)text;
                }
                if (((String)text).endsWith("L") || ((String)text).endsWith("l")) {
                    text = ((String)text).substring(0, ((String)text).length() - 1);
                }
                value = new Const.LongValue(this.parseLong((String)text, radix));
                break;
            }
            case CHAR: {
                value = new Const.CharValue(((String)text).charAt(0));
                break;
            }
            case FLOAT: {
                try {
                    value = new Const.FloatValue(Float.parseFloat(((String)text).replace("_", "")));
                    break;
                }
                catch (NumberFormatException e) {
                    throw this.error(TurbineError.ErrorKind.INVALID_LITERAL, text);
                }
            }
            case DOUBLE: {
                try {
                    value = new Const.DoubleValue(Double.parseDouble(((String)text).replace("_", "")));
                    break;
                }
                catch (NumberFormatException e) {
                    throw this.error(TurbineError.ErrorKind.INVALID_LITERAL, text);
                }
            }
            case STRING: {
                value = new Const.StringValue((String)text);
                break;
            }
            default: {
                throw new AssertionError((Object)kind);
            }
        }
        this.eat();
        return new Tree.Literal(pos, kind, value);
    }

    static boolean isOctal(String text) {
        if (!text.startsWith("0")) {
            return false;
        }
        if (text.length() <= 1) {
            return false;
        }
        char next = text.charAt(1);
        return Character.isDigit(next) || next == '_';
    }

    private long parseLong(String text, int radix) {
        long r = 0L;
        boolean neg = text.startsWith("-");
        if (neg) {
            text = text.substring(1);
        }
        for (int i = 0; i < text.length(); ++i) {
            int digit;
            char c = text.charAt(i);
            if ('0' <= c && c <= '9') {
                digit = c - 48;
            } else if ('a' <= c && c <= 'f') {
                digit = 10 + (c - 97);
            } else if ('A' <= c && c <= 'F') {
                digit = 10 + (c - 65);
            } else {
                if (c == '_') continue;
                throw this.error(TurbineError.ErrorKind.INVALID_LITERAL, text);
            }
            r = r * (long)radix + (long)digit;
        }
        if (neg) {
            r = -r;
        }
        return r;
    }

    private  @Nullable Tree.Expression unaryRest(TurbineOperatorKind op) {
        boolean negate = op == TurbineOperatorKind.NEG;
        Tree.Expression expr = this.primary(negate);
        if (expr == null) {
            return null;
        }
        if (negate && expr.kind() == Tree.Kind.LITERAL) {
            Tree.Literal lit = (Tree.Literal)expr;
            switch (lit.tykind()) {
                case INT: 
                case LONG: {
                    return expr;
                }
            }
        }
        return new Tree.Unary(this.position, expr, op);
    }

    private  @Nullable Tree.Expression qualIdent() {
        int pos = this.position;
        ImmutableList.Builder bits = ImmutableList.builder();
        bits.add((Object)this.ident());
        this.eat();
        while (this.token == Token.DOT) {
            this.eat();
            switch (this.token) {
                case IDENT: {
                    bits.add((Object)this.ident());
                    break;
                }
                case CLASS: {
                    this.eat();
                    return new Tree.ClassLiteral(pos, ConstExpressionParser.asClassTy(pos, (ImmutableList<Tree.Ident>)bits.build()));
                }
                default: {
                    return null;
                }
            }
            this.eat();
        }
        if (this.token == Token.LBRACK) {
            return this.finishClassLiteral(pos, ConstExpressionParser.asClassTy(pos, (ImmutableList<Tree.Ident>)bits.build()));
        }
        return new Tree.ConstVarName(pos, (ImmutableList<Tree.Ident>)bits.build());
    }

    private Tree.Ident ident() {
        return new Tree.Ident(this.lexer.position(), this.lexer.stringValue());
    }

    private  @Nullable Tree.Expression finishClassLiteral(int pos, Tree.Type type) {
        while (this.token == Token.LBRACK) {
            this.eat();
            if (this.token != Token.RBRACK) {
                return null;
            }
            this.eat();
            type = new Tree.ArrTy(this.position, (ImmutableList<Tree.Anno>)ImmutableList.of(), type);
        }
        if (this.token != Token.DOT) {
            return null;
        }
        this.eat();
        if (this.token != Token.CLASS) {
            return null;
        }
        this.eat();
        return new Tree.ClassLiteral(pos, type);
    }

    public  @Nullable Tree.Expression expression() {
        Tree.Expression result = this.expression(null);
        return switch (this.token) {
            case Token.COMMA, Token.EOF, Token.SEMI, Token.RPAREN -> result;
            default -> null;
        };
    }

    private  @Nullable Tree.Expression expression(TurbineOperatorKind.Precedence prec) {
        Tree.Expression term1 = this.primary(false);
        if (term1 == null) {
            return null;
        }
        return this.expression(term1, prec);
    }

    private  @Nullable Tree.Expression expression(Tree.Expression term1, TurbineOperatorKind.Precedence prec) {
        do {
            if (this.token == Token.EOF) {
                return term1;
            }
            TurbineOperatorKind op = ConstExpressionParser.operator(this.token);
            if (op == null) {
                return term1;
            }
            if (prec != null && op.prec().rank() <= prec.rank()) {
                return term1;
            }
            this.eat();
            switch (op) {
                case TERNARY: {
                    term1 = this.ternary(term1);
                    break;
                }
                case ASSIGN: {
                    term1 = this.assign(term1, op);
                    break;
                }
                default: {
                    int pos = this.position;
                    Tree.Expression term2 = this.expression(op.prec());
                    if (term2 == null) {
                        return null;
                    }
                    term1 = new Tree.Binary(pos, term1, term2, op);
                }
            }
        } while (term1 != null);
        return null;
    }

    private  @Nullable Tree.Expression assign(Tree.Expression term1, TurbineOperatorKind op) {
        if (!(term1 instanceof Tree.ConstVarName)) {
            return null;
        }
        Tree.ConstVarName constVarName = (Tree.ConstVarName)term1;
        ImmutableList<Tree.Ident> names = constVarName.name();
        if (names.size() > 1) {
            return null;
        }
        Tree.Ident name = (Tree.Ident)Iterables.getOnlyElement(names);
        Tree.Expression rhs = this.expression(op.prec());
        if (rhs == null) {
            return null;
        }
        return new Tree.Assign(term1.position(), name, rhs);
    }

    private  @Nullable Tree.Expression ternary(Tree.Expression term1) {
        Tree.Expression thenExpr = this.expression(TurbineOperatorKind.Precedence.TERNARY);
        if (thenExpr == null) {
            return null;
        }
        if (this.token != Token.COLON) {
            return null;
        }
        this.eat();
        Tree.Expression elseExpr = this.expression();
        if (elseExpr == null) {
            return null;
        }
        return new Tree.Conditional(this.position, term1, thenExpr, elseExpr);
    }

    private  @Nullable Tree.Expression castTail(TurbineConstantTypeKind ty) {
        if (this.token != Token.RPAREN) {
            return null;
        }
        this.eat();
        Tree.Expression rhs = this.primary(false);
        if (rhs == null) {
            return null;
        }
        return new Tree.TypeCast(this.position, new Tree.PrimTy(this.position, (ImmutableList<Tree.Anno>)ImmutableList.of(), ty), rhs);
    }

    private  @Nullable Tree.AnnoExpr annotation() {
        if (this.token != Token.AT) {
            throw new AssertionError();
        }
        this.eat();
        int pos = this.position;
        Tree.Expression qualIdent = this.qualIdent();
        if (!(qualIdent instanceof Tree.ConstVarName)) {
            return null;
        }
        Tree.ConstVarName constVarName = (Tree.ConstVarName)qualIdent;
        ImmutableList<Tree.Ident> name = constVarName.name();
        ImmutableList.Builder args = ImmutableList.builder();
        if (this.token == Token.LPAREN) {
            this.eat();
            while (this.token != Token.RPAREN) {
                int argPos = this.position;
                Tree.Expression expression = this.expression();
                if (expression == null) {
                    throw TurbineError.format(this.lexer.source(), argPos, TurbineError.ErrorKind.INVALID_ANNOTATION_ARGUMENT, new Object[0]);
                }
                args.add((Object)expression);
                if (this.token != Token.COMMA) break;
                this.eat();
            }
            if (this.token == Token.RPAREN) {
                this.eat();
            }
        }
        return new Tree.AnnoExpr(pos, new Tree.Anno(pos, name, (ImmutableList<Tree.Expression>)args.build()));
    }

    @CheckReturnValue
    private TurbineError error(TurbineError.ErrorKind kind, Object ... args) {
        return TurbineError.format(this.lexer.source(), this.lexer.position(), kind, args);
    }

    public int f() {
        return this.helper(1, 2);
    }

    private int helper(int x, int y) {
        return x + y;
    }
}

