/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.options;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.turbine.options.LanguageVersion;
import com.google.turbine.options.TurbineOptions;
import java.util.Optional;

class AutoBuilder_TurbineOptions_Builder
extends TurbineOptions.Builder {
    private ImmutableList<String> sources;
    private ImmutableList<String> classPath;
    private ImmutableSet<String> bootClassPath;
    private LanguageVersion languageVersion;
    private Optional<String> system = Optional.empty();
    private Optional<String> output = Optional.empty();
    private Optional<String> headerCompilationOutput = Optional.empty();
    private ImmutableList<String> processorPath;
    private ImmutableSet<String> processors;
    private ImmutableSet<String> builtinProcessors;
    private ImmutableList<String> sourceJars;
    private Optional<String> outputDeps = Optional.empty();
    private Optional<String> outputManifest = Optional.empty();
    private ImmutableSet<String> directJars;
    private Optional<String> targetLabel = Optional.empty();
    private Optional<String> injectingRuleKind = Optional.empty();
    private ImmutableList<String> depsArtifacts;
    private boolean help;
    private ImmutableList.Builder<String> javacOptsBuilder$;
    private ImmutableList<String> javacOpts;
    private TurbineOptions.ReducedClasspathMode reducedClasspathMode;
    private Optional<String> profile = Optional.empty();
    private Optional<String> gensrcOutput = Optional.empty();
    private Optional<String> resourceOutput = Optional.empty();
    private int fullClasspathLength;
    private int reducedClasspathLength;
    private byte set$0;

    AutoBuilder_TurbineOptions_Builder() {
    }

    AutoBuilder_TurbineOptions_Builder(TurbineOptions source) {
        this.sources = source.sources();
        this.classPath = source.classPath();
        this.bootClassPath = source.bootClassPath();
        this.languageVersion = source.languageVersion();
        this.system = source.system();
        this.output = source.output();
        this.headerCompilationOutput = source.headerCompilationOutput();
        this.processorPath = source.processorPath();
        this.processors = source.processors();
        this.builtinProcessors = source.builtinProcessors();
        this.sourceJars = source.sourceJars();
        this.outputDeps = source.outputDeps();
        this.outputManifest = source.outputManifest();
        this.directJars = source.directJars();
        this.targetLabel = source.targetLabel();
        this.injectingRuleKind = source.injectingRuleKind();
        this.depsArtifacts = source.depsArtifacts();
        this.help = source.help();
        this.javacOpts = source.javacOpts();
        this.reducedClasspathMode = source.reducedClasspathMode();
        this.profile = source.profile();
        this.gensrcOutput = source.gensrcOutput();
        this.resourceOutput = source.resourceOutput();
        this.fullClasspathLength = source.fullClasspathLength();
        this.reducedClasspathLength = source.reducedClasspathLength();
        this.set$0 = (byte)7;
    }

    @Override
    public TurbineOptions.Builder setSources(ImmutableList<String> sources) {
        if (sources == null) {
            throw new NullPointerException("Null sources");
        }
        this.sources = sources;
        return this;
    }

    @Override
    public TurbineOptions.Builder setClassPath(ImmutableList<String> classPath) {
        if (classPath == null) {
            throw new NullPointerException("Null classPath");
        }
        this.classPath = classPath;
        return this;
    }

    @Override
    public TurbineOptions.Builder setBootClassPath(ImmutableList<String> bootClassPath) {
        this.bootClassPath = ImmutableSet.copyOf(bootClassPath);
        return this;
    }

    @Override
    public TurbineOptions.Builder setLanguageVersion(LanguageVersion languageVersion) {
        if (languageVersion == null) {
            throw new NullPointerException("Null languageVersion");
        }
        this.languageVersion = languageVersion;
        return this;
    }

    @Override
    public TurbineOptions.Builder setSystem(String system) {
        this.system = Optional.of(system);
        return this;
    }

    @Override
    public TurbineOptions.Builder setOutput(String output) {
        this.output = Optional.of(output);
        return this;
    }

    @Override
    public TurbineOptions.Builder setHeaderCompilationOutput(String headerCompilationOutput) {
        this.headerCompilationOutput = Optional.of(headerCompilationOutput);
        return this;
    }

    @Override
    public TurbineOptions.Builder setProcessorPath(ImmutableList<String> processorPath) {
        if (processorPath == null) {
            throw new NullPointerException("Null processorPath");
        }
        this.processorPath = processorPath;
        return this;
    }

    @Override
    public TurbineOptions.Builder setProcessors(ImmutableList<String> processors) {
        this.processors = ImmutableSet.copyOf(processors);
        return this;
    }

    @Override
    public TurbineOptions.Builder setBuiltinProcessors(ImmutableList<String> builtinProcessors) {
        this.builtinProcessors = ImmutableSet.copyOf(builtinProcessors);
        return this;
    }

    @Override
    public TurbineOptions.Builder setSourceJars(ImmutableList<String> sourceJars) {
        if (sourceJars == null) {
            throw new NullPointerException("Null sourceJars");
        }
        this.sourceJars = sourceJars;
        return this;
    }

    @Override
    public TurbineOptions.Builder setOutputDeps(String outputDeps) {
        this.outputDeps = Optional.of(outputDeps);
        return this;
    }

    @Override
    public TurbineOptions.Builder setOutputManifest(String outputManifest) {
        this.outputManifest = Optional.of(outputManifest);
        return this;
    }

    @Override
    public TurbineOptions.Builder setDirectJars(ImmutableList<String> directJars) {
        this.directJars = ImmutableSet.copyOf(directJars);
        return this;
    }

    @Override
    public TurbineOptions.Builder setTargetLabel(String targetLabel) {
        this.targetLabel = Optional.of(targetLabel);
        return this;
    }

    @Override
    public TurbineOptions.Builder setInjectingRuleKind(String injectingRuleKind) {
        this.injectingRuleKind = Optional.of(injectingRuleKind);
        return this;
    }

    @Override
    public TurbineOptions.Builder setDepsArtifacts(ImmutableList<String> depsArtifacts) {
        if (depsArtifacts == null) {
            throw new NullPointerException("Null depsArtifacts");
        }
        this.depsArtifacts = depsArtifacts;
        return this;
    }

    @Override
    public TurbineOptions.Builder setHelp(boolean help) {
        this.help = help;
        this.set$0 = (byte)(this.set$0 | 1);
        return this;
    }

    @Override
    ImmutableList.Builder<String> javacOptsBuilder() {
        if (this.javacOptsBuilder$ == null) {
            if (this.javacOpts == null) {
                this.javacOptsBuilder$ = ImmutableList.builder();
            } else {
                this.javacOptsBuilder$ = ImmutableList.builder();
                this.javacOptsBuilder$.addAll(this.javacOpts);
                this.javacOpts = null;
            }
        }
        return this.javacOptsBuilder$;
    }

    @Override
    public TurbineOptions.Builder setReducedClasspathMode(TurbineOptions.ReducedClasspathMode reducedClasspathMode) {
        if (reducedClasspathMode == null) {
            throw new NullPointerException("Null reducedClasspathMode");
        }
        this.reducedClasspathMode = reducedClasspathMode;
        return this;
    }

    @Override
    public TurbineOptions.Builder setProfile(String profile) {
        this.profile = Optional.of(profile);
        return this;
    }

    @Override
    public TurbineOptions.Builder setGensrcOutput(String gensrcOutput) {
        this.gensrcOutput = Optional.of(gensrcOutput);
        return this;
    }

    @Override
    public TurbineOptions.Builder setResourceOutput(String resourceOutput) {
        this.resourceOutput = Optional.of(resourceOutput);
        return this;
    }

    @Override
    public TurbineOptions.Builder setFullClasspathLength(int fullClasspathLength) {
        this.fullClasspathLength = fullClasspathLength;
        this.set$0 = (byte)(this.set$0 | 2);
        return this;
    }

    @Override
    public TurbineOptions.Builder setReducedClasspathLength(int reducedClasspathLength) {
        this.reducedClasspathLength = reducedClasspathLength;
        this.set$0 = (byte)(this.set$0 | 4);
        return this;
    }

    @Override
    public TurbineOptions build() {
        if (this.javacOptsBuilder$ != null) {
            this.javacOpts = this.javacOptsBuilder$.build();
        } else if (this.javacOpts == null) {
            this.javacOpts = ImmutableList.of();
        }
        if (this.set$0 != 7 || this.sources == null || this.classPath == null || this.bootClassPath == null || this.languageVersion == null || this.processorPath == null || this.processors == null || this.builtinProcessors == null || this.sourceJars == null || this.directJars == null || this.depsArtifacts == null || this.reducedClasspathMode == null) {
            StringBuilder missing = new StringBuilder();
            if (this.sources == null) {
                missing.append(" sources");
            }
            if (this.classPath == null) {
                missing.append(" classPath");
            }
            if (this.bootClassPath == null) {
                missing.append(" bootClassPath");
            }
            if (this.languageVersion == null) {
                missing.append(" languageVersion");
            }
            if (this.processorPath == null) {
                missing.append(" processorPath");
            }
            if (this.processors == null) {
                missing.append(" processors");
            }
            if (this.builtinProcessors == null) {
                missing.append(" builtinProcessors");
            }
            if (this.sourceJars == null) {
                missing.append(" sourceJars");
            }
            if (this.directJars == null) {
                missing.append(" directJars");
            }
            if (this.depsArtifacts == null) {
                missing.append(" depsArtifacts");
            }
            if ((this.set$0 & 1) == 0) {
                missing.append(" help");
            }
            if (this.reducedClasspathMode == null) {
                missing.append(" reducedClasspathMode");
            }
            if ((this.set$0 & 2) == 0) {
                missing.append(" fullClasspathLength");
            }
            if ((this.set$0 & 4) == 0) {
                missing.append(" reducedClasspathLength");
            }
            throw new IllegalStateException("Missing required properties:" + String.valueOf(missing));
        }
        return new TurbineOptions(this.sources, this.classPath, this.bootClassPath, this.languageVersion, this.system, this.output, this.headerCompilationOutput, this.processorPath, this.processors, this.builtinProcessors, this.sourceJars, this.outputDeps, this.outputManifest, this.directJars, this.targetLabel, this.injectingRuleKind, this.depsArtifacts, this.help, this.javacOpts, this.reducedClasspathMode, this.profile, this.gensrcOutput, this.resourceOutput, this.fullClasspathLength, this.reducedClasspathLength);
    }
}

