/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.turbine.binder.bound.SourceTypeBoundClass;
import com.google.turbine.binder.env.Env;
import com.google.turbine.binder.env.SimpleEnv;
import com.google.turbine.binder.sym.ClassSymbol;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

final class PermitsBinder {
    static Env<ClassSymbol, SourceTypeBoundClass> bindPermits(ImmutableSet<ClassSymbol> syms, Env<ClassSymbol, SourceTypeBoundClass> tenv) {
        HashSet<ClassSymbol> sealedClassesWithoutExplicitPermits = new HashSet<ClassSymbol>();
        for (ClassSymbol sym : syms) {
            SourceTypeBoundClass info = tenv.getNonNull(sym);
            if ((info.access() & 0x80000) != 524288 || !info.permits().isEmpty()) continue;
            sealedClassesWithoutExplicitPermits.add(sym);
        }
        if (sealedClassesWithoutExplicitPermits.isEmpty()) {
            return tenv;
        }
        ListMultimap permits = MultimapBuilder.hashKeys().arrayListValues().build();
        for (ClassSymbol sym : syms) {
            SourceTypeBoundClass info = tenv.getNonNull(sym);
            ClassSymbol superclass = info.superclass();
            if (superclass != null && sealedClassesWithoutExplicitPermits.contains(superclass)) {
                permits.put((Object)superclass, (Object)sym);
            }
            for (ClassSymbol i : info.interfaces()) {
                if (!sealedClassesWithoutExplicitPermits.contains(i)) continue;
                permits.put((Object)i, (Object)sym);
            }
        }
        SimpleEnv.Builder<ClassSymbol, SourceTypeBoundClass> builder = SimpleEnv.builder();
        for (ClassSymbol sym : syms) {
            List thisPermits = permits.get((Object)sym);
            SourceTypeBoundClass base = tenv.getNonNull(sym);
            if (thisPermits.isEmpty()) {
                builder.put(sym, base);
                continue;
            }
            builder.put(sym, new SourceTypeBoundClass(base.interfaceTypes(), (ImmutableList<ClassSymbol>)ImmutableList.copyOf((Collection)thisPermits), base.superClassType(), base.typeParameterTypes(), base.access(), base.components(), base.methods(), base.fields(), base.owner(), base.kind(), base.children(), base.typeParameters(), base.enclosingScope(), base.scope(), base.memberImports(), base.annotationMetadata(), base.annotations(), base.source(), base.decl()));
        }
        return builder.build();
    }

    private PermitsBinder() {
    }
}

