/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.util;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.util.ErrorProneComment;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.util.Name;

public class ErrorProneToken {
    private final Tokens.Token token;
    private final int offset;
    private final ImmutableList<ErrorProneComment> comments;

    ErrorProneToken(Tokens.Token token, int offset, ImmutableList<ErrorProneComment> comments) {
        this.token = token;
        this.offset = offset;
        this.comments = comments;
    }

    public Tokens.TokenKind kind() {
        return this.token.kind;
    }

    public int pos() {
        return this.offset + this.token.pos;
    }

    public int endPos() {
        return this.offset + this.token.endPos;
    }

    public ImmutableList<ErrorProneComment> comments() {
        return (ImmutableList)this.comments.stream().map(c -> c.withOffset(this.offset)).collect(ImmutableList.toImmutableList());
    }

    public boolean hasName() {
        return this.token.getClass().getSimpleName().contentEquals("NamedToken");
    }

    public boolean hasStringVal() {
        String name = this.token.getClass().getSimpleName();
        return name.contentEquals("StringToken") || name.contentEquals("NumericToken");
    }

    public boolean hasRadix() {
        return this.token.getClass().getSimpleName().contentEquals("NumericToken");
    }

    public Name name() {
        return this.token.name();
    }

    public String stringVal() {
        return this.token.stringVal();
    }

    public int radix() {
        return this.token.radix();
    }

    public String toString() {
        return this.token.toString();
    }
}

