/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.matchers;

import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.CompileTimeConstant;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.tools.javac.code.Symbol;
import javax.lang.model.element.ElementKind;

public class CompileTimeConstantExpressionMatcher
implements Matcher<ExpressionTree> {
    private static final Supplier<Symbol> COMPILE_TIME_CONSTANT_ANNOTATION = VisitorState.memoize(state -> state.getSymbolFromString(CompileTimeConstant.class.getName()));
    private static final Matcher<ExpressionTree> INSTANCE = Matchers.anyOf(new ExpressionWithConstValueMatcher(), Matchers.nullLiteral(), Matchers.toType(TypeCastTree.class, Matchers.typeCast(Matchers.anything(), Matchers.nullLiteral())));
    private static final Matcher<ExpressionTree> IMMUTABLE_FACTORY = Matchers.anyOf(Matchers.staticMethod().onClass("com.google.common.collect.ImmutableList").named("of"), Matchers.staticMethod().onClass("com.google.common.collect.ImmutableSet").named("of"));

    public static Matcher<ExpressionTree> instance() {
        return INSTANCE;
    }

    @Override
    public boolean matches(ExpressionTree t, VisitorState state) {
        return INSTANCE.matches(t, state);
    }

    public static boolean hasCompileTimeConstantAnnotation(VisitorState state, Symbol symbol) {
        Symbol annotation = COMPILE_TIME_CONSTANT_ANNOTATION.get(state);
        return annotation != null && symbol.attribute(annotation) != null;
    }

    private static final class ExpressionWithConstValueMatcher
    implements Matcher<ExpressionTree> {
        private ExpressionWithConstValueMatcher() {
        }

        @Override
        public boolean matches(ExpressionTree tree, final VisitorState state) {
            return tree.accept(new SimpleTreeVisitor<Boolean, Void>(){

                @Override
                public Boolean visitConditionalExpression(ConditionalExpressionTree tree, Void unused) {
                    return tree.getTrueExpression().accept(this, null) != false && tree.getFalseExpression().accept(this, null) != false;
                }

                @Override
                public Boolean visitMethodInvocation(MethodInvocationTree tree, Void unused) {
                    return IMMUTABLE_FACTORY.matches(tree, state) && tree.getArguments().stream().allMatch(a -> a.accept(this, null));
                }

                @Override
                public Boolean visitBinary(BinaryTree tree, Void unused) {
                    return this.defaultAction((Tree)tree, null) != false || tree.getKind().equals((Object)Tree.Kind.PLUS) && tree.getLeftOperand().accept(this, null) != false && tree.getRightOperand().accept(this, null) != false;
                }

                @Override
                public Boolean visitParenthesized(ParenthesizedTree tree, Void unused) {
                    return tree.getExpression().accept(this, null);
                }

                @Override
                protected Boolean defaultAction(Tree node, Void unused) {
                    if (ASTHelpers.constValue(node) != null) {
                        return true;
                    }
                    if (!(node instanceof IdentifierTree)) {
                        return false;
                    }
                    Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)ASTHelpers.getSymbol(node);
                    Symbol owner = varSymbol.owner;
                    ElementKind ownerKind = owner.getKind();
                    if (ownerKind != ElementKind.METHOD && ownerKind != ElementKind.CONSTRUCTOR && ownerKind != ElementKind.CLASS && ownerKind != ElementKind.ENUM) {
                        return false;
                    }
                    if (!ASTHelpers.isConsideredFinal(varSymbol)) {
                        return false;
                    }
                    if (CompileTimeConstantExpressionMatcher.hasCompileTimeConstantAnnotation(state, varSymbol)) {
                        return true;
                    }
                    return false;
                }
            }, null);
        }
    }
}

