/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.ElementTypesAreNonnullByDefault;
import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.SampleElements;
import com.google.common.collect.testing.TestContainerGenerator;
import com.google.common.collect.testing.features.CollectionSize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class OneSizeGenerator<T, E>
implements OneSizeTestContainerGenerator<T, E> {
    private final TestContainerGenerator<T, E> generator;
    private final CollectionSize collectionSize;

    public OneSizeGenerator(TestContainerGenerator<T, E> generator, CollectionSize collectionSize) {
        this.generator = generator;
        this.collectionSize = collectionSize;
    }

    @Override
    public TestContainerGenerator<T, E> getInnerGenerator() {
        return this.generator;
    }

    @Override
    public SampleElements<E> samples() {
        return this.generator.samples();
    }

    @Override
    public T create(Object ... elements) {
        return this.generator.create(elements);
    }

    @Override
    public E[] createArray(int length) {
        return this.generator.createArray(length);
    }

    @Override
    public T createTestSubject() {
        Collection<E> elements = this.getSampleElements(this.getCollectionSize().getNumElements());
        return this.generator.create(elements.toArray());
    }

    @Override
    public Collection<E> getSampleElements(int howMany) {
        SampleElements<E> samples = this.samples();
        List<Object> allSampleElements = Arrays.asList(samples.e0(), samples.e1(), samples.e2(), samples.e3(), samples.e4());
        return new ArrayList<Object>(allSampleElements.subList(0, howMany));
    }

    @Override
    public CollectionSize getCollectionSize() {
        return this.collectionSize;
    }

    @Override
    public Iterable<E> order(List<E> insertionOrder) {
        return this.generator.order(insertionOrder);
    }
}

